/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.dataexporter.output.csv;

import com.brsanthu.dataexporter.output.csv.CsvExportOptions;
import com.brsanthu.dataexporter.output.text.TextExportOptions;
import com.brsanthu.dataexporter.output.text.TextWriter;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;

public class CsvWriter
extends TextWriter {
    public CsvWriter(CsvExportOptions options) {
        super((TextExportOptions)options, (OutputStream)System.out);
    }

    public CsvWriter(CsvExportOptions options, OutputStream out) {
        super((TextExportOptions)options, out);
    }

    public CsvWriter(OutputStream out) {
        super((TextExportOptions)new CsvExportOptions(), out);
    }

    public CsvWriter(CsvExportOptions options, Writer out) {
        super((TextExportOptions)options, out);
    }

    public CsvWriter(Writer out) {
        super((TextExportOptions)new CsvExportOptions(), out);
    }

    @Override
    public void writeCell(int i, String cellValue) {
        String delimiter = this.getCsvExportOptions().getDelimiter();
        if (i != 0) {
            this.print(delimiter);
        }
        if (this.getCsvExportOptions().isStrictQuoting() || cellValue.indexOf(this.getCsvExportOptions().getQuote()) >= 0 || cellValue.indexOf(delimiter) >= 0 || cellValue.indexOf("\n") >= 0) {
            String quote = this.getCsvExportOptions().getQuote();
            cellValue = StringUtils.replace((String)cellValue, (String)quote, (String)(quote + quote));
            cellValue = quote + cellValue + quote;
        }
        this.print(cellValue);
    }

    public CsvExportOptions getCsvExportOptions() {
        return (CsvExportOptions)this.getOptions();
    }
}

