/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.dataexporter.model;

import com.brsanthu.dataexporter.model.AlignType;
import com.brsanthu.dataexporter.model.CellDetails;
import com.brsanthu.dataexporter.model.Column;
import com.brsanthu.dataexporter.util.Util;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class NumberColumn
extends Column {
    private NumberFormat formatter = null;
    private int precision = 2;
    private boolean grouping = true;
    private boolean bracketNegitive = false;

    public NumberColumn(String name, String title, int width, NumberFormat formatter) {
        this(name, title, width, AlignType.MIDDLE_RIGHT, formatter);
    }

    public NumberColumn(String name, String title, int width, int precision) {
        this(name, title, width, AlignType.MIDDLE_RIGHT, precision);
    }

    public NumberColumn(String name, int width, int precision) {
        this(name, width, AlignType.MIDDLE_RIGHT, precision);
    }

    public NumberColumn(String name, int width, NumberFormat formatter) {
        this(name, null, width, AlignType.MIDDLE_RIGHT, formatter);
    }

    public NumberColumn(String name, int width, AlignType align, int precision) {
        this(name, null, width, align, precision);
    }

    public NumberColumn(String name, String title, int width, AlignType align, int precision) {
        super(name, title, width, align);
        this.precision = precision;
    }

    public NumberColumn(String name, String title, int width, AlignType align, NumberFormat formatter) {
        super(name, title, width, align);
        this.formatter = formatter;
    }

    public int getPrecision() {
        return this.precision;
    }

    public NumberColumn setPrecision(int precision) {
        this.precision = precision;
        return this;
    }

    public boolean isGrouping() {
        return this.grouping;
    }

    public NumberColumn setGrouping(boolean grouping) {
        this.grouping = grouping;
        return this;
    }

    public boolean isBracketNegitive() {
        return this.bracketNegitive;
    }

    public NumberColumn setBracketNegitive(boolean bracketNegitive) {
        this.bracketNegitive = bracketNegitive;
        return this;
    }

    @Override
    public int getMaxRowHeight(CellDetails cellDetails) {
        return (int)Math.ceil((float)this.format(cellDetails.getCellValue()).length() / (float)this.getWidth());
    }

    @Override
    public String format(CellDetails cellDetails) {
        return this.format(cellDetails.getCellValue());
    }

    public String format(Object value) {
        String formattedString;
        if (this.formatter == null) {
            String formatString = "";
            formatString = this.isGrouping() ? "#,###,###" : "0";
            if (this.isBracketNegitive()) {
                formatString = formatString + ";(#)";
            }
            this.formatter = this.precision > 0 ? new DecimalFormat(formatString + "." + Util.createString("0", this.precision)) : new DecimalFormat(formatString);
        }
        try {
            formattedString = this.formatter.format(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while formatting the value " + value + " of type " + value.getClass().getName() + " as number for column " + this, e);
        }
        return formattedString;
    }
}

