/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.dataexporter.model;

import com.brsanthu.dataexporter.model.AlignType;
import com.brsanthu.dataexporter.model.CellDetails;
import com.brsanthu.dataexporter.model.Column;

public class BooleanColumn
extends Column {
    private Format format = Format.YES_NO;

    public BooleanColumn(String name, int width) {
        this(name, null, width, AlignType.MIDDLE_LEFT, Format.YES_NO);
    }

    public BooleanColumn(String name, String title, int width) {
        this(name, title, width, AlignType.MIDDLE_LEFT, Format.YES_NO);
    }

    public BooleanColumn(String name, int width, AlignType align) {
        this(name, null, width, align, Format.YES_NO);
    }

    public BooleanColumn(String name, String title, int width, AlignType align, Format format) {
        super(name, title, width, align);
        this.format = format;
    }

    private String getBooleanString(boolean booleanValue) {
        switch (this.format) {
            case ONE_ZERO: {
                return booleanValue ? "1" : "0";
            }
            case TRUE_FALSE: {
                return booleanValue ? "True" : "False";
            }
            case YES_NO: {
                return booleanValue ? "Yes" : "No";
            }
        }
        return booleanValue ? "Yes" : "No";
    }

    @Override
    public int getMaxRowHeight(CellDetails cellDetails) {
        return this.getMaxRowHeight(this.getBooleanString(new Boolean(cellDetails.getCellValue().toString())));
    }

    @Override
    public String format(CellDetails cellDetails) {
        return this.getBooleanString(new Boolean(cellDetails.getCellValue().toString()));
    }

    public static enum Format {
        YES_NO,
        TRUE_FALSE,
        ONE_ZERO;

    }
}

