/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.tx.api.logging.impl.navigable;

import com.complexible.tx.api.logging.TxLogRecord;
import com.complexible.tx.api.logging.impl.navigable.DefaultNavigableDiskTxLog;
import com.complexible.tx.api.logging.impl.navigable.NavigableDiskTxLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.UUID;
import javax.annotation.Nullable;

public class SingleNavigableDiskTxLog
implements NavigableDiskTxLog {
    protected final DefaultNavigableDiskTxLog mNavigableDiskTxLog;

    public SingleNavigableDiskTxLog(DefaultNavigableDiskTxLog theTxLog) throws IOException {
        this.mNavigableDiskTxLog = theTxLog;
        this.mNavigableDiskTxLog.init();
    }

    @Override
    public synchronized boolean append(TxLogRecord theRecord) throws IOException {
        boolean didAppend = this.mNavigableDiskTxLog.append(theRecord);
        if (!didAppend) {
            boolean didRotate = this.mNavigableDiskTxLog.checkAndResetIfRotated();
            assert (didRotate) : "DefaultNavigableDiskTxLog.append should return false only if rotation happened";
            this.mNavigableDiskTxLog.init();
            return this.mNavigableDiskTxLog.append(theRecord);
        }
        return true;
    }

    @Override
    public synchronized void prohibitRotationTemporarily() {
        this.mNavigableDiskTxLog.prohibitRotationTemporarily();
    }

    @Override
    public synchronized void allowRotation() {
        this.mNavigableDiskTxLog.allowRotation();
    }

    @Override
    public synchronized long getHeaderEndOffsetInFile() {
        return this.mNavigableDiskTxLog.getHeaderEndOffsetInFile();
    }

    @Override
    public synchronized long getLastRecordEndOffsetInFile() {
        return this.mNavigableDiskTxLog.getLastRecordEndOffsetInFile();
    }

    @Override
    public synchronized void flush() throws IOException {
        this.mNavigableDiskTxLog.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.mNavigableDiskTxLog.close();
    }

    @Override
    @Nullable
    public Long getRecordBeginOffsetInFile(UUID theTxId) {
        return this.mNavigableDiskTxLog.getRecordBeginOffsetInFile(theTxId);
    }

    @Override
    @Nullable
    public Long getRecordEndOffsetInFile(UUID theTxId) {
        return this.mNavigableDiskTxLog.getRecordEndOffsetInFile(theTxId);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.mNavigableDiskTxLog.getInputStream();
    }

    @Override
    public InputStream getInputStream(UUID theStartTxId, UUID theEndTxId) throws IOException {
        InputStream aHeader = this.mNavigableDiskTxLog.asInputStream(0L, this.getHeaderEndOffsetInFile());
        InputStream aInputStream = this.mNavigableDiskTxLog.getInputStream(theStartTxId, theEndTxId);
        if (aInputStream == null) {
            return null;
        }
        return new SequenceInputStream(aHeader, aInputStream);
    }

    @Override
    public InputStream getInputStream(Long theRecordBeginOffsetInFile, UUID theEndTxId) throws IOException {
        return this.mNavigableDiskTxLog.getInputStream(theRecordBeginOffsetInFile, theEndTxId);
    }

    @Override
    public InputStream asInputStream(long theBeginOffsetInFile, long theEndOffsetInFile) throws IOException {
        return this.mNavigableDiskTxLog.asInputStream(theBeginOffsetInFile, theEndOffsetInFile);
    }

    @Override
    public synchronized void init() throws IOException {
        this.mNavigableDiskTxLog.init();
    }

    @Override
    public synchronized boolean checkAndResetIfRotated() {
        return this.mNavigableDiskTxLog.checkAndResetIfRotated();
    }

    @Override
    public boolean hasStartedTxEvent(UUID txId) {
        return this.mNavigableDiskTxLog.hasStartedTxEvent(txId);
    }
}

