/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.tx.api.logging.impl.navigable;

import com.complexible.tx.api.logging.TxLogRecord;
import com.complexible.tx.api.logging.impl.disk.SimpleDiskTxLog;
import com.complexible.tx.api.logging.impl.navigable.NavigableDiskTxLog;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public final class DefaultNavigableDiskTxLog
implements NavigableDiskTxLog {
    private final SimpleDiskTxLog mDiskTxLog;
    private boolean mRotationTemporarilyProhibited;
    private final Map<UUID, RecordOffsetsInLogFile> recordOffsets = new HashMap<UUID, RecordOffsetsInLogFile>();

    public DefaultNavigableDiskTxLog(SimpleDiskTxLog theDiskTxLog) {
        this.mDiskTxLog = theDiskTxLog;
    }

    @Override
    public synchronized boolean append(TxLogRecord theRecord) throws IOException {
        long aLastOffset = this.mDiskTxLog.getLastRecordEndOffsetInFile();
        if (this.mDiskTxLog.append(theRecord)) {
            if (theRecord.getUUID() == null) {
                return true;
            }
            long aEndOffset = this.mDiskTxLog.getLastRecordEndOffsetInFile();
            this.recordOffsets.compute(theRecord.getUUID(), (k, oldRecord) -> oldRecord == null ? new RecordOffsetsInLogFile(aLastOffset, aEndOffset, theRecord.getType(), theRecord.getType().equals((Object)TxLogRecord.RecordType.Started)) : new RecordOffsetsInLogFile(oldRecord.beginOffset, aEndOffset, theRecord.getType(), oldRecord.hasStarted));
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public synchronized Long getRecordBeginOffsetInFile(UUID theTxId) {
        RecordOffsetsInLogFile recordOffsetsInLogFile = this.recordOffsets.get(theTxId);
        return recordOffsetsInLogFile != null ? Long.valueOf(recordOffsetsInLogFile.beginOffset) : null;
    }

    @Override
    @Nullable
    public synchronized Long getRecordEndOffsetInFile(UUID theTxId) {
        RecordOffsetsInLogFile recordOffsetsInLogFile = this.recordOffsets.get(theTxId);
        if (recordOffsetsInLogFile != null && recordOffsetsInLogFile.type.equals((Object)TxLogRecord.RecordType.Done)) {
            return recordOffsetsInLogFile.endOffset;
        }
        return null;
    }

    @Override
    public synchronized long getHeaderEndOffsetInFile() {
        return this.mDiskTxLog.getHeaderEndOffsetInFile();
    }

    @Override
    public synchronized long getLastRecordEndOffsetInFile() {
        return this.mDiskTxLog.getLastRecordEndOffsetInFile();
    }

    @Override
    public synchronized void prohibitRotationTemporarily() {
        this.mRotationTemporarilyProhibited = true;
        this.mDiskTxLog.prohibitRotationTemporarily();
    }

    @Override
    public synchronized void allowRotation() {
        this.mRotationTemporarilyProhibited = false;
        this.mDiskTxLog.allowRotation();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.mDiskTxLog.asInputStream(0L, this.getLastRecordEndOffsetInFile());
    }

    @Override
    public InputStream asInputStream(long beginOffsetInFile, long endOffsetInFile) throws IOException {
        if (!this.mRotationTemporarilyProhibited) {
            throw new IllegalStateException("Rotation should be prohibited when the log data is read");
        }
        return this.mDiskTxLog.asInputStream(beginOffsetInFile, endOffsetInFile);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.mDiskTxLog.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.mDiskTxLog.close();
    }

    @Override
    public InputStream getInputStream(UUID theStartTxId, UUID theEndTxId) throws IOException {
        Long aBeginRotated = this.getRecordBeginOffsetInFile(theStartTxId);
        return this.getInputStream(aBeginRotated, theEndTxId);
    }

    @Override
    public InputStream getInputStream(Long theRecordBeginOffsetInFile, UUID theEndTxId) throws IOException {
        Long endTxEndOffset;
        if (theRecordBeginOffsetInFile == null) {
            return null;
        }
        long startOffset = theRecordBeginOffsetInFile;
        Long endTxBeginOffset = this.getRecordBeginOffsetInFile(theEndTxId);
        if (endTxBeginOffset != null && endTxBeginOffset < theRecordBeginOffsetInFile) {
            startOffset = endTxBeginOffset;
        }
        if ((endTxEndOffset = this.getRecordEndOffsetInFile(theEndTxId)) == null) {
            endTxEndOffset = this.getLastRecordEndOffsetInFile();
        }
        return this.asInputStream(startOffset, endTxEndOffset);
    }

    @Override
    public synchronized void init() throws IOException {
        this.recordOffsets.clear();
        this.mDiskTxLog.init();
    }

    @Override
    public boolean checkAndResetIfRotated() {
        return this.mDiskTxLog.checkAndResetIfRotated();
    }

    @Override
    public synchronized boolean hasStartedTxEvent(UUID txId) {
        RecordOffsetsInLogFile offset = this.recordOffsets.get(txId);
        if (offset != null) {
            return offset.hasStarted;
        }
        return false;
    }

    public static final class RecordOffsetsInLogFile {
        final boolean hasStarted;
        final TxLogRecord.RecordType type;
        final long beginOffset;
        final long endOffset;

        RecordOffsetsInLogFile(long beginOffset, long endOffset, TxLogRecord.RecordType recordType, boolean hasStarted) {
            this.beginOffset = beginOffset;
            this.endOffset = endOffset;
            this.type = recordType;
            this.hasStarted = hasStarted;
        }
    }
}

