/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.tx.api.logging.impl.navigable;

import com.complexible.tx.api.logging.TxLogRecord;
import com.complexible.tx.api.logging.impl.navigable.DefaultNavigableDiskTxLog;
import com.complexible.tx.api.logging.impl.navigable.NavigableDiskTxLog;
import com.complexible.tx.api.logging.impl.navigable.SingleNavigableDiskTxLog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CombinedNavigableDiskTxLog
extends SingleNavigableDiskTxLog {
    private static final Logger LOGGER = LoggerFactory.getLogger(CombinedNavigableDiskTxLog.class);
    private NavigableDiskTxLog mCurrentLog;
    private NavigableDiskTxLog mNextLog;
    private final NavigableDiskTxLog mSecondTransactionLog;
    private final AtomicInteger mRotatedCount = new AtomicInteger(0);

    public CombinedNavigableDiskTxLog(DefaultNavigableDiskTxLog theFirstTxLog, DefaultNavigableDiskTxLog theSecondTxLog) throws IOException {
        super(theFirstTxLog);
        this.mCurrentLog = theFirstTxLog;
        this.mNextLog = theSecondTxLog;
        this.mSecondTransactionLog = theSecondTxLog;
    }

    @Override
    public synchronized boolean append(TxLogRecord theRecord) throws IOException {
        boolean didAppend = this.mCurrentLog.append(theRecord);
        if (!didAppend) {
            this.switchLoggers();
            this.mCurrentLog.checkAndResetIfRotated();
            this.mCurrentLog.init();
            return this.mCurrentLog.append(theRecord);
        }
        assert (didAppend) : "SimpleDiskTxLog.append should return true if no rotation happened";
        return true;
    }

    @Override
    public synchronized void prohibitRotationTemporarily() {
        super.prohibitRotationTemporarily();
        this.mSecondTransactionLog.prohibitRotationTemporarily();
    }

    @Override
    public synchronized void allowRotation() {
        super.allowRotation();
        this.mSecondTransactionLog.allowRotation();
    }

    @Override
    public synchronized long getLastRecordEndOffsetInFile() {
        return this.mCurrentLog.getLastRecordEndOffsetInFile();
    }

    @Override
    public Long getRecordBeginOffsetInFile(UUID theTxId) {
        return this.mCurrentLog.getRecordBeginOffsetInFile(theTxId);
    }

    @Override
    @Nullable
    public Long getRecordEndOffsetInFile(UUID theTxId) {
        return this.mCurrentLog.getRecordEndOffsetInFile(theTxId);
    }

    @Override
    public synchronized void init() throws IOException {
        this.mCurrentLog.init();
    }

    @Override
    public synchronized boolean checkAndResetIfRotated() {
        return this.mCurrentLog.checkAndResetIfRotated();
    }

    @Override
    public synchronized void flush() throws IOException {
        this.mCurrentLog.flush();
        if (this.mCurrentLog.checkAndResetIfRotated()) {
            this.switchLoggers();
            this.mCurrentLog.init();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
        this.mSecondTransactionLog.close();
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        long beginOffset = this.mCurrentLog.getHeaderEndOffsetInFile();
        long currentEnd = this.mCurrentLog.getLastRecordEndOffsetInFile();
        if (currentEnd == beginOffset) {
            return this.mNextLog.getInputStream();
        }
        InputStream rotatedLogs = this.mNextLog.getInputStream();
        if (rotatedLogs == null) {
            return this.mCurrentLog.getInputStream();
        }
        InputStream currentLogs = this.mCurrentLog.asInputStream(beginOffset, currentEnd);
        if (currentLogs == null) {
            return rotatedLogs;
        }
        return new SequenceInputStream(rotatedLogs, currentLogs);
    }

    @Override
    public synchronized InputStream getInputStream(Long theRecordBeginOffsetInFile, UUID theEndTxId) throws IOException {
        return this.mCurrentLog.getInputStream(theRecordBeginOffsetInFile, theEndTxId);
    }

    @Override
    public synchronized InputStream asInputStream(long theBeginOffsetInFile, long theEndOffsetInFile) throws IOException {
        return this.mCurrentLog.asInputStream(theBeginOffsetInFile, theEndOffsetInFile);
    }

    @Override
    public synchronized InputStream getInputStream(UUID theStartTxId, UUID theEndTxId) throws IOException {
        Long aBeginOffset;
        InputStream aRotatedInputStream;
        boolean endInRotated;
        Preconditions.checkNotNull((Object)theStartTxId, (Object)"theStartTxId cannot be null");
        boolean startInCurrent = this.mCurrentLog.hasStartedTxEvent(theStartTxId);
        boolean startInRotated = this.mNextLog.hasStartedTxEvent(theStartTxId);
        boolean endInCurrent = theEndTxId != null && this.mCurrentLog.hasStartedTxEvent(theEndTxId);
        boolean bl = endInRotated = theEndTxId != null && this.mNextLog.hasStartedTxEvent(theEndTxId);
        if (startInCurrent && endInCurrent) {
            aRotatedInputStream = null;
            aBeginOffset = this.mCurrentLog.getRecordBeginOffsetInFile(theStartTxId);
        } else {
            LOGGER.trace("currentLog.hasStartTx={}; currentLog.hasEndTx={}; rotatedLog.hasStartTx={}; rotatedLog.hasEndTx={}", new Object[]{startInCurrent, endInCurrent, startInRotated, endInRotated});
            if ((startInCurrent || startInRotated) && (endInCurrent || endInRotated)) {
                aRotatedInputStream = this.mNextLog.getInputStream(theStartTxId, theEndTxId);
                aBeginOffset = this.mCurrentLog.getHeaderEndOffsetInFile();
            } else if (theEndTxId == null && (startInCurrent || startInRotated)) {
                if (startInCurrent) {
                    aRotatedInputStream = null;
                    aBeginOffset = this.mCurrentLog.getRecordBeginOffsetInFile(theStartTxId);
                } else {
                    aRotatedInputStream = this.mNextLog.getInputStream(theStartTxId, null);
                    aBeginOffset = this.mCurrentLog.getHeaderEndOffsetInFile();
                }
            } else {
                String msg = String.format("Start (%s) and end (%s) transactions not found in tx logs", theStartTxId, theEndTxId);
                throw new IOException(msg);
            }
        }
        InputStream aInputStream = this.mCurrentLog.getInputStream(aBeginOffset, theEndTxId);
        if (aRotatedInputStream == null && aInputStream == null) {
            return null;
        }
        InputStream aHeader = this.mCurrentLog.asInputStream(0L, this.getHeaderEndOffsetInFile());
        if (aRotatedInputStream == null) {
            return new SequenceInputStream(aHeader, aInputStream);
        }
        if (aInputStream == null) {
            return new SequenceInputStream(aHeader, aRotatedInputStream);
        }
        SequenceInputStream aLogFiles = new SequenceInputStream(aRotatedInputStream, aInputStream);
        return new SequenceInputStream(aHeader, aLogFiles);
    }

    private void switchLoggers() {
        this.mCurrentLog = this.mCurrentLog == this.mNavigableDiskTxLog ? this.mSecondTransactionLog : this.mNavigableDiskTxLog;
        this.mNextLog = this.mNextLog == this.mNavigableDiskTxLog ? this.mSecondTransactionLog : this.mNavigableDiskTxLog;
        this.mRotatedCount.incrementAndGet();
    }

    @VisibleForTesting
    public int getRotatedCount() {
        return this.mRotatedCount.intValue();
    }
}

