/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.tx.api.logging.impl.disk;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Chars;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.openhft.hashing.LongHashFunction;

public final class DiskTxLogDataOutput
implements DataOutput {
    static final int BLOCK_ROUNDING_BYTES = 4;
    static final int FIELD_4_INCOMPLETE_FLAG = 32768;
    public static final int MIN_BUFFER_CAPACITY = 20;
    public static final int MAX_BUFFER_CAPACITY = 65536;
    private final ByteBuffer buffer;
    private final FlushBuffer flushBuffer;
    private int blockStartPos = -1;

    DiskTxLogDataOutput(ByteBuffer buffer, FlushBuffer flushBuffer) {
        this.buffer = (ByteBuffer)Preconditions.checkNotNull((Object)buffer);
        if (buffer.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("The buffer should be little-endian");
        }
        if (buffer.capacity() < 20 || buffer.capacity() > 65536) {
            throw new IllegalArgumentException("The buffer capacity " + buffer.capacity() + " should be between 20 and 65536");
        }
        this.flushBuffer = (FlushBuffer)Preconditions.checkNotNull((Object)flushBuffer);
    }

    private void ensureCapacity(int theMinRequiredSpace) throws IOException {
        if (this.buffer.remaining() < theMinRequiredSpace) {
            this.endBlock(false);
            this.flushBuffer.flushBuffer();
            this.beginBlock();
            if (this.buffer.remaining() < theMinRequiredSpace) {
                throw new IllegalStateException("Buffer is still not empty enough; required is " + theMinRequiredSpace + " but buffer.remaining is " + this.buffer.remaining(), new BufferUnderflowException());
            }
        }
    }

    void beginLogEntry() throws IOException {
        this.beginBlock();
    }

    private void beginBlock() throws IOException {
        if (this.blockStartPos >= 0) {
            throw new IllegalStateException("endBlock() must be called before calling beginBlock() again");
        }
        if (this.buffer.remaining() < 20) {
            this.flushBuffer.flushBuffer();
            if (this.buffer.remaining() < 20) {
                throw new IllegalStateException("Buffer is still not empty enough; MIN_BUFFER_CAPACITY is 20 but buffer.remaining is " + this.buffer.remaining(), new BufferUnderflowException());
            }
        }
        if (this.buffer.position() % 4 != 0) {
            throw new IllegalStateException("Block beginning offset is expected to be aligned to 4");
        }
        this.blockStartPos = this.buffer.position();
        this.buffer.position(this.blockStartPos + 2);
        int maxBlockRoundUp = 3;
        this.buffer.limit(this.buffer.limit() - 2 - 4 - maxBlockRoundUp);
    }

    void endLogEntry() {
        this.endBlock(true);
    }

    private void endBlock(boolean complete) {
        if (this.blockStartPos < 0) {
            throw new IllegalStateException("beginBlock() must be called before calling endBlock()");
        }
        this.buffer.limit(this.buffer.capacity());
        int blockDataBeginning = this.blockStartPos + 2;
        int blockSize = this.buffer.position() - blockDataBeginning;
        if (blockSize == 0) {
            throw new IllegalStateException("Block size should not be 0");
        }
        this.buffer.putChar(this.blockStartPos, Chars.checkedCast((long)blockSize));
        int roundedBlockSize = blockSize;
        while (roundedBlockSize % 4 != 0) {
            this.buffer.put((byte)0);
            ++roundedBlockSize;
        }
        int transactionEndFlag = complete ? 0 : 32768;
        this.buffer.putChar(Chars.checkedCast((long)(roundedBlockSize / 4 | transactionEndFlag)));
        this.buffer.putInt((int)LongHashFunction.xx().hashBytes(this.buffer, blockDataBeginning, roundedBlockSize));
        this.blockStartPos = -1;
    }

    @Override
    public void write(int b) throws IOException {
        this.writeByte(b);
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.ensureCapacity(1);
        this.buffer.put((byte)b);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        if (length < this.buffer.remaining()) {
            this.buffer.put(bytes, offset, length);
        } else {
            int pos = offset;
            int bytesLeft = length;
            while (bytesLeft > 0) {
                int numBytesToWrite = Math.min(this.buffer.remaining(), bytesLeft);
                this.buffer.put(bytes, pos, numBytesToWrite);
                pos += numBytesToWrite;
                if ((bytesLeft -= numBytesToWrite) <= 0) continue;
                this.ensureCapacity(1);
            }
        }
    }

    @Override
    public void writeShort(int s) throws IOException {
        this.ensureCapacity(2);
        this.buffer.putShort((short)s);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.ensureCapacity(4);
        this.buffer.putInt(i);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.ensureCapacity(8);
        this.buffer.putLong(l);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.ensureCapacity(4);
        this.buffer.putFloat(f);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.ensureCapacity(8);
        this.buffer.putDouble(d);
    }

    @Override
    public void writeBoolean(boolean b) throws IOException {
        this.ensureCapacity(1);
        this.buffer.put((byte)(b ? 1 : 0));
    }

    @Override
    public void writeChar(int c) throws IOException {
        this.ensureCapacity(2);
        this.buffer.putChar((char)c);
    }

    @Override
    public void writeBytes(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeChars(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeUTF(String s) {
        throw new UnsupportedOperationException();
    }

    @FunctionalInterface
    static interface FlushBuffer {
        public void flushBuffer() throws IOException;
    }
}

