/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.tx.api.logging.impl.disk;

import com.complexible.common.base.Maths;
import com.complexible.common.base.SystemUtil;
import com.complexible.common.nio.ByteBuffers;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.openhft.hashing.LongHashFunction;

public final class DiskTxLogDataInput {
    private static final int MAX_MEMORY_ALLOCATION = SystemUtil.getPropertyAsInt((String)"com.complexible.tx.api.logging.impl.disk.max.memory.allocation", (int)0x4000000);
    private final InputStream diskTxLogInput;
    private final ByteBuffer fieldReadBuffer = ByteBuffers.allocate((int)4, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
    private ByteBuffer logEntryBuffer = ByteBuffers.allocate((int)512, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
    private ByteBufferDataInputStream logEntry = new ByteBufferDataInputStream(this.logEntryBuffer);

    public static void process(InputStream diskTxLogInput, EntryProcessor processor) throws IOException {
        new DiskTxLogDataInput(diskTxLogInput).process(processor);
    }

    private DiskTxLogDataInput(InputStream diskTxLogInput) {
        this.diskTxLogInput = (InputStream)Preconditions.checkNotNull((Object)diskTxLogInput, (Object)"Input stream cannot be null");
    }

    private void process(EntryProcessor processor) throws IOException {
        int blockSize;
        while ((blockSize = this.readChar()) >= 0) {
            if (blockSize == 0) {
                this.consumeLeftoverZeroBytes();
                return;
            }
            int roundedBlockSize = Maths.roundUp((int)blockSize, (int)4);
            if (this.logEntryBuffer.remaining() < roundedBlockSize) {
                this.reallocateLogEntryBuffer(this.logEntryBuffer.position() + roundedBlockSize);
            }
            int blockStartPos = this.logEntryBuffer.position();
            this.readBlock(roundedBlockSize);
            boolean logEntryComplete = this.readAndCheckField4(roundedBlockSize);
            this.readAndCheckBlockHash(blockStartPos, roundedBlockSize);
            int zeroPadding = roundedBlockSize - blockSize;
            this.logEntryBuffer.position(this.logEntryBuffer.position() - zeroPadding);
            if (!logEntryComplete) continue;
            this.logEntryBuffer.flip();
            if (!processor.process(this.logEntry)) {
                return;
            }
            this.logEntryBuffer.clear();
        }
        return;
    }

    private int readChar() throws IOException {
        int read = this.diskTxLogInput.read(this.fieldReadBuffer.array(), 0, 2);
        if (read < 0) {
            return -1;
        }
        if (read != 2) {
            throw new EOFException("Unexpected number of bytes read or end of input");
        }
        return this.fieldReadBuffer.getChar(0);
    }

    private long readUnsignedInt() throws IOException {
        int read = this.diskTxLogInput.read(this.fieldReadBuffer.array(), 0, 4);
        if (read < 0) {
            return -1L;
        }
        if (read != 4) {
            throw new EOFException("Unexpected number of bytes read or end of input");
        }
        return Integer.toUnsignedLong(this.fieldReadBuffer.getInt(0));
    }

    private void consumeLeftoverZeroBytes() throws IOException {
        int b;
        int count = 0;
        do {
            if ((b = this.diskTxLogInput.read()) < 0) {
                return;
            }
            ++count;
        } while (b == 0);
        throw new IOException("Expected to see only leftover bytes with value 0; read " + count + " bytes and have a byte with value " + b);
    }

    private void reallocateLogEntryBuffer(int minCapacity) {
        ByteBuffer newLogEntryBuffer = ByteBuffers.allocate((int)DiskTxLogDataInput.checkAllocation(minCapacity), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.logEntryBuffer.flip();
        newLogEntryBuffer.put(this.logEntryBuffer);
        this.logEntryBuffer = newLogEntryBuffer;
        this.logEntry = new ByteBufferDataInputStream(newLogEntryBuffer);
    }

    public static int checkAllocation(int allocationSize) {
        if (allocationSize > MAX_MEMORY_ALLOCATION) {
            throw new IllegalStateException("Requested allocation of log entry buffer with size: " + allocationSize);
        }
        return allocationSize;
    }

    private void readBlock(int blockSize) throws IOException {
        int pos = this.logEntryBuffer.position();
        int blockBytesRead = this.diskTxLogInput.read(this.logEntryBuffer.array(), pos, blockSize);
        if (blockBytesRead != blockSize) {
            throw new EOFException("Unexpected bytes read: " + blockBytesRead + ", expected: " + blockSize);
        }
        this.logEntryBuffer.position(pos + blockSize);
    }

    private boolean readAndCheckField4(int roundedBlockSize) throws IOException {
        int field4 = this.readChar();
        if (field4 < 0) {
            throw new EOFException("Unexpected end of input");
        }
        int field4a = field4 & Short.MAX_VALUE;
        int field4aExpected = roundedBlockSize / 4;
        if (field4a != field4aExpected) {
            throw new IOException("Unexpected field #4.a value: " + field4a + ", expected: " + field4aExpected);
        }
        return (field4 & 0x8000) == 0;
    }

    private void readAndCheckBlockHash(int blockStartPos, int roundedBlockSize) throws IOException {
        long readBlockHash = this.readUnsignedInt();
        if (readBlockHash < 0L) {
            throw new EOFException("Unexpected end of input");
        }
        int readBlockHashInt = (int)readBlockHash;
        int actualHash = (int)LongHashFunction.xx().hashBytes(this.logEntryBuffer, blockStartPos, roundedBlockSize);
        if (readBlockHashInt != actualHash) {
            throw new IOException("Hash code of the input doesn't match: read=" + readBlockHashInt + ", actual=" + actualHash);
        }
    }

    public static interface EntryProcessor {
        public <T extends InputStream> boolean process(T var1) throws IOException;
    }

    private static class ByteBufferDataInputStream
    extends InputStream
    implements DataInput {
        private final ByteBuffer buffer;

        private ByteBufferDataInputStream(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        private void checkRemaining(int n) throws EOFException {
            if (n > this.buffer.remaining()) {
                throw new EOFException("Requested to read: " + n + ", remaining: " + this.buffer.remaining());
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.buffer.remaining() == 0) {
                return -1;
            }
            int read = Math.min(this.buffer.remaining(), len);
            this.buffer.get(b, off, read);
            return read;
        }

        @Override
        public int available() {
            return this.buffer.remaining();
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            this.checkRemaining(len);
            this.buffer.get(b, off, len);
        }

        @Override
        public int skipBytes(int n) {
            return (int)this.skip(n);
        }

        @Override
        public long skip(long n) {
            int skipped = (int)Math.min((long)this.buffer.remaining(), n);
            this.buffer.position(this.buffer.position() + skipped);
            return skipped;
        }

        @Override
        public int read() throws IOException {
            if (this.buffer.remaining() == 0) {
                return -1;
            }
            return Byte.toUnsignedInt(this.readByte());
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.readByte() != 0;
        }

        @Override
        public byte readByte() throws IOException {
            this.checkRemaining(1);
            return this.buffer.get();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return Byte.toUnsignedInt(this.readByte());
        }

        @Override
        public short readShort() throws IOException {
            this.checkRemaining(2);
            return this.buffer.getShort();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return Short.toUnsignedInt(this.readShort());
        }

        @Override
        public char readChar() throws IOException {
            this.checkRemaining(2);
            return this.buffer.getChar();
        }

        @Override
        public int readInt() throws IOException {
            this.checkRemaining(4);
            return this.buffer.getInt();
        }

        @Override
        public long readLong() throws IOException {
            this.checkRemaining(8);
            return this.buffer.getLong();
        }

        @Override
        public float readFloat() throws IOException {
            this.checkRemaining(4);
            return this.buffer.getFloat();
        }

        @Override
        public double readDouble() throws IOException {
            this.checkRemaining(8);
            return this.buffer.getDouble();
        }

        @Override
        public String readLine() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readUTF() {
            throw new UnsupportedOperationException();
        }
    }
}

