/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.tx.api.logging.impl.disk;

import com.complexible.common.base.Copyable;
import com.complexible.common.io.FileRotationStrategy;
import com.complexible.common.io.SizeRotationStrategy;
import com.complexible.common.io.TimeRotationStrategy;
import com.complexible.tx.api.logging.LogFormat;
import com.complexible.tx.api.logging.impl.DefaultLogFormat;
import com.complexible.tx.api.logging.impl.disk.SimpleDiskTxLog;
import com.complexible.tx.api.logging.impl.navigable.CombinedNavigableDiskTxLog;
import com.complexible.tx.api.logging.impl.navigable.DefaultNavigableDiskTxLog;
import com.complexible.tx.api.logging.impl.navigable.NavigableDiskTxLog;
import com.complexible.tx.api.logging.impl.navigable.SingleNavigableDiskTxLog;
import java.io.IOException;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiskTxLogBuilder
implements Copyable<DiskTxLogBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskTxLogBuilder.class);
    private static final int DEFAULT_BUFFER_SIZE = 8096;
    private static final FileRotationStrategy NO_ROTATION = (theFile, fileLength) -> false;
    private int mBufferSize = 8096;
    private LogFormat mFormat = DefaultLogFormat.V4;
    private FileRotationStrategy mRotationStrategy = NO_ROTATION;
    private boolean preserveOldLogOnRotation = true;
    private boolean keepRotatedBackupFiles = false;
    private boolean transactionLogUseRotated = true;

    public NavigableDiskTxLog build(Path theFile) throws IOException {
        if (this.transactionLogUseRotated && this.preserveOldLogOnRotation) {
            DefaultNavigableDiskTxLog aActualLog = this.buildDefault(theFile);
            DefaultNavigableDiskTxLog aRotatedActualLog = this.buildDefault(theFile);
            LOGGER.info("Creating a CombinedNavigableDiskTxLog for {}", (Object)theFile.toString());
            return new CombinedNavigableDiskTxLog(aActualLog, aRotatedActualLog);
        }
        LOGGER.info("Creating a SingleNavigableDiskTxLog for {}", (Object)theFile.toString());
        return new SingleNavigableDiskTxLog(this.buildDefault(theFile));
    }

    private DefaultNavigableDiskTxLog buildDefault(Path theFile) throws IOException {
        return new DefaultNavigableDiskTxLog(this.createBaseDiskTxLog(theFile));
    }

    private SimpleDiskTxLog createBaseDiskTxLog(Path theFile) {
        LOGGER.info("Creating SimpleDiskTxLog for {}", (Object)theFile.toString());
        return new SimpleDiskTxLog(theFile, this.mFormat, this.mBufferSize, this.mRotationStrategy, this.preserveOldLogOnRotation, this.keepRotatedBackupFiles);
    }

    public DiskTxLogBuilder copy() {
        return new DiskTxLogBuilder().bufferSize(this.mBufferSize).format(this.mFormat).rotationStrategy(this.mRotationStrategy).useRotated(this.transactionLogUseRotated);
    }

    public DiskTxLogBuilder format(LogFormat theFormat) {
        this.mFormat = theFormat;
        return this;
    }

    public DiskTxLogBuilder bufferSize(int theBufferSize) {
        this.mBufferSize = theBufferSize;
        return this;
    }

    public DiskTxLogBuilder rotateEvery(long theTimeInMs) {
        this.mRotationStrategy = new TimeRotationStrategy(theTimeInMs);
        return this;
    }

    public DiskTxLogBuilder rotateWhen(long theSizeInBytes) {
        this.mRotationStrategy = new SizeRotationStrategy(theSizeInBytes);
        return this;
    }

    public DiskTxLogBuilder rotationStrategy(FileRotationStrategy theStrategy) {
        this.mRotationStrategy = theStrategy;
        return this;
    }

    public DiskTxLogBuilder preserveOldLogOnRotation(boolean preserveOldLogOnRotation) {
        this.preserveOldLogOnRotation = preserveOldLogOnRotation;
        return this;
    }

    public DiskTxLogBuilder keepRotatedBackupFiles(boolean keepRotatedBackupFiles) {
        this.keepRotatedBackupFiles = keepRotatedBackupFiles;
        return this;
    }

    public DiskTxLogBuilder useRotated(boolean useRotated) {
        this.transactionLogUseRotated = useRotated;
        return this;
    }
}

