/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.tx.api.logging.impl;

import com.complexible.tx.api.logging.LogHandler;
import com.complexible.tx.api.logging.TxLog;
import com.complexible.tx.api.logging.TxLogRecord;
import com.complexible.tx.api.logging.impl.NoOpTxLog;
import com.complexible.tx.api.logging.impl.PrintingLogHandler;
import com.complexible.tx.api.logging.impl.disk.DiskTxLogBuilder;
import com.complexible.tx.api.logging.impl.disk.DiskTxLogs;
import com.complexible.tx.api.logging.impl.memory.MemTxLog;
import com.google.common.collect.ImmutableCollection;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;

public final class TxLogs {
    private static final NoOpTxLog NO_OP_LOG = new NoOpTxLog();

    private TxLogs() {
        throw new AssertionError();
    }

    public static TxLog noOp() {
        return NO_OP_LOG;
    }

    public static MemTxLog memory() {
        return new MemTxLog();
    }

    public static DiskTxLogBuilder buildDiskLog() {
        return new DiskTxLogBuilder();
    }

    public static <T extends Collection<TxLogRecord>> CollectionLogHandler<T> collectingHandler(ImmutableCollection.Builder<TxLogRecord> theCollection) {
        return new CollectionLogHandler(theCollection);
    }

    public static void printToStream(Path fileName, OutputStream out) {
        try (PrintingLogHandler logger = new PrintingLogHandler(out);){
            DiskTxLogs.read(fileName, (LogHandler)logger);
        }
        catch (IOException theE) {
            throw new RuntimeException(theE);
        }
    }

    public static class CollectionLogHandler<T extends Collection<TxLogRecord>>
    implements LogHandler {
        private final ImmutableCollection.Builder<TxLogRecord> mBuilder;

        private CollectionLogHandler(ImmutableCollection.Builder<TxLogRecord> theBuilder) {
            this.mBuilder = theBuilder;
        }

        @Override
        public void handleRecord(TxLogRecord theRecord) {
            this.mBuilder.add((Object)theRecord);
        }

        public T get() {
            return (T)this.mBuilder.build();
        }
    }
}

