/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.tx.api.logging;

import com.complexible.tx.api.logging.LogFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.io.InvalidObjectException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

@Immutable
public final class LogHeader<T extends LogFormat>
implements Serializable {
    private final int mVersion;
    private final T mFormat;

    private LogHeader(int theVersion, T theFormat) {
        Preconditions.checkArgument((theVersion >= 0 ? 1 : 0) != 0, (Object)"No negative version numbers");
        Preconditions.checkNotNull(theFormat, (Object)"Must provide a log format");
        this.mVersion = theVersion;
        this.mFormat = theFormat;
    }

    public static <T extends LogFormat> LogHeader<T> create(int theVersion, T theFormat) {
        return new LogHeader<T>(theVersion, theFormat);
    }

    public boolean equals(Object theObj) {
        if (theObj == null) {
            return false;
        }
        if (theObj == this) {
            return true;
        }
        if (theObj instanceof LogHeader) {
            LogHeader aHeader = (LogHeader)theObj;
            return this.mVersion == aHeader.mVersion && this.mFormat.equals(aHeader.getFormat());
        }
        return true;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mVersion, this.mFormat});
    }

    public T getFormat() {
        return this.mFormat;
    }

    public int getVersion() {
        return this.mVersion;
    }

    private Object writeReplace() {
        return new LogHeaderSerializationProxy(this);
    }

    private void readObject(ObjectOutputStream theOutput) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class LogHeaderSerializationProxy<T extends LogFormat>
    implements Serializable {
        private static final long serialVersionUID = 458202242101180L;
        private final int mVersion;
        private final T mFormat;

        private LogHeaderSerializationProxy(LogHeader<T> theHeader) {
            this.mVersion = theHeader.mVersion;
            this.mFormat = theHeader.mFormat;
        }

        private Object readResolve() {
            return new LogHeader<T>(this.mVersion, this.mFormat);
        }
    }
}

