/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.util.timeout;

import com.complexible.stardog.util.timeout.Timer;
import com.complexible.stardog.util.timeout.TimerManager;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzTimerManager
implements TimerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzTimerManager.class);
    private static final String SCHED_GROUP = QuartzTimerManager.class.getName();
    private final Scheduler mScheduler;
    private final long mDefaultTimeout;
    private static final long NOT_STARTED = -1L;

    public QuartzTimerManager(Scheduler theScheduler) {
        this(theScheduler, TimeUnit.HOURS.toMillis(1L));
    }

    public QuartzTimerManager(Scheduler theScheduler, long theDefaultTimeout) {
        this.mScheduler = theScheduler;
        this.mDefaultTimeout = theDefaultTimeout;
    }

    @Override
    public long getDefaultTimeout() {
        return this.mDefaultTimeout;
    }

    @Override
    public Timer newTimer(String theName, Runnable theTimeoutTask) {
        return this.newTimer(theName, this.getDefaultTimeout(), theTimeoutTask);
    }

    @Override
    public Timer newTimer(String theName, long theTimeout, Runnable theTimeoutTask) {
        QuartzTimer aTimer = new QuartzTimer(theName, theTimeoutTask, theTimeout);
        this.schedule(aTimer);
        return aTimer;
    }

    private void schedule(QuartzTimer aTimer) {
        JobDetail job = JobBuilder.newJob(TimeoutJob.class).withIdentity(aTimer.jobKey()).usingJobData(new JobDataMap((Map)ImmutableMap.of((Object)"timer", (Object)aTimer))).build();
        Trigger aTrigger = TriggerBuilder.newTrigger().withIdentity(aTimer.triggerKey()).startAt(new Date(aTimer.getTimeout() - aTimer.getElapsedTime())).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(Math.max(1L, aTimer.getTimeout() / 2L)).repeatForever()).build();
        try {
            this.mScheduler.scheduleJob(job, aTrigger);
        }
        catch (SchedulerException e) {
            LOGGER.warn("Cannot schedule the timeout job for " + aTimer.getName(), (Throwable)e);
        }
    }

    private void unschedule(QuartzTimer theTimer) {
        try {
            this.mScheduler.deleteJob(theTimer.jobKey());
        }
        catch (SchedulerException e) {
            LOGGER.warn("Cannot cancel the timer for " + theTimer.getName(), (Throwable)e);
        }
    }

    private class QuartzTimer
    implements Timer {
        private final String mName;
        private final long mTimeout;
        private final Runnable mTimeoutAction;
        private volatile long mStartTime = System.currentTimeMillis();

        public QuartzTimer(String theName, Runnable theTimeoutAction, long theTimeout) {
            this.mName = theName;
            this.mTimeout = theTimeout;
            this.mTimeoutAction = theTimeoutAction;
        }

        private JobKey jobKey() {
            return JobKey.jobKey((String)("job:" + this.mName), (String)SCHED_GROUP);
        }

        private TriggerKey triggerKey() {
            return TriggerKey.triggerKey((String)("trigger:" + this.mName), (String)SCHED_GROUP);
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public long getTimeout() {
            return this.mTimeout;
        }

        @Override
        public void pause() {
            this.mStartTime = -1L;
        }

        @Override
        public boolean isStarted() {
            return this.mStartTime != -1L;
        }

        @Override
        public void start() {
            this.mStartTime = System.currentTimeMillis();
        }

        @Override
        public void reset() {
            long aStartTime = this.mStartTime;
            if (aStartTime != -1L) {
                this.mStartTime = System.currentTimeMillis();
            }
        }

        @Override
        public long getElapsedTime() {
            long aStartTime = this.mStartTime;
            return aStartTime <= 0L ? 0L : System.currentTimeMillis() - aStartTime;
        }

        @Override
        public synchronized void cancel() {
            QuartzTimerManager.this.unschedule(this);
        }

        public synchronized void checkAndExpire() {
            long aElapsedTime = this.getElapsedTime();
            if (aElapsedTime > this.mTimeout) {
                this.mStartTime = -1L;
                QuartzTimerManager.this.unschedule(this);
                this.mTimeoutAction.run();
            }
        }
    }

    public static class TimeoutJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            JobDataMap data = context.getMergedJobDataMap();
            QuartzTimer timer = (QuartzTimer)data.get((Object)"timer");
            timer.checkAndExpire();
        }
    }
}

