/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.util.report.sdu;

import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.stardog.util.report.sdu.SDUUsageEvent;
import com.complexible.stardog.util.report.sdu.SDUUsageEventIterator;
import com.complexible.stardog.util.report.sdu.SDUUsageSummary;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDUUsageLogReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SDUUsageLogReader.class);
    private static final Pattern DATE_PATTERN = Pattern.compile("\\.(\\d{4}-\\d{2}-\\d{2})(?:\\.(\\d+))?(?:\\.gz)?$");
    private static final Option<String> SERVER_HOST = Option.create((String)"server.host", (Object)"0.0.0.0");
    private static final Option<Integer> SERVER_PORT = Option.create((String)"server.port", (Object)5820);
    private final Path mHome;

    public SDUUsageLogReader(Path theHome) {
        this.mHome = theHome;
    }

    public SDUUsageSummary readSummary(Instant theStartTime, Instant theEndTime, Options theServerOptions) throws IOException {
        return this.readSummary(SDUUsageLogReader.toEpochMillis(theStartTime), SDUUsageLogReader.toEpochMillis(theEndTime), SDUUsageLogReader.resolveServerAddress(theServerOptions));
    }

    private SDUUsageSummary readSummary(Long theStartTime, Long theEndTime, String theNodeId) throws IOException {
        SDUUsageSummary summary = new SDUUsageSummary();
        try (SDUUsageEventIterator iterator = this.iterator(theStartTime, theEndTime);){
            while (iterator.hasNext()) {
                summary.addEvent(iterator.next(), theNodeId);
            }
        }
        LOGGER.debug("Built SDU usage summary with {} queries (start={}, end={})", new Object[]{summary.getTotalQueries(), theStartTime, theEndTime});
        return summary;
    }

    static String resolveServerAddress(Options theServerOptions) {
        String host = (String)theServerOptions.get(SERVER_HOST);
        Integer port = (Integer)theServerOptions.get(SERVER_PORT);
        if (((String)SERVER_HOST.getDefaultValue()).equals(host)) {
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                host = "127.0.0.1";
            }
        }
        return host + ":" + port;
    }

    public List<SDUUsageEvent> readEvents(Long theStartTime, Long theEndTime) throws IOException {
        ArrayList<SDUUsageEvent> events = new ArrayList<SDUUsageEvent>();
        try (SDUUsageEventIterator iterator = this.iterator(theStartTime, theEndTime);){
            while (iterator.hasNext()) {
                events.add(iterator.next());
            }
        }
        LOGGER.debug("Read {} total SDU usage events (start={}, end={})", new Object[]{events.size(), theStartTime, theEndTime});
        return events;
    }

    public SDUUsageEventIterator iterator(Instant theStartTime, Instant theEndTime) throws IOException {
        return this.iterator(SDUUsageLogReader.toEpochMillis(theStartTime), SDUUsageLogReader.toEpochMillis(theEndTime));
    }

    private SDUUsageEventIterator iterator(Long theStartTime, Long theEndTime) throws IOException {
        List<Path> logFiles = this.findLogFiles();
        if (logFiles.isEmpty()) {
            LOGGER.debug("No SDU usage log files found in: {}", (Object)this.mHome);
        }
        return new SDUUsageEventIterator(logFiles, theStartTime, theEndTime);
    }

    List<Path> findLogFiles() throws IOException {
        String baseFileName = "sdu_usage.log";
        if (!Files.exists(this.mHome, new LinkOption[0])) {
            return List.of();
        }
        try (Stream<Path> files = Files.list(this.mHome);){
            List<Path> list = files.filter(path -> {
                String fileName = path.getFileName().toString();
                return fileName.equals(baseFileName) || fileName.startsWith(baseFileName + ".");
            }).sorted(this.logFileComparator(baseFileName)).collect(Collectors.toList());
            return list;
        }
    }

    private Comparator<Path> logFileComparator(String theBaseFileName) {
        return (p1, p2) -> {
            String date2;
            String name1 = p1.getFileName().toString();
            String name2 = p2.getFileName().toString();
            boolean isActive1 = name1.equals(theBaseFileName);
            boolean isActive2 = name2.equals(theBaseFileName);
            if (isActive1 && !isActive2) {
                return 1;
            }
            if (!isActive1 && isActive2) {
                return -1;
            }
            if (isActive1) {
                return 0;
            }
            Matcher m1 = DATE_PATTERN.matcher(name1);
            Matcher m2 = DATE_PATTERN.matcher(name2);
            boolean matched1 = m1.find();
            boolean matched2 = m2.find();
            if (!matched1 && !matched2) {
                return name1.compareTo(name2);
            }
            if (!matched1) {
                return 1;
            }
            if (!matched2) {
                return -1;
            }
            String date1 = m1.group(1);
            int dateCompare = date1.compareTo(date2 = m2.group(1));
            if (dateCompare != 0) {
                return dateCompare;
            }
            int counter1 = m1.group(2) != null ? Integer.parseInt(m1.group(2)) : 0;
            int counter2 = m2.group(2) != null ? Integer.parseInt(m2.group(2)) : 0;
            return Integer.compare(counter1, counter2);
        };
    }

    private static Long toEpochMillis(Instant theInstant) {
        return theInstant != null ? Long.valueOf(theInstant.toEpochMilli()) : null;
    }
}

