/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.util.report.sdu;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SDULogFileMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(SDULogFileMetadata.class);
    private static final Pattern EPOCH_PATTERN = Pattern.compile("\"EPOCH\"\\s*:\\s*(\\d+)");
    private static final int LAST_LINE_BUFFER_SIZE = 4096;

    private SDULogFileMetadata() {
    }

    public static FileTimeRange getFileTimeRange(Path theLogFile) {
        Long firstTimestamp = null;
        Long lastTimestamp = null;
        boolean isCompressed = theLogFile.getFileName().toString().endsWith(".gz");
        if (isCompressed) {
            firstTimestamp = SDULogFileMetadata.readFirstLineTimestamp(theLogFile, true);
            return new FileTimeRange(firstTimestamp, null);
        }
        firstTimestamp = SDULogFileMetadata.readFirstLineTimestamp(theLogFile, false);
        lastTimestamp = SDULogFileMetadata.readLastLineTimestamp(theLogFile);
        return new FileTimeRange(firstTimestamp, lastTimestamp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long readFirstLineTimestamp(Path theLogFile, boolean isCompressed) {
        try (InputStream inputStream = isCompressed ? new GZIPInputStream(Files.newInputStream(theLogFile, new OpenOption[0])) : Files.newInputStream(theLogFile, new OpenOption[0]);
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            if (line == null) return null;
            Long l = SDULogFileMetadata.extractEpoch(line.trim());
            return l;
        }
        catch (IOException e) {
            LOGGER.debug("Could not read first line of {}: {}", (Object)theLogFile, (Object)e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long readLastLineTimestamp(Path theLogFile) {
        try (RandomAccessFile raf = new RandomAccessFile(theLogFile.toFile(), "r");){
            long fileLength = raf.length();
            if (fileLength == 0L) {
                Long l = null;
                return l;
            }
            long startPos = Math.max(0L, fileLength - 4096L);
            raf.seek(startPos);
            byte[] buffer = new byte[(int)(fileLength - startPos)];
            raf.readFully(buffer);
            String content = new String(buffer, StandardCharsets.UTF_8);
            String[] lines = content.split("\n");
            int idx = lines.length - 1;
            while (idx >= 0) {
                String line = lines[idx].trim();
                if (!line.isEmpty()) {
                    Long l = SDULogFileMetadata.extractEpoch(line);
                    return l;
                }
                --idx;
            }
            return null;
        }
        catch (IOException e) {
            LOGGER.debug("Could not read last line of {}: {}", (Object)theLogFile, (Object)e.getMessage());
        }
        return null;
    }

    public static Long extractEpoch(String theLine) {
        Matcher matcher = EPOCH_PATTERN.matcher(theLine);
        if (matcher.find()) {
            try {
                return Long.parseLong(matcher.group(1));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static final class FileTimeRange {
        private final Long mFirstTimestamp;
        private final Long mLastTimestamp;

        public FileTimeRange(Long theFirst, Long theLast) {
            this.mFirstTimestamp = theFirst;
            this.mLastTimestamp = theLast;
        }

        public Long getFirstTimestamp() {
            return this.mFirstTimestamp;
        }

        public Long getLastTimestamp() {
            return this.mLastTimestamp;
        }
    }
}

