/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.util.report;

import com.complexible.common.io.Files2;
import com.complexible.stardog.Environment;
import com.complexible.stardog.metadata.MetaProperties;
import com.complexible.stardog.metadata.Metadata;
import com.complexible.stardog.metadata.MetadataIO;
import com.complexible.stardog.util.report.MetricsPrinter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.io.MoreFiles;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticsReport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiagnosticsReport.class);
    private List<String> mIncludes = null;
    private List<String> mExcludes = null;
    private boolean mGetStardogHome = false;
    private boolean mNoSystem = false;
    private boolean mDryRun = false;
    private Set<String> mAddedSourceFiles = new HashSet<String>();
    private Set<String> mFailedSourceFiles = new HashSet<String>();
    private boolean mGotHome;
    private ZipOutputStream mZipOut;
    private OutputStream mFos;
    private String mPrefix = "";
    private Map<String, Object> mMetrics;
    private Map<String, Metadata> mDbConfigs;

    public DiagnosticsReport() {
    }

    public DiagnosticsReport(List<String> theIncludes, List<String> theExcludes, boolean theGetStardogHome, boolean theNoSystem, boolean theDryRun) {
        this.mIncludes = theIncludes;
        this.mExcludes = theExcludes;
        this.mGetStardogHome = theGetStardogHome;
        this.mNoSystem = theNoSystem;
        this.mDryRun = theDryRun;
    }

    public ByteArrayOutputStream createZipAsOutputStream(String theDestPrefix) throws Exception {
        File outputFile = this.createZip(theDestPrefix);
        ByteArrayOutputStream aContents = new ByteArrayOutputStream();
        try (FileInputStream aFileInputStream = new FileInputStream(outputFile);){
            IOUtils.copy((InputStream)aFileInputStream, (OutputStream)aContents);
            ByteArrayOutputStream byteArrayOutputStream = aContents;
            return byteArrayOutputStream;
        }
    }

    public File createZip() throws Exception {
        return this.createZip(this.mPrefix);
    }

    public File createZip(String theDestPrefix) throws Exception {
        this.mAddedSourceFiles = new HashSet<String>();
        this.mFailedSourceFiles = new HashSet<String>();
        this.mGotHome = false;
        File tmpZip = new File(Files.createTempFile(theDestPrefix + "_", ".zip", new FileAttribute[0]).toAbsolutePath().toString());
        tmpZip.deleteOnExit();
        if (!this.mDryRun) {
            this.mFos = Files.newOutputStream(tmpZip.toPath(), new OpenOption[0]);
            this.mZipOut = new ZipOutputStream(this.mFos);
        }
        if (this.mIncludes != null) {
            for (String aEx : this.mIncludes) {
                if (DiagnosticsReport.applyIncludeGuardrails(aEx)) {
                    this.addFile(new File(aEx).toPath(), aEx, theDestPrefix);
                    continue;
                }
                this.mFailedSourceFiles.add(aEx);
            }
        }
        this.getFileNames(theDestPrefix);
        this.getCrashReports(theDestPrefix);
        this.getStarrocksLogs(theDestPrefix);
        this.runCommand(new String[]{"df", "-hP"}, "df_output", theDestPrefix);
        this.addMetrics(theDestPrefix);
        this.addDbConfigs(theDestPrefix);
        if (!this.mDryRun) {
            this.mZipOut.close();
            this.mFos.close();
        }
        LOGGER.debug("Created diagnostic report file {}", (Object)tmpZip.getAbsolutePath());
        return tmpZip;
    }

    public static boolean applyIncludeGuardrails(String file) {
        Path stepOne = Paths.get(file, new String[0]);
        Path stepTwo = null;
        Path cleanHome = null;
        boolean retFlag = false;
        try {
            stepTwo = stepOne.toRealPath(new LinkOption[0]);
            cleanHome = Paths.get(Environment.getHome(), new String[0]).toRealPath(new LinkOption[0]);
        }
        catch (Exception x) {
            LOGGER.debug("applyIncludeGuardrails failure {}", (Object)x.toString());
        }
        if (null != stepTwo && null != cleanHome) {
            retFlag = stepTwo.startsWith(cleanHome);
        }
        return retFlag;
    }

    private void getCrashReports(String theDestPrefix) throws IOException {
        WildcardFileFilter fileFilter;
        String aLine;
        File aStardogLog = new File(Environment.getHome(), "stardog.log");
        if (!aStardogLog.exists()) {
            return;
        }
        FileReader aFileReader = new FileReader(aStardogLog);
        BufferedReader aBufferedReader = new BufferedReader(aFileReader);
        while ((aLine = aBufferedReader.readLine()) != null) {
            if (!aLine.contains("hs_err_pid")) continue;
            String aPathStr = aLine.replace("#", "").trim();
            this.addFile(new File(aPathStr).toPath(), aPathStr, theDestPrefix);
        }
        File dir = new File(Environment.getHome());
        File[] files = dir.listFiles((FileFilter)(fileFilter = new WildcardFileFilter("sd_term_pid*")));
        if (files != null) {
            for (File theFile : files) {
                this.addFile(theFile.toPath(), theFile.getAbsolutePath(), theDestPrefix);
            }
        }
    }

    private void getStarrocksLogs(String theDestPrefix) throws IOException {
        WildcardFileFilter fileFilter;
        File dir = new File(Environment.getHome(), "data");
        File[] files = dir.listFiles((FileFilter)(fileFilter = new WildcardFileFilter("LOG*")));
        if (files != null) {
            for (File theFile : files) {
                this.addFile(theFile.toPath(), theFile.getAbsolutePath(), theDestPrefix);
            }
        }
    }

    private void getFileNames(String theDestPrefix) throws IOException {
        block30: {
            String[] aSystemFiles = new String[]{"/proc/sys/fs/file-max", "/var/log/syslog", "/var/log/kern.log", "/proc/version", "/proc/mounts", "/proc/cpuinfo", "/proc/meminfo"};
            if (!this.mNoSystem) {
                for (String aSys : aSystemFiles) {
                    this.addFile(new File(aSys).toPath(), aSys, theDestPrefix);
                }
            }
            if (this.mGetStardogHome) {
                Path aLockFile = Paths.get(Environment.getHome(), "system.lock");
                try (FileChannel aFc = FileChannel.open(aLockFile, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                     FileLock aFileLock = aFc.tryLock();){
                    if (aFileLock == null) break block30;
                    try (Stream<Path> dirStream = Files.walk(Paths.get(Environment.getHome(), new String[0]), new FileVisitOption[0]);){
                        dirStream.forEach(path -> this.addFile(path.toAbsolutePath(), path.toString(), theDestPrefix));
                    }
                    this.mGotHome = true;
                }
                catch (Exception ex) {
                    this.mGotHome = false;
                }
            } else {
                try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(Environment.getHome(), new String[0]), "*.log");){
                    dirStream.forEach(path -> this.addFile(path.toAbsolutePath(), path.toString(), theDestPrefix));
                }
                File aF = new File(Environment.getHome(), "stardog.properties");
                this.addFile(aF.toPath(), aF.getAbsolutePath(), theDestPrefix);
                aF = new File(Environment.getHome(), "stardog.node-id");
                this.addFile(aF.toPath(), aF.getAbsolutePath(), theDestPrefix);
                aF = new File(Environment.getHome(), "log4j2.xml");
                this.addFile(aF.toPath(), aF.getAbsolutePath(), theDestPrefix);
            }
        }
    }

    private void addFile(Path sourceFile, String destName, String theDestPrefix) {
        if (this.mExcludes != null && this.mExcludes.contains(sourceFile.toString())) {
            return;
        }
        if (this.mAddedSourceFiles.contains(sourceFile.toString())) {
            return;
        }
        if (!sourceFile.toFile().exists() || sourceFile.toFile().isDirectory()) {
            return;
        }
        this.mAddedSourceFiles.add(sourceFile.toString());
        if (this.mDryRun) {
            return;
        }
        try {
            File tmpFile = new File(sourceFile.toString());
            if (tmpFile.canRead()) {
                ZipEntry aZipEntry = new ZipEntry(theDestPrefix + "/" + destName);
                this.mZipOut.putNextEntry(aZipEntry);
                MoreFiles.asByteSource((Path)sourceFile, (OpenOption[])new OpenOption[0]).copyTo((OutputStream)this.mZipOut);
                this.mZipOut.closeEntry();
            } else {
                LOGGER.warn("Unable to read file {} it will not be added to the diagnostics report", (Object)sourceFile.toAbsolutePath());
            }
        }
        catch (IOException aIoEx) {
            this.mFailedSourceFiles.add(sourceFile.toString());
        }
    }

    private void runCommand(String[] command, String fname, String theDestPrefix) throws IOException, InterruptedException {
        String aLine;
        File aTempFile = File.createTempFile(fname, "");
        aTempFile.deleteOnExit();
        Process aProcess = Runtime.getRuntime().exec(command);
        BufferedReader aBufferedReader = new BufferedReader(new InputStreamReader(aProcess.getInputStream()));
        FileWriter aWriter = new FileWriter(aTempFile);
        while ((aLine = aBufferedReader.readLine()) != null) {
            aWriter.write(aLine);
            aWriter.write("\n");
        }
        aWriter.close();
        int aRc = aProcess.waitFor();
        if (aRc != 0) {
            File aFailedFile = File.createTempFile(fname, "failed");
            aFailedFile.deleteOnExit();
            FileWriter aFailedFileWriter = new FileWriter(aFailedFile);
            aBufferedReader = new BufferedReader(new InputStreamReader(aProcess.getErrorStream()));
            while ((aLine = aBufferedReader.readLine()) != null) {
                aFailedFileWriter.write(aLine);
            }
            aFailedFileWriter.close();
            this.addFile(aFailedFile.toPath(), fname + ".failed", theDestPrefix);
        } else {
            this.addFile(aTempFile.toPath(), fname, theDestPrefix);
        }
    }

    public void writeByteStreamToZip(ByteArrayOutputStream theByteStream, ZipOutputStream theZipOutputStream) throws IOException {
        try (ByteArrayInputStream aContentsInputStream = new ByteArrayInputStream(theByteStream.toByteArray());
             ZipInputStream aZipInputStream = new ZipInputStream(aContentsInputStream);){
            ZipEntry entry;
            while ((entry = aZipInputStream.getNextEntry()) != null) {
                int length;
                theZipOutputStream.putNextEntry(entry);
                byte[] buffer = new byte[1024];
                while ((length = aZipInputStream.read(buffer)) > 0) {
                    theZipOutputStream.write(buffer, 0, length);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMetrics(String theDestPrefix) throws IOException, InterruptedException {
        if (this.mMetrics == null) {
            return;
        }
        File aTempFile = File.createTempFile("serverMetrics", "txt");
        try {
            try (PrintStream aWriter = new PrintStream(new FileOutputStream(aTempFile));){
                MetricsPrinter.printMetrics(aWriter, this.mMetrics, (List<String>)ImmutableList.of((Object)".*"));
            }
            this.addFile(aTempFile.toPath(), "serverMetrics.txt", theDestPrefix);
        }
        finally {
            aTempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDbConfigs(String theDestPrefix) throws IOException {
        if (this.mDbConfigs == null) {
            return;
        }
        String aDestDir = theDestPrefix + "/db_configs";
        Path aTempDir = Files.createTempDirectory("", new FileAttribute[0]);
        try {
            for (Map.Entry<String, Metadata> aEntry : this.mDbConfigs.entrySet()) {
                String aDb = aEntry.getKey();
                Metadata aConfig = aEntry.getValue();
                String aFilename = aDb + ".txt";
                Path aConfigFile = aTempDir.resolve(aFilename);
                try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(aConfigFile, new OpenOption[0]));){
                    MetadataIO.writeTable(aConfig, out);
                }
                this.addFile(aConfigFile, aFilename, aDestDir);
                aFilename = aDb + "_changed.txt";
                Path aChangedConfigFile = aTempDir.resolve(aFilename);
                try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(aChangedConfigFile, new OpenOption[0]));){
                    MetadataIO.writeTable(DiagnosticsReport.filterDefaultOptions(aConfig), out);
                }
                this.addFile(aChangedConfigFile, aFilename, aDestDir);
            }
        }
        finally {
            Files2.deleteRecursively((Path)aTempDir);
        }
    }

    private static Metadata filterDefaultOptions(Metadata metadata) {
        return MetaProperties.filter(metadata, p -> !Objects.equals(p.getDefaultValue(), metadata.get(p)) && !Objects.equals(p.getSystemDefaultValue(), metadata.get(p)));
    }

    private void addExcludedFile(String fileName) {
        this.mAddedSourceFiles.add(fileName);
    }

    @JsonIgnore
    public Set<String> getAddedSourceFiles() {
        return this.mAddedSourceFiles;
    }

    @JsonIgnore
    public Set<String> getFailedSourceFiles() {
        return this.mFailedSourceFiles;
    }

    @JsonIgnore
    public boolean isGotHome() {
        return this.mGotHome;
    }

    @JsonProperty(value="includes")
    public List<String> getIncludes() {
        return this.mIncludes;
    }

    public void setIncludes(List<String> theIncludes) {
        this.mIncludes = theIncludes;
    }

    @JsonProperty(value="excludes")
    public List<String> getExcludes() {
        return this.mExcludes;
    }

    public void setExcludes(List<String> theExcludes) {
        this.mExcludes = theExcludes;
    }

    @JsonProperty(value="gotHome")
    public boolean isGetStardogHome() {
        return this.mGetStardogHome;
    }

    public void setGetStardogHome(boolean theGetStardogHome) {
        this.mGetStardogHome = theGetStardogHome;
    }

    @JsonProperty(value="noSystem")
    public boolean isNoSystem() {
        return this.mNoSystem;
    }

    public void setNoSystem(boolean theNoSystem) {
        this.mNoSystem = theNoSystem;
    }

    @JsonProperty(value="dryRun")
    public boolean isDryRun() {
        return this.mDryRun;
    }

    public void setDryRun(boolean theDryRun) {
        this.mDryRun = theDryRun;
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public void setPrefix(String thePrefix) {
        this.mPrefix = thePrefix;
    }

    public void setMetrics(Map<String, Object> theMetrics) {
        this.mMetrics = theMetrics;
    }

    public void setDbConfigs(Map<String, Metadata> theDbConfigs) {
        this.mDbConfigs = theDbConfigs;
    }
}

