/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.util;

import com.complexible.common.io.ByteWriters;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.metadata.InfoProperty;
import com.complexible.stardog.metadata.MetaProperties;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.MetaPropertyProvider;
import com.complexible.stardog.metadata.Metadata;
import com.complexible.stardog.metadata.MetadataIO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.UUID;

public class MemberIdFile
implements MetaPropertyProvider {
    private static final String OLD_STANDBY_METADATA_FILENAME = "standby.state";
    private static final String NODE_ID_FILENAME = "stardog.node-id";
    private static final String MEMBER_ID = "member.id";
    public static final InfoProperty<String> PROPERTY_MEMBER_ID = MetaProperty.info("member.id", String.class).readable().build();

    private static Metadata getMetadata(File theHome) {
        File aStateFile = new File(theHome, NODE_ID_FILENAME);
        if (!aStateFile.exists()) {
            File oldStateFile = new File(theHome, OLD_STANDBY_METADATA_FILENAME);
            if (oldStateFile.exists()) {
                try {
                    Metadata oldMeta = MetadataIO.read(Paths.get(oldStateFile.getAbsolutePath(), new String[0]));
                    MemberIdFile.createStateFile(aStateFile, oldMeta);
                }
                catch (IOException aIOEx) {
                    throw new StardogException(aIOEx);
                }
            } else {
                MemberIdFile.createStateFile(aStateFile, null);
            }
        }
        try {
            if (!MetaProperties.contains(MEMBER_ID)) {
                MetaProperties.register(MemberIdFile.class);
            }
            return MetadataIO.read(Paths.get(aStateFile.getAbsolutePath(), new String[0]));
        }
        catch (IOException aIOEx) {
            throw new StardogException(aIOEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createStateFile(File theFile, Metadata theMetadata) {
        Metadata aMetadata = theMetadata;
        if (null == aMetadata) {
            aMetadata = Metadata.create().set(PROPERTY_MEMBER_ID, UUID.randomUUID().toString());
        }
        try {
            theFile.createNewFile();
            try (FileOutputStream aStream = new FileOutputStream(theFile);){
                MetadataIO.writeBytes(aMetadata, ByteWriters.asByteWriter((OutputStream)aStream));
            }
        }
        catch (IOException aIoEx) {
            throw new StardogException(aIoEx);
        }
    }

    public static synchronized String getMemberId(File theStardogHome) {
        Metadata aMetadata = MemberIdFile.getMetadata(theStardogHome);
        return aMetadata.get(PROPERTY_MEMBER_ID);
    }
}

