/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.server;

import com.complexible.common.rdf.query.parser.sparql.ast.ParseException;
import com.complexible.stardog.DatabaseActionConflictException;
import com.complexible.stardog.db.DatabaseConsistencyException;
import com.complexible.stardog.db.DatabaseException;
import com.complexible.stardog.security.OperationNotSupportedException;
import com.complexible.stardog.server.DatabaseExistsException;
import com.complexible.stardog.server.FunctionExistsException;
import com.complexible.stardog.server.FunctionNotFoundException;
import com.complexible.stardog.server.InvalidConfigurationException;
import com.complexible.stardog.server.InvalidDatabaseNameException;
import com.complexible.stardog.server.InvalidDatabaseStateException;
import com.complexible.stardog.server.QueryExistsException;
import com.complexible.stardog.server.QueryNotFoundException;
import com.complexible.stardog.server.UnknownDatabaseException;
import com.complexible.stardog.server.UnknownTransactionException;
import com.stardog.ErrorCode;
import com.stardog.SkeletonErrorParser;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.query.InvalidQueryType;
import com.stardog.stark.query.MalformedQuery;
import com.stardog.stark.query.UnknownQuery;

public class DatabaseErrorParser
extends SkeletonErrorParser {
    public static final String DATABASE_PREFIX = "0D";
    public static final String QUERY_EXECUTION_PREFIX = "QE";

    protected Throwable toThrowable(ErrorCode thePec, String theErrorMsg) {
        return ((DatabaseErrorCode)thePec).toThrowable(theErrorMsg);
    }

    protected boolean canBeParsed(String theErrorCode) {
        return theErrorCode.startsWith(DATABASE_PREFIX) || theErrorCode.startsWith(QUERY_EXECUTION_PREFIX);
    }

    protected ErrorCode[] getErrorCodes() {
        return DatabaseErrorCode.values();
    }

    protected boolean codeMatches(ErrorCode thePec, Throwable theT) {
        return ((DatabaseErrorCode)thePec).applies(theT);
    }

    public static enum DatabaseErrorCode implements ErrorCode
    {
        DATABASE_CONSISTENCY_EXCEPTION("0D", "0CE", ErrorCode.Severity.CRITICAL){

            @Override
            boolean applies(Throwable t) {
                return t instanceof DatabaseConsistencyException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new DatabaseConsistencyException(errorMsg);
            }
        }
        ,
        UNKNOWN_DATABASE_EXCEPTION("0D", "001", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof DatabaseException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new DatabaseException(errorMsg);
            }
        }
        ,
        DATABASE_EXISTS("0D", "0DE", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof DatabaseExistsException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new DatabaseExistsException(errorMsg);
            }
        }
        ,
        DATABASE_CONFLICT("0D", "0DC", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof DatabaseActionConflictException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new DatabaseExistsException(errorMsg);
            }
        }
        ,
        INVALID_CONFIGURATION("0D", "ICC", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof InvalidConfigurationException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new InvalidConfigurationException(errorMsg);
            }
        }
        ,
        INVALID_DATABASE_NAME("0D", "IDN", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof InvalidDatabaseNameException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new InvalidDatabaseNameException(errorMsg);
            }
        }
        ,
        INVALID_DATABASE_STATE("0D", "IDS", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof InvalidDatabaseStateException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new InvalidDatabaseStateException(errorMsg);
            }
        }
        ,
        DATABASE_UNKNOWN("0D", "0DU", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof UnknownDatabaseException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new UnknownDatabaseException(errorMsg);
            }
        }
        ,
        TRANSACTION_UNKNOWN("0D", "0TU", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof UnknownTransactionException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new UnknownTransactionException(errorMsg);
            }
        }
        ,
        UNKNOWN_QUERY_EXCEPTION("QE", "001", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof UnknownQuery;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new UnknownQuery(errorMsg);
            }
        }
        ,
        FUNCTION_EXISTS("QE", "0FE", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof FunctionExistsException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new FunctionExistsException(errorMsg);
            }
        }
        ,
        FUNCTION_NOT_FOUND("QE", "FNF", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof FunctionNotFoundException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new FunctionNotFoundException(errorMsg);
            }
        }
        ,
        OPERATION_NOT_SUPPORTED("QE", "ONS", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof OperationNotSupportedException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new OperationNotSupportedException(errorMsg);
            }
        }
        ,
        QUERY_EXISTS("QE", "0QE", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof QueryExistsException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new QueryExistsException(errorMsg);
            }
        }
        ,
        QUERY_NOT_FOUND("QE", "QNF", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof QueryNotFoundException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new QueryNotFoundException(errorMsg);
            }
        }
        ,
        INVALID_QUERY_TYPE("QE", "IQT", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof InvalidQueryType;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new InvalidQueryType(errorMsg);
            }
        }
        ,
        MALFORMED_QUERY("QE", "MAQ", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof MalformedQuery;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new MalformedQuery(errorMsg);
            }
        }
        ,
        INVALID_RDF("QE", "IVR", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof InvalidRDF;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new InvalidRDF(errorMsg);
            }
        }
        ,
        PARSE_EXCEPTION("QE", "0PE", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof ParseException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new ParseException(errorMsg);
            }
        };

        private final String typePrefix;
        private final String formattedCode;
        private final ErrorCode.Severity severity;

        private DatabaseErrorCode(String typePrefix, String code, ErrorCode.Severity seveerity) {
            this.typePrefix = typePrefix;
            this.formattedCode = typePrefix + code + seveerity.getEncodedString();
            this.severity = seveerity;
        }

        public String getFormattedString() {
            return this.formattedCode;
        }

        public ErrorCode.Severity getSeverity() {
            return this.severity;
        }

        public String getCategory() {
            return this.typePrefix;
        }

        abstract boolean applies(Throwable var1);

        abstract Throwable toThrowable(String var1);
    }
}

