/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.security;

import com.complexible.stardog.security.CoreResourceType;
import com.complexible.stardog.security.SecurityResourceType;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityResourceTypes {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityResourceTypes.class);
    private static final Map<String, SecurityResourceType> TYPE_MAP = Maps.newHashMap();

    public static void register(SecurityResourceType theType) {
        if (TYPE_MAP.containsKey(theType.id()) && !TYPE_MAP.get(theType.id()).equals(theType)) {
            LOGGER.warn("{} cannot be registered, there is already an existing type with the id {}.", (Object)theType, (Object)theType.id());
            return;
        }
        TYPE_MAP.put(theType.id(), theType);
    }

    public static boolean isRegistered(SecurityResourceType theType) {
        return TYPE_MAP.containsKey(theType.id()) && TYPE_MAP.get(theType.id()).equals(theType);
    }

    public static SecurityResourceType get(String theName) {
        SecurityResourceType aResult = TYPE_MAP.get(theName);
        return aResult == null ? () -> theName : aResult;
    }

    public static Collection<SecurityResourceType> types() {
        return TYPE_MAP.values();
    }

    static {
        for (CoreResourceType aType : CoreResourceType.values()) {
            TYPE_MAP.put(aType.id(), aType);
        }
    }
}

