/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.security;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;

public interface SecurityConstants {
    public static final int MAX_NAME_LENGTH = 4095;
    public static final int MAX_DB_NAME_LENGTH = 64;
    public static final String REALM = "stardog";
    public static final String CLUSTER_REALM = "pack";
    public static final String CLUSTER_ADMIN_NAME = "zkadmin";
    public static final String ORIGINAL_USER_ATTRIBUTE = "original.user";
    public static final String NAME_REGEX_STR = "^[A-Za-z0-9_]{1}[A-Za-z0-9_/\\-\\@\\.\\+]*$";
    public static final Pattern NAME_REGEX = Pattern.compile("^[A-Za-z0-9_]{1}[A-Za-z0-9_/\\-\\@\\.\\+]*$");
    public static final String ROLENAME_REGEX_STR = "^[A-Za-z0-9_]{1}[A-Za-z0-9_/\\-\\@\\.\\+]*$";
    public static final String PW_REGEX = "(.)*";
    public static final String ACTION_REGEX = "(create|delete|read|write|revoke|grant|execute|all)";
    public static final String RESOURCE_NAME_REGEX_STR = "^\\*$|^[A-Za-z0-9_]{1}[A-Za-z0-9_/#\\-\\@\\.\\+:\\\\]*$";
    public static final String ALL_PERMISSION = "all";
    public static final String ALL_TYPE = "*";
    public static final String ALL_SUBJECTS = "*";
    public static final String ALL_RESOURCE = "*";
    public static final String CREATE_PERMISSION = "create";
    public static final String DELETE_PERMISSION = "delete";
    public static final String READ_PERMISSION = "read";
    public static final String WRITE_PERMISSION = "write";
    public static final String GRANT_PERMISSION = "grant";
    public static final String REVOKE_PERMISSION = "revoke";
    public static final String EXECUTE_PERMISSION = "execute";
    public static final String USER_TYPE = "user";
    public static final String ROLE_TYPE = "role";
    public static final String ROLE_ASSIGNMENT_TYPE = "role-assignment";
    public static final String PERMISSION_TYPE = "permission";
    public static final String DATABASE_TYPE = "db";
    public static final String DATABASE_EXPORT_TYPE = "db-export";
    public static final String NAMED_GRAPH_TYPE = "named-graph";
    public static final String DATABASE_METADATA_TYPE = "metadata";
    public static final String STORED_QUERY_TYPE = "stored-query";
    public static final String DATABASE_ADMIN_TYPE = "admin";
    public static final String DBMS_ADMIN_TYPE = "dbms-admin";
    public static final String DATA_SOURCE_TYPE = "data-source";
    public static final String VIRTUAL_GRAPH_TYPE = "virtual-graph";
    public static final String CACHE_TYPE = "cache";
    public static final String CACHE_TARGET_TYPE = "cache-target";
    public static final String STARDOG_PERMISSION_PREFIX = "stardog";
    public static final String PERMISSION_STRING_DELIMITER = ":";
    public static final String DBMS_SHUTDOWN = "shutdown";
    public static final String DBMS_SET_PROPERTY = "set-property";
    public static final String DBMS_LOGS = "logs";
    public static final String DBMS_SYSTEM = "system";
    public static final String DBMS_BACKUP_ALL = "backup-all";
    public static final String DBMS_METRICS = "metrics";
    public static final String READ_ONLY = "read-only";
    public static final String SENSITIVE_PROPERTIES_TYPE = "sensitive-properties";
    public static final String ENTITY_RESOLUTION_TYPE = "entity-resolution";
    public static final String DATABASE_MODELING_TYPE = "modeling";
    public static final char PART_DELIMITER = '\\';
    public static final char SUB_PART_DELIMITER = '|';
    public static final String PASSWORD_SESSION_KEY = "PASSWORD_SESSION_KEY";

    public static final class Names {
        public static void assertValidUserName(String theUserName, Pattern thePattern) {
            Preconditions.checkNotNull((Object)theUserName);
            if (!theUserName.equals("*") && !thePattern.matcher(theUserName).matches()) {
                throw new IllegalArgumentException();
            }
        }

        public static void assertValidRoleName(String theRoleName) {
            Preconditions.checkNotNull((Object)theRoleName);
            if (!theRoleName.equals("*") && !NAME_REGEX.matcher(theRoleName).matches()) {
                throw new IllegalArgumentException();
            }
        }
    }
}

