/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.security;

import com.complexible.stardog.security.ActionType;
import com.complexible.stardog.security.CoreResourceType;
import com.complexible.stardog.security.Permission;
import com.complexible.stardog.security.SecurityResourceType;
import com.complexible.stardog.security.SecurityResourceTypes;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public final class Permissions {
    private static final Splitter SPLITTER = Splitter.on((String)":").trimResults().omitEmptyStrings();

    private Permissions() {
        throw new AssertionError();
    }

    public static Permission create(String theSubject, ActionType theAction, SecurityResourceType theType, String theResource, String ... theSubResources) {
        return new Permission(theSubject, theAction, theType, (ImmutableList<String>)ImmutableList.builder().add((Object)theResource).add((Object[])theSubResources).build());
    }

    public static Permission create(String theSubject, ActionType theAction, CoreResourceType theSubjectType, SecurityResourceType theType, String theResource, String ... theSubResources) {
        return new Permission(theSubject, theAction, theSubjectType, theType, (ImmutableList<String>)ImmutableList.builder().add((Object)theResource).add((Object[])theSubResources).build());
    }

    public static Permission create(String theSubject, ActionType theAction, SecurityResourceType theType, List<String> theResources) {
        return new Permission(theSubject, theAction, theType, (ImmutableList<String>)ImmutableList.copyOf(theResources));
    }

    public static Permission create(String theSubject, ActionType theAction, CoreResourceType theSubjectType, SecurityResourceType theResourceType, List<String> theResources) {
        return new Permission(theSubject, theAction, theSubjectType, theResourceType, (ImmutableList<String>)ImmutableList.copyOf(theResources));
    }

    public static Permission create(String thePermString) {
        List aTokens = SPLITTER.splitToList((CharSequence)thePermString);
        int aIndex = 0;
        if ("stardog".equals(aTokens.get(0))) {
            // empty if block
        }
        int n = ++aIndex;
        String aSubject = (String)aTokens.get(n);
        int n2 = ++aIndex;
        ActionType aActionType = ActionType.fromString((String)aTokens.get(n2));
        int n3 = ++aIndex;
        String aResTypeStr = (String)aTokens.get(n3);
        SecurityResourceType aType = Permissions.type(aResTypeStr);
        List aResources = aTokens.subList(++aIndex, aTokens.size());
        return new Permission(aSubject, aActionType, aType, (ImmutableList<String>)ImmutableList.copyOf(aResources));
    }

    public static SecurityResourceType type(String theStr) {
        SecurityResourceType result = CoreResourceType.fromString(theStr);
        if (result == null) {
            result = SecurityResourceTypes.get(theStr);
        }
        return result;
    }

    @VisibleForTesting
    public static Permission su(String theSubject) {
        return Permissions.create(theSubject, ActionType.ALL, (SecurityResourceType)CoreResourceType.ALL, "*", new String[0]);
    }

    public static ActionBuilder of(String theSubject) {
        return new ActionBuilder(theSubject);
    }

    public static final class ActionBuilder {
        private final String mSubject;

        private ActionBuilder(String theSubject) {
            this.mSubject = theSubject;
        }

        public TypeBuilder all() {
            return new TypeBuilder(this.mSubject, ActionType.ALL);
        }

        public TypeBuilder create() {
            return new TypeBuilder(this.mSubject, ActionType.CREATE);
        }

        public TypeBuilder delete() {
            return new TypeBuilder(this.mSubject, ActionType.DELETE);
        }

        public TypeBuilder execute() {
            return new TypeBuilder(this.mSubject, ActionType.EXECUTE);
        }

        public TypeBuilder grant() {
            return new TypeBuilder(this.mSubject, ActionType.GRANT);
        }

        public TypeBuilder revoke() {
            return new TypeBuilder(this.mSubject, ActionType.REVOKE);
        }

        public TypeBuilder read() {
            return new TypeBuilder(this.mSubject, ActionType.READ);
        }

        public TypeBuilder write() {
            return new TypeBuilder(this.mSubject, ActionType.WRITE);
        }
    }

    public static final class ResourceBuilder {
        private final String mSubject;
        private final ActionType mActionType;
        private final SecurityResourceType mResourceType;

        public ResourceBuilder(String theSubject, ActionType theActionType, SecurityResourceType theResourceType) {
            this.mSubject = theSubject;
            this.mActionType = theActionType;
            this.mResourceType = theResourceType;
        }

        public Permission all() {
            return Permissions.create(this.mSubject, this.mActionType, this.mResourceType, "*", new String[0]);
        }

        public Permission on(String theResource) {
            return Permissions.create(this.mSubject, this.mActionType, this.mResourceType, theResource, new String[0]);
        }

        public Permission on(String ... theResource) {
            return Permissions.create(this.mSubject, this.mActionType, this.mResourceType, Lists.newArrayList((Object[])theResource));
        }
    }

    public static final class TypeBuilder {
        private final String mSubject;
        private final ActionType mActionType;

        public TypeBuilder(String theSubject, ActionType theActionType) {
            this.mSubject = theSubject;
            this.mActionType = theActionType;
        }

        public ResourceBuilder all() {
            return new ResourceBuilder(this.mSubject, this.mActionType, CoreResourceType.ALL);
        }

        public ResourceBuilder type(SecurityResourceType theType) {
            return new ResourceBuilder(this.mSubject, this.mActionType, theType);
        }

        public ResourceBuilder users() {
            return new ResourceBuilder(this.mSubject, this.mActionType, CoreResourceType.USER);
        }

        public ResourceBuilder roles() {
            return new ResourceBuilder(this.mSubject, this.mActionType, CoreResourceType.ROLE);
        }

        public ResourceBuilder database() {
            return new ResourceBuilder(this.mSubject, this.mActionType, CoreResourceType.DATABASE);
        }

        public ResourceBuilder databaseMetadata() {
            return new ResourceBuilder(this.mSubject, this.mActionType, CoreResourceType.DATABASE_METADATA);
        }

        public ResourceBuilder databaseAdmin() {
            return new ResourceBuilder(this.mSubject, this.mActionType, CoreResourceType.DATABASE_ADMIN);
        }

        public ResourceBuilder dbmsAdmin() {
            return new ResourceBuilder(this.mSubject, this.mActionType, CoreResourceType.DBMS_ADMIN);
        }

        public ResourceBuilder namedGraph() {
            return new ResourceBuilder(this.mSubject, this.mActionType, CoreResourceType.NAMED_GRAPH);
        }

        public ResourceBuilder storedQuery() {
            return new ResourceBuilder(this.mSubject, this.mActionType, CoreResourceType.STORED_QUERY);
        }
    }
}

