/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.security;

import com.complexible.stardog.security.ActionType;
import com.complexible.stardog.security.CoreResourceType;
import com.complexible.stardog.security.Permission;
import com.complexible.stardog.security.PermissionManager;
import com.complexible.stardog.security.Permissions;
import com.complexible.stardog.security.SecurityResourceType;
import com.complexible.stardog.security.StardogSecurityException;
import com.stardog.stark.IRI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class NamedGraphPermissions {
    private final PermissionManager mPermissionManager;
    private final String mDb;
    private final Set<IRI> mRead = new HashSet<IRI>();
    private final Set<IRI> mWrite = new HashSet<IRI>();

    private NamedGraphPermissions(PermissionManager thePermissionManager, String theDb) {
        this.mPermissionManager = thePermissionManager;
        this.mDb = theDb;
    }

    public static NamedGraphPermissions on(PermissionManager theAdminConnection, String theDb) {
        return new NamedGraphPermissions(theAdminConnection, theDb);
    }

    public NamedGraphPermissions read(IRI theURI, IRI ... theOtherURIS) {
        this.mRead.add(theURI);
        if (theOtherURIS != null) {
            Collections.addAll(this.mRead, theOtherURIS);
        }
        return this;
    }

    public NamedGraphPermissions write(IRI theURI, IRI ... theOtherURIs) {
        this.mWrite.add(theURI);
        if (theOtherURIs != null) {
            Collections.addAll(this.mWrite, theOtherURIs);
        }
        return this;
    }

    public NamedGraphPermissions rw(IRI theURI, IRI ... theOtherURIs) {
        this.mRead.add(theURI);
        this.mWrite.add(theURI);
        if (theOtherURIs != null) {
            for (IRI aURI : theOtherURIs) {
                this.mRead.add(aURI);
                this.mWrite.add(aURI);
            }
        }
        return this;
    }

    public NamedGraphPermissions grantUser(String theSubj) throws StardogSecurityException {
        this.modifyPermissions(theSubj, true, true);
        return this;
    }

    public NamedGraphPermissions grantRole(String theSubj) throws StardogSecurityException {
        this.modifyPermissions(theSubj, false, true);
        return this;
    }

    public NamedGraphPermissions revokeUser(String theSubj) throws StardogSecurityException {
        this.modifyPermissions(theSubj, true, false);
        return this;
    }

    public NamedGraphPermissions revokeRole(String theSubj) throws StardogSecurityException {
        this.modifyPermissions(theSubj, false, false);
        return this;
    }

    private NamedGraphPermissions modifyPermissions(String theSubj, boolean theIsUser, boolean theIsGrant) throws StardogSecurityException {
        Permission aPermission;
        if (theIsUser && theIsGrant) {
            this.mPermissionManager.deleteUserPerm(Permissions.create(theSubj, ActionType.ALL, (SecurityResourceType)CoreResourceType.NAMED_GRAPH, this.mDb, "*"));
        }
        for (IRI aRead : this.mRead) {
            aPermission = Permissions.create(theSubj, ActionType.READ, (SecurityResourceType)CoreResourceType.NAMED_GRAPH, this.mDb, aRead.toString());
            if (theIsUser) {
                if (theIsGrant) {
                    this.mPermissionManager.addUserPerm(aPermission);
                    continue;
                }
                this.mPermissionManager.deleteUserPerm(aPermission);
                continue;
            }
            if (theIsGrant) {
                this.mPermissionManager.addRolePerm(aPermission);
                continue;
            }
            this.mPermissionManager.deleteRolePerm(aPermission);
        }
        for (IRI aWrite : this.mWrite) {
            aPermission = Permissions.create(theSubj, ActionType.WRITE, (SecurityResourceType)CoreResourceType.NAMED_GRAPH, this.mDb, aWrite.toString());
            if (theIsUser) {
                if (theIsGrant) {
                    this.mPermissionManager.addUserPerm(aPermission);
                    continue;
                }
                this.mPermissionManager.deleteUserPerm(aPermission);
                continue;
            }
            if (theIsGrant) {
                this.mPermissionManager.addRolePerm(aPermission);
                continue;
            }
            this.mPermissionManager.deleteRolePerm(aPermission);
        }
        return this;
    }
}

