/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.query.hints;

import com.complexible.stardog.query.hints.BaseHint;
import com.complexible.stardog.query.hints.Hint;
import com.complexible.stardog.query.hints.InvalidHintValue;
import com.google.common.base.Joiner;
import java.util.Arrays;

public interface RegisteredHint<T> {
    public String name();

    public String description();

    public Hint<T> create(String var1) throws InvalidHintValue;

    default public boolean retainedAfterTermReplacement() {
        return false;
    }

    default public Hint<T> create(T value) {
        return new BaseHint<T>(this.name(), value);
    }

    public static abstract class Abstract<T>
    implements RegisteredHint<T> {
        private final String mName;
        private final String mDescription;

        protected Abstract(String theName, String theDescription) {
            this.mName = theName;
            this.mDescription = theDescription;
        }

        @Override
        public String name() {
            return this.mName;
        }

        @Override
        public String description() {
            return this.mDescription;
        }

        public Hint<T> createEmpty() {
            return new BaseHint<Object>(this.mName, null);
        }

        public static Integer parseInteger(String name, String value) throws InvalidHintValue {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException err) {
                throw new InvalidHintValue(name, value);
            }
        }

        public static Boolean parseBoolean(String name, String value) throws InvalidHintValue {
            if (value == null) {
                throw new InvalidHintValue(name);
            }
            if (value.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (value.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            throw new InvalidHintValue(name, value);
        }

        public static <E extends Enum<E>> E parseEnum(String name, String value, E[] valid) throws InvalidHintValue {
            if (value == null) {
                throw new InvalidHintValue(name);
            }
            for (E validValue : valid) {
                if (!value.equalsIgnoreCase(((Enum)validValue).name())) continue;
                return validValue;
            }
            throw new InvalidHintValue(name, value, Joiner.on((char)',').join(Arrays.asList(valid)));
        }

        public static String[] parseCsv(String values, String separator) {
            return values == null ? new String[]{} : values.split(separator);
        }
    }
}

