/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.query;

import com.complexible.common.base.Objects2;
import com.complexible.stardog.Contexts;
import com.complexible.stardog.query.GraphAliases;
import com.complexible.stardog.query.GraphAliasesUpdater;
import com.complexible.stardog.query.GraphAliasesVocabulary;
import com.complexible.stardog.query.LazyGraphAliases;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Value;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.SelectQueryResult;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphAliases
implements LazyGraphAliases,
GraphAliasesUpdater {
    protected static final Logger LOGGER = LoggerFactory.getLogger(GraphAliases.class);
    protected final Map<IRI, Set<Resource>> mAliases = Maps.newHashMap();
    private ImmutableMap<IRI, Set<Resource>> mLastInitialized = null;
    protected volatile boolean mIsInitialized = false;
    protected boolean mChanged = false;

    protected AbstractGraphAliases() {
    }

    protected AbstractGraphAliases(AbstractGraphAliases theAliases) {
        this.mAliases.putAll(theAliases.mAliases);
        this.mIsInitialized = theAliases.mIsInitialized;
        this.mLastInitialized = theAliases.mLastInitialized;
        this.mChanged = theAliases.mChanged;
    }

    @Override
    public GraphAliasesUpdater updater() {
        return this;
    }

    @Override
    public final boolean isEmpty() {
        return this.mAliases.isEmpty();
    }

    protected void assertInitialized() {
        if (!this.mIsInitialized) {
            this.initialize();
        }
    }

    protected void saveState() {
        if (this.mLastInitialized == null) {
            this.mLastInitialized = ImmutableMap.copyOf(this.mAliases);
        }
    }

    @Override
    public void invalidate() {
        LOGGER.debug("Graph alias configuration invalidated");
        this.mIsInitialized = false;
    }

    @Override
    public final synchronized void initialize() {
        if (this.mIsInitialized) {
            return;
        }
        LOGGER.debug("Loading named graph alias configuration from data");
        this.mAliases.clear();
        this.mIsInitialized = true;
        try (SelectQueryResult aliases = this.select("select ?alias ?graph { #pragma reasoning off \n?alias <" + String.valueOf(GraphAliasesVocabulary.GA_PREDICATE) + "> ?graph } order by ?alias");){
            IRI prevAlias = null;
            HashSet graphs = Sets.newHashSet();
            while (aliases.hasNext()) {
                BindingSet next = (BindingSet)aliases.next();
                IRI alias = this.getOrThrow(next, "alias", IRI.class);
                Resource graph = this.getOrThrow(next, "graph", Resource.class);
                if (prevAlias != null && !alias.equals(prevAlias)) {
                    this.mAliases.put(prevAlias, (Set<Resource>)ImmutableSet.copyOf((Collection)graphs));
                    graphs.clear();
                }
                graphs.add(graph);
                prevAlias = alias;
            }
            if (!graphs.isEmpty()) {
                this.mAliases.put(prevAlias, (Set<Resource>)ImmutableSet.copyOf((Collection)graphs));
            }
        }
        catch (Exception e) {
            this.mIsInitialized = false;
            throw e;
        }
        this.mChanged = false;
        this.mLastInitialized = null;
    }

    private <T extends Resource> T getOrThrow(BindingSet bs, String var, Class<T> clazz) {
        Value val = bs.get(var);
        return (T)((Resource)Objects2.castTo((Object)val, clazz, (String)"Invalid graph alias configuration: %s is expected to be a %", (Object[])new Object[]{val, clazz.getSimpleName()}));
    }

    @Override
    public Set<IRI> aliases() {
        this.assertInitialized();
        return Collections.unmodifiableSet(this.mAliases.keySet());
    }

    @Override
    public Set<Resource> graphs(Resource alias) {
        this.assertInitialized();
        if (!(alias instanceof IRI)) {
            return Collections.singleton(alias);
        }
        return this.mAliases.getOrDefault(alias, Collections.singleton(alias));
    }

    @Override
    public GraphAliasesUpdater add(IRI alias, Resource ... graphs) {
        Preconditions.checkArgument((!Contexts.isDefaultGraphOrWildcard((Resource)alias) ? 1 : 0) != 0, (Object)("The meta-graph " + String.valueOf(alias) + " cannot be an alias"));
        this.assertInitialized();
        this.saveState();
        this.mAliases.merge(alias, (Set<Resource>)ImmutableSet.copyOf((Object[])graphs), (oldG, newG) -> ImmutableSet.copyOf((Collection)Sets.union((Set)oldG, (Set)newG)));
        this.mChanged = true;
        LOGGER.debug("Added " + Joiner.on((char)',').join((Object[])graphs) + " to the definition of " + String.valueOf(alias));
        return this;
    }

    @Override
    public GraphAliasesUpdater remove(IRI alias, Resource ... graphs) {
        this.assertInitialized();
        this.saveState();
        this.mChanged = true;
        LOGGER.debug("Removed " + Joiner.on((char)',').join((Object[])graphs) + " from the definition of " + String.valueOf(alias));
        if (graphs.length == 0) {
            this.mAliases.remove(alias);
            return this;
        }
        this.mAliases.merge(alias, (Set<Resource>)ImmutableSet.copyOf((Object[])graphs), (oldG, newG) -> {
            Sets.SetView diff = Sets.difference((Set)oldG, (Set)newG);
            return diff.isEmpty() ? null : ImmutableSet.copyOf((Collection)diff);
        });
        return this;
    }

    @Override
    public GraphAliasesUpdater removeAll() {
        this.assertInitialized();
        this.saveState();
        LOGGER.debug("Graph configuration cleared");
        this.mChanged |= !this.mAliases.isEmpty();
        this.mAliases.clear();
        return this;
    }

    @Override
    public void reset() {
        if (this.mLastInitialized != null) {
            this.mAliases.clear();
            this.mAliases.putAll((Map<IRI, Set<Resource>>)this.mLastInitialized);
        }
    }

    public IRI getNamedGraph() {
        return GraphAliasesVocabulary.GA_GRAPH;
    }

    protected abstract SelectQueryResult select(String var1);
}

