/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.process;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public enum ProcessType {
    Transaction("Transaction", false, true, true),
    Query("Query", false, false, true),
    Export("Data Export", true, false),
    DBBackup("DB Backup", true, true),
    ServerBackup("Server Backup", true, true),
    Restore("Data Restore", true, true, true),
    DatabaseCreation("Database Creation", true, true, true),
    Cache("Cache", true, false),
    IndexVerify("Database Verification", true, true),
    DBMigrate("Database Migration", true, false, true),
    Optimize("Database Optimization", true, true),
    Statistics("Computing statistics", true, false),
    FTSIndexing("Full-Text Search Indexing", true, false),
    SemanticIndexing("Semantic Indexing", true, false),
    LiteralIndexing("Literals Indexing", true, false),
    GeoIndexing("Geospatial Indexing", false, false),
    Online("Bringing Database Online", false, false),
    Startup("Startup", false, false),
    Storage("Storage", true, false),
    StoredFunction("Stored Functions", false, false),
    StoredQuery("Stored Query", false, false),
    VirtualGraphs("Virtual Graph", false, false),
    Catalog("Catalog Reload", false, false),
    Unknown("Unknown", false, false),
    SchemaReasoning("Schema Reasoning", false, false),
    SameAsMaterialization("owl:sameAs Indexing", true, false),
    SchemaExtraction("Schema Extraction", false, false),
    Explanation("Explaining Inferences", false, false),
    ClusterFail("Error Node Unreachable", false, false),
    HttpProcessing("HTTP Processing", false, false),
    ResolveEntities("Resolve Entities using external compute", false, false);

    private final String mName;
    private final boolean hasProgress;
    private final boolean isReplicated;
    private final boolean isMutation;

    private ProcessType(String name, boolean hasProgress, boolean theIsReplicated) {
        this(name, hasProgress, theIsReplicated, false);
    }

    private ProcessType(String name, boolean hasProgress, boolean theIsReplicated, boolean isMutation) {
        this.mName = name;
        this.hasProgress = hasProgress;
        this.isReplicated = theIsReplicated;
        this.isMutation = isMutation;
    }

    public String toString() {
        return this.mName;
    }

    public boolean hasProgress() {
        return this.hasProgress;
    }

    public boolean isReplicated() {
        return this.isReplicated;
    }

    public boolean isMutation() {
        return this.isMutation;
    }

    public String internalId(@Nonnull String dbname, String user) {
        Preconditions.checkNotNull((Object)dbname);
        return "internal-" + this.name() + "-" + (user != null ? user : "") + "-" + dbname;
    }
}

