/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.process;

import com.complexible.common.base.Progress;
import com.complexible.stardog.process.ProcessType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public interface ProcessInfo {
    public static final long NO_TIME = -1L;

    public String getKernelID();

    public String getID();

    public String getDBName();

    public String getUser();

    default public boolean isRunning() {
        return this.getProcessStatus() == Status.RUNNING;
    }

    default public boolean isCanceled() {
        return this.getProcessStatus() == Status.KILLED;
    }

    default public boolean isEnded() {
        return this.getProcessStatus() == Status.FINISHED;
    }

    public Status getProcessStatus();

    public ProcessType getType();

    default public Map<String, String> details() {
        return new HashMap<String, String>();
    }

    public long getStartTime();

    public long getExecutionTime();

    public Optional<Progress> progress();

    public boolean isManaged();

    public static enum Status {
        NOT_STARTED{

            public String toString() {
                return "Not started";
            }
        }
        ,
        RUNNING{

            public String toString() {
                return "Running";
            }
        }
        ,
        KILLED{

            public String toString() {
                return "Terminating";
            }
        }
        ,
        FINISHED{

            public String toString() {
                return "Finished";
            }
        };

    }
}

