/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.metrics;

public class MetricsNaming {
    private static final String BASE = "";
    public static final String MEMTABLE = ".memtable";

    public static boolean isDatabaseMetric(String theName) {
        return theName.startsWith("databases");
    }

    public static final class Database {
        public static final String BASE = "databases";

        public static String name(String theDb) {
            return "databases." + theDb;
        }

        public static String state(String theDb) {
            return Database.name(theDb) + ".state";
        }

        public static String size(String theDb) {
            return Database.name(theDb) + ".size";
        }

        public static String openConnections(String theDb) {
            return Database.name(theDb) + ".openConnections";
        }

        public static String openTransactions(String theDb) {
            return Database.name(theDb) + ".txns.openTransactions";
        }

        public static String txTimer(String theDb) {
            return Database.name(theDb) + ".txns.latency";
        }

        public static String txSize(String theDb) {
            return Database.name(theDb) + ".txns.size";
        }

        public static String added(String theDb) {
            return Database.name(theDb) + ".added";
        }

        public static String deleted(String theDb) {
            return Database.name(theDb) + ".deleted";
        }

        public static String queries(String theDb) {
            return Database.name(theDb) + ".queries.latency";
        }

        public static String runningQueries(String theDb) {
            return Database.name(theDb) + ".queries.running";
        }

        public static String planCache(String theDb) {
            return Database.name(theDb) + ".planCache";
        }

        public static String memory(String theDb) {
            return Database.name(theDb) + ".memory.total";
        }

        public static String liveDataSize(String theDb) {
            return Database.name(theDb) + ".liveDataSize";
        }

        public static String totalDataSize(String theDb) {
            return Database.name(theDb) + ".size.disk.total";
        }

        public static String runningFlushCount(String theDb) {
            return Database.name(theDb) + ".flushes.running";
        }

        public static String runningCompactionCount(String theDb) {
            return Database.name(theDb) + ".compactions.running";
        }

        public static String numFiles(String theDb) {
            return Database.name(theDb) + ".files.total";
        }

        public static String spilledBytes(String theDb) {
            return Database.name(theDb) + ".queries.memory.spilled";
        }

        public static String acquiredBytes(String theDb) {
            return Database.name(theDb) + ".queries.memory.acquired";
        }

        public static String numDocs(String theDb) {
            return Database.name(theDb) + ".search.numDocs";
        }

        public static String numFeatures(String theDb) {
            return Database.name(theDb) + ".numFeatures";
        }

        public static String dictionaryCacheHits(String theDb) {
            return Database.name(theDb) + "#dictionary.cache.hits";
        }

        public static String dictionaryCacheMisses(String theDb) {
            return Database.name(theDb) + "#dictionary.cache.misses";
        }
    }

    public static final class JVM {
        public static final String BASE = "jvm";
        public static final String THREADS = "jvm.threads";
    }

    public static final class Virtual {
        public static final String BASE = "virtual";
        public static final String VIRTUAL_GRAPHS = "virtual.total.virtualGraphs";
        public static final String DATA_SOURCES = "virtual.total.dataSources";

        public static String totalVirtualGraphs() {
            return VIRTUAL_GRAPHS;
        }

        public static String totalDataSourceType(String theType) {
            return "virtual.total.dataSources." + theType;
        }
    }

    public static class Index {
        public static final String BASE = "databases";
        public static final String TOTAL_MEMTABLE_SIZE_SUFFIX = ".memtable.total.size.bytes";
        public static final String TABLE_READER = ".tableReaderMemory";
        public static final String TABLE_READER_SIZE_SUFFIX = ".tableReaderMemory.bytes";

        public static String name(String theDb, String indexType) {
            String base = "databases." + theDb;
            if (indexType != null) {
                base = base + "#" + indexType;
            }
            return base;
        }

        public static String numFiles(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".files.total";
        }

        public static String runningFlushCount(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".flushes.running";
        }

        public static String runningCompactionCount(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".compactions.running";
        }

        public static String liveDataSize(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".liveDataSize";
        }

        public static String numKeys(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".numKeys";
        }

        public static String numLevels(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".numLevels";
        }

        public static String backgroundErrors(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".backgroundErrors";
        }

        public static String pendingCompactions(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".compactions.pending";
        }

        public static String pendingFlushes(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".flushes.pending";
        }

        public static String tableReaderMemory(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + TABLE_READER_SIZE_SUFFIX;
        }

        public static String immutableMemtableCount(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".memtable.immutable.count";
        }

        public static String totalMemtableSize(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + TOTAL_MEMTABLE_SIZE_SUFFIX;
        }

        public static String totalUnpinnedMemtableSize(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".memtable.unpinned.size.bytes";
        }

        public static String totalPinnedMemtableSize(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".memtable.pinned.size.bytes";
        }

        public static String totalActiveMemtableSize(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".memtable.active.size.bytes";
        }

        public static String totalImmutableMemtableSize(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".memtable.immutable.size.bytes";
        }

        public static String immutableMemtableEntries(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".memtable.immutable.entries";
        }

        public static String activeMemtableEntries(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".memtable.active.entries";
        }

        public static String memtableStalls(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".memtable.memtableStalls";
        }

        public static String memtableSlowdowns(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".memtable.memtableSlowdowns";
        }

        public static String totalStalls(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".stalls";
        }

        public static String totalSlowdowns(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".slowdowns";
        }

        public static String stallsPendingCompaction(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".stalls.pendingCompaction";
        }

        public static String slowdownsPendingCompaction(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".slowdowns.pendingCompaction";
        }

        public static String l0Slowdowns(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".slowdowns.l0";
        }

        public static String l0Stalls(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".stalls.l0";
        }

        public static String l0SlowdownsWithCompaction(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".slowdowns.l0.withCompaction";
        }

        public static String l0StallsWithCompaction(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".stalls.l0.withCompaction";
        }

        public static String numFilesCompacting(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".numFilesCompacting";
        }

        public static String completedCompactions(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".compactions.completed";
        }

        public static String compactionBytesRead(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".compactions.read.bytes";
        }

        public static String compactionBytesWritten(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".compactions.written.bytes";
        }

        public static String compactionReadThroughput(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".compaction.read.throughput.bytesPerSec";
        }

        public static String compactionWriteThroughput(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".compaction.write.throughput.bytesPerSec";
        }

        public static String totalCompactionTime(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".compaction.time.sec";
        }

        public static String avgCompactionTime(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".compaction.time.avg.sec";
        }

        public static String writeAmplification(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".writeAmplification";
        }

        public static String keysCompacted(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".compaction.keysProcessed";
        }

        public static String keysDropped(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".compaction.keysDropped";
        }

        public static String totalMemoryUsage(String dbName, String indexTypeName) {
            return Index.name(dbName, indexTypeName) + ".memory.total";
        }

        public static class Level {
            public static String level(String order, int level) {
                return order + ".l" + level;
            }

            public static String files(String dbname, String indexTypeName, String order, int level) {
                return Index.name(dbname, indexTypeName) + "." + Level.level(order, level) + ".files";
            }

            public static String liveDataSize(String dbname, String indexTypeName, String order, int level) {
                return Index.name(dbname, indexTypeName) + "." + Level.level(order, level) + ".liveDataSize";
            }

            public static String numKeys(String dbname, String indexTypeName, String order, int level) {
                return Index.name(dbname, indexTypeName) + "." + Level.level(order, level) + ".numKeys";
            }
        }
    }

    public static final class License {
        public static final String BASE = "dbms.license.";

        public static String expiration() {
            return "dbms.license.expiration";
        }

        public static String quantity() {
            return "dbms.license.quantity";
        }

        public static String type() {
            return "dbms.license.type";
        }

        public static String voiceboxLimit() {
            return "dbms.license.voicebox.limit";
        }

        public static String uuid() {
            return "dbms.license.uuid";
        }
    }

    public static final class Kernel {
        public static final String BASE = "dbms";
        public static final String SYSTEM_BASE = "system";
        public static final String MEM = "dbms.memory";
        public static final String DBMS_MEMTABLE = "dbms.memory.memtable";
        public static final String BLOCK_CACHE = "dbms.memory.blockcache";
        public static final String COMPACTIONS = "dbms.compactions";

        public static String option(String theOptionName) {
            return "dbms." + theOptionName;
        }

        public static String version() {
            return Kernel.option("version");
        }

        public static String type() {
            return Kernel.option("type");
        }

        public static String id() {
            return Kernel.option("id");
        }

        public static String home() {
            return Kernel.option("home");
        }

        public static String homeTotalSpace() {
            return Kernel.option("home.total.space");
        }

        public static String homeFreeSpace() {
            return Kernel.option("home.free.space");
        }

        public static String homeUsableSpace() {
            return Kernel.option("home.usable.space");
        }

        public static String systemUptime() {
            return "system.uptime";
        }

        public static String os() {
            return "system.os";
        }

        public static String arch() {
            return "system.arch";
        }

        public static String systemCpuUsage() {
            return "system.cpu.usage";
        }

        public static String credentialsCacheSize() {
            return Kernel.option("credentials.cache.size");
        }

        public static String credentialsCacheHits() {
            return Kernel.option("credentials.cache.hits");
        }

        public static String credentialsCacheMisses() {
            return Kernel.option("credentials.cache.misses");
        }

        public static String credentialsCacheLoadSuccesses() {
            return Kernel.option("credentials.cache.loadSuccesses");
        }

        public static String credentialsCacheLoadFailures() {
            return Kernel.option("credentials.cache.loadFailures");
        }

        public static String credentialsCacheEvictions() {
            return Kernel.option("credentials.cache.evictions");
        }

        public static String numDatabases() {
            return "system.db.count";
        }

        public static String numUsers() {
            return "system.user.count";
        }

        public static String numRunningCompactions() {
            return "dbms.compactions.count";
        }

        public static String numRunningFlushes() {
            return "dbms.memory.memtable.flush.count";
        }

        public static String nativeReaderMemUsed() {
            return "dbms.memory.native.reader.used";
        }

        public static String memtableSize() {
            return "dbms.memory.memtable.size";
        }

        public static String activeMemtableSize() {
            return "dbms.memory.memtable.active.size";
        }

        public static String immutableMemtableSize() {
            return "dbms.memory.memtable.immutable.size";
        }

        public static String pinnedMemtableSize() {
            return "dbms.memory.memtable.pinned.size";
        }

        public static String blockCacheSize(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".size";
        }

        public static String pinnedBlockCacheSize(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".pinned.size";
        }

        public static String blockCacheMax(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".size.max";
        }

        public static String blockCacheRatio(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".ratio";
        }

        public static String blockCacheHits(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".hits";
        }

        public static String blockCacheMisses(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".misses";
        }

        public static String blockCacheAdds(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".add.count";
        }

        public static String blockCacheAddFailures(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".add.failure.count";
        }

        public static String blockCacheIndexRatio(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".index.ratio";
        }

        public static String blockCacheIndexHits(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".index.hits";
        }

        public static String blockCacheIndexMisses(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".index.misses";
        }

        public static String blockCacheFilterRatio(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".filter.ratio";
        }

        public static String blockCacheFilterHits(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".filter.hits";
        }

        public static String blockCacheFilterMisses(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".filter.misses";
        }

        public static String blockCacheDataRatio(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".data.ratio";
        }

        public static String blockCacheDataHits(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".data.hits";
        }

        public static String blockCacheDataMisses(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".data.misses";
        }

        public static String blockCacheBytesRead(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".read";
        }

        public static String blockCacheBytesWritten(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".written";
        }

        public static String blockCacheCachesIndexBlocks(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".cachesIndexBlocks";
        }

        public static String blockCacheHasStrictCapacityLimit(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".strictCapacity";
        }

        public static String blockCacheUsage(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".usage";
        }

        public static String blockCachePinnedUsage(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".pinnedUsage";
        }

        public static String blockCacheCapacity(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".capacity";
        }

        public static String blockCacheIteratorCreated(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".iteratorCreated";
        }

        public static String blockCacheIteratorDeleted(String cacheName) {
            return "dbms.memory.blockcache." + cacheName + ".iteratorDeleted";
        }

        public static String memHeapQueryBlocksUsed() {
            return "dbms.memory.heap.query.blocks.used";
        }

        public static String memHeapQueryBlocksMax() {
            return "dbms.memory.heap.query.blocks.max";
        }

        public static String memNativeQueryBlocksUsed() {
            return "dbms.memory.native.query.blocks.used";
        }

        public static String memNativeQueryBlocksMax() {
            return "dbms.memory.native.query.blocks.max";
        }

        public static String memHeapUsed() {
            return "dbms.memory.heap.used";
        }

        public static String memHeapMax() {
            return "dbms.memory.heap.max";
        }

        public static String memMappedUsed() {
            return "dbms.memory.mapped.used";
        }

        public static String memDirectBufferUsed() {
            return "dbms.memory.direct.buffer.used";
        }

        public static String memNativeMax() {
            return "dbms.memory.native.max";
        }

        public static String memNativeUsed() {
            return "dbms.memory.native.used";
        }

        public static String memRss() {
            return "dbms.memory.system.rss";
        }

        public static String memRssPeak() {
            return "dbms.memory.system.rss.peak";
        }

        public static String memVirtual() {
            return "dbms.memory.system.virtual";
        }

        public static String memRegionCount() {
            return "dbms.memory.system.regionCount";
        }

        public static String memPinnedSize() {
            return "dbms.memory.system.pinnedSize";
        }

        public static String pageSize() {
            return "dbms.memory.system.pageSize";
        }

        public static String[] keys() {
            return new String[]{Kernel.version(), Kernel.type(), Kernel.id()};
        }

        public static String memUsedRato() {
            return "dbms.memory.system.usageRatio";
        }
    }

    public static final class Cluster {
        public static final String BASE = "cluster";
        public static final String CLUSTER = "cluster";

        public static String getBase(String dbName) {
            return dbName != null ? "cluster." + dbName : "cluster";
        }

        public static String syncChecks() {
            return Cluster.getBase(null) + ".sync.check.count";
        }

        public static String syncAttempts(String dbName) {
            return Cluster.getBase(dbName) + ".sync.attempt.count";
        }

        public static String syncFailures(String dbName) {
            return Cluster.getBase(dbName) + ".sync.failure.count";
        }

        public static String syncSuccess(String dbName) {
            return Cluster.getBase(dbName) + ".sync.success.count";
        }

        public static String fullSyncAttempts(String dbName) {
            return Cluster.getBase(dbName) + ".fullsync.attempts";
        }

        public static String fullSyncFailures(String dbName) {
            return Cluster.getBase(dbName) + ".fullsync.failures";
        }

        public static String fullSyncSuccess(String dbName) {
            return Cluster.getBase(dbName) + ".fullsync.success.count";
        }

        public static String syncsRunning(String dbName) {
            return Cluster.getBase(dbName) + ".sync.running";
        }

        public static String lastSuccessfulSync(String dbName) {
            return Cluster.getBase(dbName) + ".sync.lastSuccessful.timestamp";
        }

        public static String lastFailedSync(String dbName) {
            return Cluster.getBase(dbName) + ".sync.lastFailed.timestamp";
        }

        public static String lastSuccessfulFullSync(String dbName) {
            return Cluster.getBase(dbName) + ".fullsync.lastSuccessful.timestamp";
        }

        public static String lastFailedFullSync(String dbName) {
            return Cluster.getBase(dbName) + ".fullsync.lastFailed.timestamp";
        }
    }
}

