/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.metadata;

import com.complexible.stardog.metadata.MetaProperties;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.Metadata;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;

public final class PartitionedMetadata {
    public final Metadata mDatabaseOptions = Metadata.create();
    public final Metadata mIndexOptions = Metadata.create();
    public final List<MetaProperty<?>> mUnrecognizedOptions = Lists.newArrayList();
    public final List<MetaProperty<?>> mInvalidOptions = Lists.newArrayList();

    PartitionedMetadata(Metadata theOptions, Predicate<MetaProperty<?>> theFilter, boolean theMemory) {
        for (MetaProperty<Object> aStardogOption : theOptions) {
            if (!theFilter.test(aStardogOption)) {
                this.mInvalidOptions.add(aStardogOption);
                continue;
            }
            if (!MetaProperties.contains(aStardogOption)) {
                this.mUnrecognizedOptions.add(aStardogOption);
                continue;
            }
            Object aOptionVal = theOptions.get(aStardogOption);
            if (aStardogOption.isIndex()) {
                boolean aValidIndexOption;
                boolean bl = aValidIndexOption = theMemory ? aStardogOption.isMemoryIndex() : aStardogOption.isDiskIndex();
                if (!aValidIndexOption) {
                    this.mInvalidOptions.add(aStardogOption);
                    continue;
                }
                this.mIndexOptions.set(aStardogOption, aOptionVal);
            }
            if (!aStardogOption.isDatabase()) continue;
            this.mDatabaseOptions.set(aStardogOption, aOptionVal);
        }
    }
}

