/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.metadata;

import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ByteReaders;
import com.complexible.common.io.ByteWriter;
import com.complexible.common.io.ByteWriters;
import com.complexible.common.util.EnhancedProperties;
import com.complexible.stardog.metadata.ByteIO;
import com.complexible.stardog.metadata.CalculateByteWriter;
import com.complexible.stardog.metadata.GraphIO;
import com.complexible.stardog.metadata.MetaProperties;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.Metadata;
import com.complexible.stardog.metadata.TextIO;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Statements;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.vocabs.RDF;
import com.stardog.stark.vocabs.RDFS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataIO.class);
    private static final Set<IRI> IGNORED_BUILTINS = ImmutableSet.of((Object)RDF.TYPE, (Object)RDFS.LABEL);

    private MetadataIO() {
        throw new AssertionError();
    }

    public static void readProperties(Metadata theOptions, InputStream theStream) throws IOException {
        EnhancedProperties aProps = new EnhancedProperties(theStream);
        for (Object aKey : aProps.keySet()) {
            String aStrKey = aKey.toString();
            String aStrValue = aProps.getProperty(aStrKey);
            MetadataIO.read(theOptions, aStrKey, aStrValue);
        }
    }

    public static boolean read(Metadata theOptions, String aStrKey, String aStrValue) {
        MetaProperty aOption = MetaProperties.get(aStrKey);
        if (aOption == null) {
            LOGGER.warn("Option not recognized " + aStrKey);
            return false;
        }
        TextIO aTextIO = aOption.getTextIO();
        if (aTextIO == null) {
            LOGGER.warn("Reading option from configuration file not supported " + aStrKey);
            return false;
        }
        try {
            Object aValue = aTextIO.read(aStrValue);
            theOptions.set(aOption, aValue);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Invalid value for option: " + aStrKey + "=" + aStrValue);
            return false;
        }
    }

    public static void writeProperties(Metadata theOptions, OutputStream theStream) throws IOException {
        Properties aProps = new Properties();
        for (MetaProperty<Object> aStardogOption : theOptions) {
            Object aValue = theOptions.get(aStardogOption);
            String aStrValue = aStardogOption.getTextIO().write(aValue);
            aProps.setProperty(aStardogOption.getName(), aStrValue);
        }
        aProps.store(theStream, null);
    }

    public static Metadata readGraph(Set<Statement> theGraph, Resource theResource) {
        Metadata theOptions = Metadata.create();
        MetadataIO.readGraph(theOptions, theGraph, theResource);
        return theOptions;
    }

    public static void readGraph(Metadata theOptions, Set<Statement> theGraph, Resource theResource) {
        Iterator i = theGraph.stream().filter(Statements.matches((Resource)theResource, null, null, (Resource[])new Resource[0])).iterator();
        while (i.hasNext()) {
            Statement aStmt = (Statement)i.next();
            IRI aPredicate = aStmt.predicate();
            if (IGNORED_BUILTINS.contains(aPredicate)) continue;
            String aStrKey = aPredicate.localName();
            Value aRdfValue = aStmt.object();
            MetaProperty aOption = MetaProperties.get(aStrKey);
            if (aOption == null) {
                LOGGER.debug("Skipping unrecognized option " + aStrKey);
                continue;
            }
            GraphIO aTextIO = aOption.getGraphIO();
            if (aTextIO == null) {
                LOGGER.warn("Reading option from RDF not supported: " + aStrKey);
                continue;
            }
            try {
                Object aValue = aTextIO.read(aRdfValue, theGraph);
                theOptions.set(aOption, aValue);
            }
            catch (Exception e) {
                LOGGER.warn("Invalid value for option: " + aStrKey + "=" + String.valueOf(aRdfValue));
            }
        }
    }

    public static void writeGraph(Metadata theOptions, Set<Statement> theGraph, IRI theResource, Function<String, IRI> theVocabulary) {
        for (MetaProperty<Object> aStardogOption : theOptions) {
            if (aStardogOption.isTemporary()) continue;
            GraphIO<Object> aGraphIO = aStardogOption.getGraphIO();
            if (aGraphIO == null) {
                LOGGER.warn("Writing option to RDF not supported " + String.valueOf(aStardogOption));
                continue;
            }
            Object aOptValue = theOptions.get(aStardogOption);
            try {
                String aOptionName = aStardogOption.getName();
                Value aValue = aGraphIO.write(aOptValue, theGraph, theResource.toString() + "_" + aOptionName);
                theGraph.add(Values.statement((Resource)theResource, (IRI)theVocabulary.apply(aOptionName), (Value)aValue));
            }
            catch (Exception e) {
                LOGGER.warn("Cannot write value for option: " + String.valueOf(aStardogOption) + "=" + String.valueOf(aOptValue), (Throwable)e);
            }
        }
    }

    public static int sizeInBytes(Metadata theOptions) throws IOException {
        CalculateByteWriter aCalculateByteWriter = new CalculateByteWriter();
        for (MetaProperty<Object> aOption : theOptions) {
            Object aValue;
            if (aOption.isTemporary() || (aValue = theOptions.get(aOption)) == null) continue;
            ByteIO<Object> aByteIO = aOption.getByteIO();
            if (aByteIO == null) {
                LOGGER.warn("Using generic writer since no byte writer found for option " + String.valueOf(aOption));
                aByteIO = ByteIO.getGeneric();
            }
            aCalculateByteWriter.writeString(aOption.toString());
            aByteIO.write(aValue, aCalculateByteWriter);
        }
        return aCalculateByteWriter.bytesCount();
    }

    public static void write(Metadata theOptions, Path theFile) throws IOException {
        try (OutputStream aOutputStream = Files.newOutputStream(theFile, new OpenOption[0]);){
            MetadataIO.writeBytes(theOptions, ByteWriters.asByteWriter((OutputStream)aOutputStream));
        }
    }

    public static void writeBytes(Metadata theOptions, ByteWriter theByteWriter) throws IOException {
        for (MetaProperty<Object> aOption : theOptions) {
            Object aValue;
            if (aOption.isTemporary() || (aValue = theOptions.get(aOption)) == null) continue;
            ByteIO<Object> aByteIO = aOption.getByteIO();
            if (aByteIO == null) {
                LOGGER.warn("Using generic writer since no byte writer found for option " + String.valueOf(aOption));
                aByteIO = ByteIO.getGeneric();
            }
            theByteWriter.writeString(aOption.toString());
            aByteIO.write(aValue, theByteWriter);
        }
    }

    public static Metadata read(Path theFile) throws IOException {
        try (FileChannel aFileChannel = FileChannel.open(theFile, StandardOpenOption.READ);){
            Metadata metadata;
            block12: {
                InputStream aInputStream = Channels.newInputStream(aFileChannel);
                try {
                    metadata = MetadataIO.readBytes(ByteReaders.of((InputStream)aInputStream, (long)aFileChannel.size()));
                    if (aInputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (aInputStream != null) {
                        try {
                            aInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                aInputStream.close();
            }
            return metadata;
        }
    }

    public static Metadata readBytes(ByteReader aReader) throws IOException {
        Metadata aOptions = Metadata.create();
        MetadataIO.readBytes(aOptions, aReader);
        return aOptions;
    }

    public static void readBytes(Metadata aOptions, ByteReader aReader) throws IOException {
        while (!ByteReaders.isConsumed((ByteReader)aReader)) {
            ByteIO<Object> aByteIO;
            boolean aUnrecognized;
            String aOptionName = aReader.readString();
            MetaProperty aOption = MetaProperties.get(aOptionName);
            boolean bl = aUnrecognized = aOption == null;
            if (aUnrecognized) {
                LOGGER.warn("Unrecognized option in the metadata: " + aOptionName);
                aOption = MetaProperty.config(aOptionName, Object.class).temporary().build();
            }
            if ((aByteIO = aOption.getByteIO()) == null) {
                LOGGER.warn("Using generic reader since no byte reader found for option " + String.valueOf(aOption));
                aByteIO = ByteIO.getGeneric();
            }
            try {
                Object aVal = aByteIO.read(aReader);
                aOptions.set(aOption, aVal);
            }
            catch (Exception e) {
                LOGGER.warn("Ignoring option " + aOptionName + "due to error : " + e.getMessage());
            }
        }
    }

    public static void writeTable(Metadata theOptions, OutputStream theStream) {
        String[] aCols = new String[]{"Option", "Value"};
        MetadataIO.writeTable(theOptions, theStream, MetaProperties.NAME_ORDERING, aCols);
    }

    public static void writeTable(Metadata theOptions, OutputStream theStream, Ordering<MetaProperty<?>> theOrdering, String[] theColumnNames) {
        TextTabularOutput aOutput = new TextTabularOutput(theStream, theColumnNames);
        Metadata aSortedOptions = theOrdering == null ? theOptions : theOrdering.sortedCopy((Iterable)theOptions);
        for (MetaProperty aOption : aSortedOptions) {
            Object aValue = theOptions.get(aOption);
            TextIO aTextIO = aOption.getTextIO();
            if (aTextIO == null) continue;
            String aStrValue = aTextIO.write(aValue);
            aStrValue = aStrValue.replace('\u0002', ',');
            aStrValue = aStrValue.replace(",", ", ");
            aOutput.addRow(new Object[]{aOption.getName(), aStrValue});
        }
        aOutput.output();
    }
}

