/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.metadata;

import com.complexible.common.base.Copyable;
import com.complexible.common.base.Option;
import com.complexible.common.base.OptionFunction;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.MetadataLookup;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public final class Metadata
implements MetadataLookup,
Copyable<Metadata>,
Iterable<MetaProperty<Object>> {
    private static final Metadata EMPTY = new Metadata(Collections.emptyMap());
    private final Map<MetaProperty<Object>, Object> mMap;

    private Metadata() {
        this(Maps.newConcurrentMap());
    }

    private Metadata(Map<MetaProperty<Object>, Object> theMap) {
        this.mMap = theMap;
    }

    @Override
    @Nonnull
    public Iterator<MetaProperty<Object>> iterator() {
        return this.mMap.keySet().iterator();
    }

    public Metadata copy() {
        ConcurrentMap aMap = Maps.newConcurrentMap();
        aMap.putAll(this.mMap);
        return new Metadata(aMap);
    }

    public Metadata immutable() {
        return new Metadata(Collections.unmodifiableMap(this.mMap));
    }

    public static Metadata empty() {
        return EMPTY;
    }

    public static <V> Metadata of(MetaProperty<V> key, V value) {
        return new Metadata(Collections.singletonMap(key, value));
    }

    public static Metadata create() {
        return new Metadata();
    }

    public <V> boolean contains(MetaProperty<V> option) {
        return this.mMap.containsKey(option);
    }

    @Override
    public <V> V get(MetaProperty<V> option) {
        return this.get(option, null);
    }

    public <V> V get(MetaProperty<V> option, OptionFunction theDefaultValues) {
        Object value = this.mMap.get(option);
        if (value == null) {
            if (theDefaultValues != null) {
                value = theDefaultValues.get(Option.create((String)option.getName()));
            }
            if (value == null) {
                value = option.getDefaultValue();
            }
        }
        return (V)value;
    }

    public <V> Metadata set(MetaProperty<V> option, V value) {
        Preconditions.checkNotNull(option);
        if (value == null) {
            this.mMap.remove(option);
        } else {
            this.mMap.put(option, value);
        }
        return this;
    }

    public <V> Metadata setAll(Metadata theOtherMap) {
        this.mMap.putAll(theOtherMap.mMap);
        return this;
    }

    public <V> V remove(MetaProperty<V> option) {
        Object oldValue = this.mMap.remove(option);
        return (V)(oldValue != null ? oldValue : option.getDefaultValue());
    }

    public void clear() {
        this.mMap.clear();
    }

    public int size() {
        return this.mMap.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata aStardogOptions = (Metadata)o;
        return Objects.equal(this.mMap, aStardogOptions.mMap);
    }

    public int hashCode() {
        return this.mMap != null ? this.mMap.hashCode() : 0;
    }

    public String toString() {
        return this.mMap.toString();
    }
}

