/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.index;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.google.common.collect.Sets;
import java.util.Set;

public enum IndexOrder {
    SPO(Field.C, Field.S, Field.P, Field.O),
    SOP(Field.C, Field.S, Field.O, Field.P),
    PSO(Field.C, Field.P, Field.S, Field.O),
    POS(Field.C, Field.P, Field.O, Field.S),
    OSP(Field.C, Field.O, Field.S, Field.P),
    OPS(Field.C, Field.O, Field.P, Field.S),
    SP(Field.C, Field.S, Field.P),
    SO(Field.C, Field.S, Field.O),
    PS(Field.C, Field.P, Field.S),
    PO(Field.C, Field.P, Field.O),
    OS(Field.C, Field.O, Field.S),
    OP(Field.C, Field.O, Field.P),
    S(Field.C, Field.S),
    P(Field.C, Field.P),
    O(Field.C, Field.O),
    SPOC(Field.S, Field.P, Field.O, Field.C),
    SOPC(Field.S, Field.O, Field.P, Field.C),
    PSOC(Field.P, Field.S, Field.O, Field.C),
    POSC(Field.P, Field.O, Field.S, Field.C),
    OSPC(Field.O, Field.S, Field.P, Field.C),
    OPSC(Field.O, Field.P, Field.S, Field.C),
    SPC(Field.S, Field.P, Field.C),
    SOC(Field.S, Field.O, Field.C),
    PSC(Field.P, Field.S, Field.C),
    POC(Field.P, Field.O, Field.C),
    OSC(Field.O, Field.S, Field.C),
    OPC(Field.O, Field.P, Field.C),
    SC(Field.S, Field.C),
    PC(Field.P, Field.C),
    OC(Field.O, Field.C),
    C(Field.C),
    SP_NOC(false, Field.S, Field.P),
    SO_NOC(false, Field.S, Field.O),
    PS_NOC(false, Field.P, Field.S),
    PO_NOC(false, Field.P, Field.O),
    OS_NOC(false, Field.O, Field.S),
    OP_NOC(false, Field.O, Field.P),
    S_NOC(false, Field.S),
    P_NOC(false, Field.P),
    O_NOC(false, Field.O);

    private static IntObjectMap<IndexOrder> ENCODED_ORDERS;
    private final Field[] mFields;
    private final boolean mHasContext;

    private static int encodeFields(Field[] theFields) {
        int aCode = 0;
        for (Field aField : theFields) {
            aCode = aCode << 2 | aField.ordinal();
        }
        aCode = aCode << 2 | theFields.length;
        return aCode;
    }

    public static IndexOrder getOrder(Field[] theFields) {
        return (IndexOrder)((Object)ENCODED_ORDERS.get(IndexOrder.encodeFields(theFields)));
    }

    private IndexOrder(Field ... theFields) {
        this(true, theFields);
    }

    private IndexOrder(boolean theHasContext, Field ... theFields) {
        this.mHasContext = theHasContext;
        this.mFields = theFields;
    }

    public Field[] getFields() {
        return this.mFields;
    }

    public Set<Field> getFieldSet() {
        return Sets.newHashSet((Object[])this.mFields);
    }

    public boolean isContextFirst() {
        return this.mFields[0] == Field.C;
    }

    public boolean isContextLast() {
        return this.mHasContext && this.mFields[0] != Field.C;
    }

    public boolean isTernary() {
        return this.mHasContext && this.mFields.length == 4 || !this.mHasContext && this.mFields.length == 3;
    }

    public boolean isBinary() {
        return this.mHasContext && this.mFields.length == 3 || !this.mHasContext && this.mFields.length == 2;
    }

    public boolean isUnary() {
        return this.mHasContext && this.mFields.length == 2 || !this.mHasContext && this.mFields.length == 1;
    }

    public boolean isContext() {
        return this == C;
    }

    public boolean hasContext() {
        return this.mHasContext;
    }

    public int getArity() {
        return this.mHasContext ? this.mFields.length - 1 : this.mFields.length;
    }

    public IndexOrder flipContext() {
        if (!this.mHasContext) {
            return this;
        }
        switch (this.ordinal()) {
            case 0: {
                return SPOC;
            }
            case 15: {
                return SPO;
            }
            case 1: {
                return SOPC;
            }
            case 16: {
                return SOP;
            }
            case 3: {
                return POSC;
            }
            case 18: {
                return POS;
            }
            case 2: {
                return PSOC;
            }
            case 17: {
                return PSO;
            }
            case 5: {
                return OPSC;
            }
            case 20: {
                return OPS;
            }
            case 4: {
                return OSPC;
            }
            case 19: {
                return OSP;
            }
            case 6: {
                return SPC;
            }
            case 21: {
                return SP;
            }
            case 9: {
                return POC;
            }
            case 24: {
                return PO;
            }
            case 10: {
                return OSC;
            }
            case 25: {
                return OS;
            }
            case 8: {
                return PSC;
            }
            case 11: {
                return OPC;
            }
            case 7: {
                return SOC;
            }
            case 23: {
                return PS;
            }
            case 26: {
                return OP;
            }
            case 22: {
                return SO;
            }
            case 12: {
                return SC;
            }
            case 13: {
                return PC;
            }
            case 14: {
                return OC;
            }
            case 27: {
                return S;
            }
            case 28: {
                return P;
            }
            case 29: {
                return O;
            }
            case 30: {
                return C;
            }
        }
        throw new AssertionError();
    }

    public IndexOrder flipBinary() throws IllegalArgumentException {
        if (!this.mHasContext) {
            return this;
        }
        switch (this.ordinal()) {
            case 6: {
                return PS;
            }
            case 8: {
                return SP;
            }
            case 9: {
                return OP;
            }
            case 11: {
                return PO;
            }
            case 10: {
                return SO;
            }
            case 7: {
                return OS;
            }
            case 21: {
                return PSC;
            }
            case 23: {
                return SPC;
            }
            case 24: {
                return OPC;
            }
            case 26: {
                return POC;
            }
            case 25: {
                return SOC;
            }
            case 22: {
                return OSC;
            }
        }
        throw new IllegalArgumentException("Not a binary order" + String.valueOf((Object)this));
    }

    static {
        ENCODED_ORDERS = new IntObjectHashMap();
        for (IndexOrder aOrder : IndexOrder.values()) {
            ENCODED_ORDERS.put(IndexOrder.encodeFields(aOrder.getFields()), (Object)aOrder);
        }
    }

    public static enum Field {
        S,
        P,
        O,
        C;

    }
}

