/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.index;

import com.complexible.common.base.SystemUtil;
import com.complexible.common.rdf.rio.ProcessorContext;
import com.complexible.stardog.index.AggregateIndexes;
import com.complexible.stardog.index.IndexStrategy;
import com.complexible.stardog.index.StatisticsStrategy;
import com.complexible.stardog.metadata.ConfigProperty;
import com.complexible.stardog.metadata.InfoProperty;
import com.complexible.stardog.metadata.MetaProperties;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.MetaPropertyProvider;
import com.complexible.stardog.metadata.Metadata;
import com.complexible.stardog.metadata.OptionsCategory;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.PrintStream;
import java.util.Optional;
import java.util.UUID;

@Singleton
public final class IndexOptions
implements MetaPropertyProvider {
    private static final String OPTION_SIZE = "index.size";
    private static final String OPTION_PERSIST = "index.persist";
    private static final String OPTION_SYNC = "index.persist.sync";
    private static final String OPTION_INDEX_TYPE = "index.type";
    private static final String OPTION_DIFF_SIZE = "index.differential.size";
    private static final String OPTION_INLINED = "index.literals.canonical";
    private static final String OPTION_BOOLEANS_INLINED = "index.booleans.canonical";
    private static final String OPTION_INLINING_VERSION = "index.literal.canonicalization.version";
    private static final String OPTION_INDEX_STRATEGY = "index.strategy";
    private static final String OPTION_INDEX_AGG = "index.aggregate";
    private static final String OPTION_DIFF_INDEX_MIN = "index.differential.enable.limit";
    private static final String OPTION_DIFF_INDEX_MAX = "index.differential.merge.limit";
    private static final String OPTION_BULK_LOADER_NAMED_GRAPHS = "index.bulkloader.named.graphs";
    private static final String OPTION_BULK_LOADER_ESTIMATED_SIZE = "index.bulkloader.estimated.size";
    private static final String OPTION_BULK_LOADER_OVERWRITE_DATA = "index.bulkloader.overwrite";
    private static final String OPTION_STATS_UPDATE_COUNT = "index.statistics.update.count";
    private static final String OPTION_STATS_UPDATE_MIN_SIZE = "index.statistics.update.min.size";
    private static final String OPTION_STATS_UPDATE_AUTO = "index.statistics.update.automatic";
    private static final String OPTION_STATS_UPDATE_RATIO = "index.statistics.update.ratio";
    private static final String OPTION_STATS_UPDATE_BLOCKING_RATIO = "index.statistics.update.blocking.ratio";
    private static final String OPTION_STORAGE_COMPRESSION = "index.compression";
    private static final String OPTION_WRITE_CONFLICT_STRATEGY = "transaction.write.conflict.strategy";
    private static final String OPTION_OPTIMIZE_VACUUM_DATA = "optimize.vacuum.data";
    private static final String OPTION_OPTIMIZE_VACUUM_DICTIONARY = "optimize.vacuum.dictionary";
    private static final String OPTION_DICTIONARY_VACUUMING_MULTITHREADED = "optimize.vacuum.dictionary.is_multithreaded";
    private static final String OPTION_OPTIMIZE_STATISTICS = "optimize.statistics";
    private static final String OPTION_OPTIMIZE_COMPACT = "optimize.compact";
    private static final String OPTION_OPTIMIZE_LITERAL_INDEX = "optimize.index.numbers";
    private static final String OPTION_OPTIMIZE_DISK_SPACE_FORCE = "optimize.disk.space.force";
    private static final String OPTION_OPTIMIZE_THROTTLE_OVERRIDE = "optimize.throttle.override";
    private static final String OPTION_STORAGE_WAL_ENABLED = "index.wal.enabled";
    private static final String OPTION_BULK_LOAD_SST_CHUNK = "index.bulk.load.sst.chunk";
    private static final String OPTION_BULK_LOAD_VALUE_SIZE_THRESHOLD = "index.bulk.load.value.size.threshold";
    private static final String OPTION_TX_BULK_LOAD_HARD_THRESHOLD = "index.bulk.load.tx.threshold";
    private static final String OPTION_TX_SST_WRITE_LIMIT = "index.bulk.load.sst.txlimit";
    private static final String OPTION_BULK_LOAD_MAX_PARSERS = "index.bulk.load.max.parsers";
    private static final String OPTION_BULK_LOAD_MAX_HANDLERS = "index.bulk.load.max.handlers";
    private static final String OPTION_BULK_LOAD_RESIZE_HANDLERS = "index.bulk.load.resize.handlers";
    private static final String OPTION_STATS_CHARACTERISTIC_SETS_LIMIT = "index.statistics.characteristic.limit";
    private static final String OPTION_STATS_CACHE_CAPACITY = "index.statistics.cache.capacity";
    private static final String OPTION_STATISTICS_CHAINS = "index.statistics.chains.enabled";
    private static final String OPTION_STATS_RANGE_SAMPLE_SIZE = "index.statistics.range.sample.size";
    private static final String OPTION_STATISTICS_OBJECT_JOIN_ENABLED = "index.statistics.object_joins.enabled";
    private static final String OPTION_STATS_ENABLE_ACTIVE_GRAPH = "index.statistics.enable_active_graph";
    private static final String OPTION_STATISTICS_ON_DB_CREATION = "index.statistics.on_db_create";
    public static final InfoProperty<Long> SIZE = MetaProperty.info("index.size", 0L).index().readable().build();
    public static final Long BULK_LOAD_DICTIONARY_RESERVED_MEM = 0x10000000L;
    public static final ConfigProperty<Long> BULK_LOAD_DICTIONARY_MEM = MetaProperty.config("dictionary.bulk.load", 0L).temporary().creatable().index().build();
    public static final ConfigProperty<Boolean> PERSIST = MetaProperty.config("index.persist", false).index().database().readable().writable().creatable().build();
    @Deprecated
    public static final ConfigProperty<Boolean> SYNC = MetaProperty.config("index.persist.sync", true).memoryIndex().readable().writable().creatable().build();
    public static final ConfigProperty<IndexType> INDEX_TYPE = MetaProperty.config("index.type", IndexType.Disk).index().readable().creatable().build();
    public static final ConfigProperty<Boolean> CANONICAL_LITERALS = MetaProperty.config("index.literals.canonical", true).index().readable().creatable().category(OptionsCategory.INDEX).label("Literal Canonicalization").description("Specify that non-string typed literals are canonicalized in the database. Improves query and loading performance, but does change literal values to a canonical form. For example, \"1\"^^xsd:byte is canonicalized to \"1\"^^xsd:integer. Set this option to false if you require literals to be exactly as specified, rather than canonicalized. The default value is 'true'. note that, this value can only be set at database creation time and cannot be changed at a future time.").build();
    public static final ConfigProperty<Boolean> INLINE_BOOLEANS = MetaProperty.config("index.booleans.canonical", true).index().readable().build();
    public static final ConfigProperty<Integer> INLINING_VERSION = MetaProperty.config("index.literal.canonicalization.version", 2).index().readable().build();
    @Deprecated(since="11.0")
    public static final ConfigProperty<AggregateIndexes> INDEXES_AGGREGATE = MetaProperty.config("index.aggregate", AggregateIndexes.Off).database().readable().creatable().build();
    public static final InfoProperty<IndexStrategy> INDEX_STRATEGY = MetaProperty.info("index.strategy", IndexStrategy.NO_AGGREGATE_INDEXES).index().readable().build();
    public static final InfoProperty<Integer> DIFF_INDEX_SIZE = MetaProperty.info("index.differential.size", 0).index().readable().build();
    public static final ConfigProperty<Integer> DIFF_INDEX_MIN_LIMIT = MetaProperty.config("index.differential.enable.limit", 500000).index().readable().creatable().writable().category(OptionsCategory.INDEX).label("Differential Index Minimum").description("NOTE: Not used in Stardog v7+. The minimum number of statements in the Stardog database before differential indexes are used.").build();
    public static final ConfigProperty<Integer> DIFF_INDEX_MAX_LIMIT = MetaProperty.config("index.differential.merge.limit", 20000).index().readable().creatable().writable().category(OptionsCategory.INDEX).label("Differential Merge Maximum").description("NOTE: Not used in Stardog v7+. The size in number of RDF statements before the differential indexes are merged to the main indexes.").build();
    public static final InfoProperty<PrintStream> PROGRESS_OUTPUT = MetaProperty.info("progress.output", PrintStream.class).index().temporary().build();
    public static final InfoProperty<Boolean> BULK_LOADER_NAMED_GRAPHS = MetaProperty.info("index.bulkloader.named.graphs", true).temporary().build();
    public static final InfoProperty<Long> BULK_LOADER_ESTIMATED_SIZE = MetaProperty.info("index.bulkloader.estimated.size", 1024L).temporary().build();
    public static final ConfigProperty<Integer> BULK_LOAD_MAX_PARSERS = MetaProperty.config("index.bulk.load.max.parsers", ProcessorContext.DEFAULT_MAX_PARSER_COUNT).temporary().index().creatable().build();
    public static final ConfigProperty<Integer> BULK_LOAD_MAX_HANDLERS = MetaProperty.config("index.bulk.load.max.handlers", ProcessorContext.DEFAULT_MAX_HANDLER_COUNT).temporary().index().creatable().build();
    public static final ConfigProperty<Boolean> BULK_LOAD_RESIZE_HANDLERS = MetaProperty.config("index.bulk.load.resize.handlers", true).temporary().index().creatable().build();
    public static final ConfigProperty<Boolean> BULK_LOADER_OVERWRITE_DATA = MetaProperty.config("index.bulkloader.overwrite", true).diskIndex().temporary().build();
    public static final InfoProperty<Long> STATS_UPDATE_COUNT = MetaProperty.info("index.statistics.update.count", 0L).index().readable().build();
    public static final ConfigProperty<Long> STATS_UPDATE_DB_MIN_SIZE = MetaProperty.config("index.statistics.update.min.size", 10000L).index().readable().creatable().writableWhileOnline().category(OptionsCategory.INDEX).label("Minimum Statistics Update Size").description("Minimum number of triples that should be in the database for statistics to be updated automatically").build();
    @Deprecated
    public static final InfoProperty<Long> DEPRECATED_STATS_UPDATE_DB_MIN_SIZE = MetaProperty.info("index.statistics.update.dbminsize", 10000L).temporary().build();
    public static final ConfigProperty<StatisticsStrategy> STATISTICS_ON_DB_CREATION = MetaProperty.config("index.statistics.on_db_create", StatisticsStrategy.Sync).index().readable().creatable().category(OptionsCategory.INDEX).label("Statistics behavior upon database creation").description("Determines whether and how selectivity statistics is computed when a database is bulk loaded. By default it's computed synchronously.").build();
    public static final ConfigProperty<Boolean> AUTO_STATS_UPDATE = MetaProperty.config("index.statistics.update.automatic", true).index().readable().creatable().writableWhileOnline().category(OptionsCategory.INDEX).label("Automatic Statistics Update").description("Determines whether statistics are maintained automatically. When set to \"true\", Stardog will decide when to update statistics as the database is modified through additions and removals and update statistics as needed. If this option is set to \"false\", Stardog will never update the statistics regardless of how much the database is updated.").build();
    public static final ConfigProperty<CompressionType> COMPRESSION = MetaProperty.config("index.compression", CompressionType.LZ4).index().readable().creatable().build();
    public static final ConfigProperty<WriteConflictStrategy> WRITE_CONFLICT_STRATEGY = MetaProperty.config("transaction.write.conflict.strategy", WriteConflictStrategy.LAST_COMMIT_WINS).index().readable().creatable().category(OptionsCategory.TRANSACTION).label("Write Conflict Strategy").description("Which conflict resolution strategy to use for this database. Write conflicts occur when two transactions attempt to modify the same statement inthe database simultaneously.").build();
    public static final ConfigProperty<Boolean> WAL_ENABLED = MetaProperty.config("index.wal.enabled", true).index().readable().creatable().build();
    public static final ConfigProperty<Long> BULK_LOAD_SST_CHUNK_SIZE = MetaProperty.config("index.bulk.load.sst.chunk", 1000000000L).index().readable().creatable().build();
    public static final ConfigProperty<Long> BULK_LOAD_VALUE_SIZE_THRESHOLD = MetaProperty.config("index.bulk.load.value.size.threshold", 500000000L).index().readable().creatable().build();
    public static final ConfigProperty<Long> TX_BULK_LOAD_HARD_THRESHOLD = MetaProperty.config("index.bulk.load.tx.threshold", 4000000L).index().readable().creatable().writableWhileOnline().category(OptionsCategory.INDEX).label("Transaction bulk loading threshold").description("Threshold of actual number of quads, where Stardog use bulk loading. Max effective value is 8388608.").build();
    public static final ConfigProperty<Long> TX_BULK_LOAD_ADAPTIVE_THRESHOLD = MetaProperty.config("index.bulk.load.sst.txlimit", 495000L).index().readable().creatable().writableWhileOnline().category(OptionsCategory.INDEX).label("Transaction bulk loading, soft threshold").description("Threshold estimated input size at which the bulk loading mechanism will be considered for transactional updates.").build();
    public static final ConfigProperty<Boolean> IS_DICTIONARY_VACUUMING_MULTITHREADED = MetaProperty.config("optimize.vacuum.dictionary.is_multithreaded", false).index().readable().creatable().build();
    public static final ConfigProperty<Double> STATS_UPDATE_RATIO = MetaProperty.config("index.statistics.update.ratio", 0.1).index().readable().creatable().writableWhileOnline().category(OptionsCategory.INDEX).label("Statistics Update Ratio").description("Ratio of updated triples to the number of triples in the database that triggers the automatic statistics computation in a background thread").build();
    public static final ConfigProperty<Double> STATS_UPDATE_BLOCKING_RATIO = MetaProperty.config("index.statistics.update.blocking.ratio", 0.0).index().readable().creatable().writableWhileOnline().category(OptionsCategory.INDEX).label("Statistics Update Blocking Ratio").description("Once the ratio of updated triples to database size goes over this limit statistics computation will be performed synchronously within the transaction instead of a background thread. Setting this option to a non-positive number (<= 0) will disable blocking updates.").build();
    public static final ConfigProperty<Integer> CARDINALITY_CACHE_CAPACITY = MetaProperty.config("index.statistics.cache.capacity", 1024).index().readable().creatable().writable().category(OptionsCategory.INDEX).label("Cache Capacity").description("The max capacity for the query pattern cardinality cache that is shared across queries to the same database.").build();
    public static final ConfigProperty<Integer> STATISTICS_CHARACTERISTIC_SETS_LIMIT = MetaProperty.config("index.statistics.characteristic.limit", 10000).index().readable().creatable().writableWhileOnline().category(OptionsCategory.INDEX).label("Statistics Characteristic Sets Limit").description("The max number of characteristic sets computed as a part of the statistical summary of the database. More diverse datasets may require a higher number for more accurate query planning. The downside is higher memory footprint and slower planning").build();
    public static final ConfigProperty<Integer> STATISTICS_RANGE_SAMPLE_SIZE = MetaProperty.config("index.statistics.range.sample.size", 100).index().readable().creatable().writableWhileOnline().category(OptionsCategory.INDEX).label("Statistics Range Sample Size").description("The number of elements from the range of a property that are examined to classify the property as an object or data property. Used for query optimization.").build();
    public static final ConfigProperty<Boolean> STATISTICS_CHAINS_ENABLED = MetaProperty.config("index.statistics.chains.enabled", true).index().readable().creatable().writableWhileOnline().category(OptionsCategory.INDEX).label("Enable chain statistics").description("If true, Stardog will pre-compute the number of times frequent binary chains occur in the data and will use that information for query optimization.Could be disabled for very large or very complex datasets. Changes to this option will take effect the next time statistics is recomputed.").build();
    public static final ConfigProperty<Boolean> STATISTICS_OBJECT_JOIN_ENABLED = MetaProperty.config("index.statistics.object_joins.enabled", true).index().readable().creatable().writableWhileOnline().category(OptionsCategory.INDEX).label("Enable object join cardinality statistics").description("If true, Stardog will pre-compute the object join cardinalities for pairs of properties in the dataset. This information is used for query optimization.Could be disabled for very large or very complex datasets. Changes to this option will take effect the next time statistics is recomputed.").build();
    public static final ConfigProperty<Boolean> STATS_ENABLE_ACTIVE_GRAPH = MetaProperty.config("index.statistics.enable_active_graph", true).index().readable().creatable().writable().category(OptionsCategory.INDEX).label("Enable active graph statistics for cardinality estimations").description("If true, Stardog will adjust the cardinality estimation for a query with based on the size of the active graph. Could be disabled for databases with few large named graphs with non-overlapping data.").build();
    public static final ConfigProperty<Integer> INDEX_WRITER_MERGE_LIMIT = MetaProperty.config("index.writer.merge.limit", 1000).index().readable().creatable().writable().category(OptionsCategory.INDEX).label("Writer Merge Limit").description("Maximum number of triples to keep in memory for merging interleaving additions and removals while querying uncommitted state").build();
    public static final ConfigProperty<Integer> STATISTICS_SKETCH_CAPACITY = MetaProperty.config("index.statistics.sketch.capacity", 100000000).index().readable().creatable().writableWhileOnline().category(OptionsCategory.INDEX).label("Cardinality sketch capacity").description("The max number of objects that can be added to a sketch data structure before a new sketch is created").build();
    public static final ConfigProperty<Double> STATISTICS_RARE_PREDICATE = MetaProperty.config("index.statistics.predicate.threshold", 0.001).index().readable().creatable().writableWhileOnline().category(OptionsCategory.INDEX).label("Rare predicate threshold for statistics").description("If a certain predicate occurs in less than this share of all triples in the data, Stardog will not maintain extended statistics for that predicate.").build();
    public static final ConfigProperty<UUID> LAST_COMMITTED_TX = MetaProperty.config("index.last.tx", UUID.class).index().nonsecure().creatable().readable().writable().writableWhileOnline().build();
    public static final ConfigProperty<String> BNODE_PREFIX_ID = MetaProperty.config("bnode.prefix.id", String.class).temporary().build();
    public static final ConfigProperty<Boolean> OPTIMIZE_VACUUM_DATA = MetaProperty.config("optimize.vacuum.data", true).index().readable().creatable().writableWhileOnline().build();
    public static final ConfigProperty<Boolean> OPTIMIZE_VACUUM_DICTIONARY = MetaProperty.config("optimize.vacuum.dictionary", false).index().readable().creatable().writableWhileOnline().build();
    public static final ConfigProperty<Boolean> OPTIMIZE_STATISTICS = MetaProperty.config("optimize.statistics", true).index().readable().creatable().writableWhileOnline().build();
    public static final ConfigProperty<Boolean> OPTIMIZE_COMPACT = MetaProperty.config("optimize.compact", true).index().readable().creatable().writableWhileOnline().build();
    public static final ConfigProperty<Boolean> OPTIMIZE_LITERAL_INDEX = MetaProperty.config("optimize.index.numbers", true).index().readable().creatable().writableWhileOnline().build();
    public static final ConfigProperty<Boolean> OPTIMIZE_DISK_SPACE_FORCE = MetaProperty.config("optimize.disk.space.force", false).temporary().build();
    public static final ConfigProperty<Boolean> OPTIMIZE_THROTTLE_OVERRIDE = MetaProperty.config("optimize.throttle.override", false).temporary().build();
    private static final String PROPERTY_FILE_FLUSH_ASYNC = "file.flush.async";
    public static final boolean ASYNC_FLUSH = SystemUtil.getPropertyAsBoolean((String)"file.flush.async", (boolean)true);

    @Inject
    IndexOptions() {
    }

    public static boolean isMemory(Metadata theOptions) {
        return theOptions.get(INDEX_TYPE) == IndexType.Memory;
    }

    public static boolean isDisk(Metadata theOptions) {
        return theOptions.get(INDEX_TYPE) == IndexType.Disk;
    }

    public static Metadata memory() {
        return MetaProperties.defaults(MetaProperties.memoryProperties()).set(INDEX_TYPE, IndexType.Memory);
    }

    public static Metadata disk() {
        return MetaProperties.defaults(MetaProperties.diskProperties()).set(INDEX_TYPE, IndexType.Disk);
    }

    public static boolean isPersist(Metadata theOptions) {
        return theOptions.is(PERSIST);
    }

    public static Optional<PrintStream> progressOutput(Metadata theOptions) {
        return Optional.ofNullable(theOptions.get(PROGRESS_OUTPUT));
    }

    public static enum IndexType {
        Memory,
        Disk;

    }

    public static enum CompressionType {
        NONE(0),
        SNAPPY(1),
        LZ4(4);

        final byte value;

        private CompressionType(byte theValue) {
            this.value = theValue;
        }

        public byte value() {
            return this.value;
        }
    }

    public static enum WriteConflictStrategy {
        LAST_COMMIT_WINS(false),
        ABORT_ON_CONFLICT(true);

        private final boolean forceWriteConflictChecking;

        private WriteConflictStrategy(boolean theForceWriteConflictChecking) {
            this.forceWriteConflictChecking = theForceWriteConflictChecking;
        }

        public boolean forcesWriteConflictChecking() {
            return this.forceWriteConflictChecking;
        }
    }
}

