/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv.shacl;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.CloseableIterator;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.icv.shacl.PropertyPaths;
import com.complexible.stardog.icv.shacl.SHACL;
import com.complexible.stardog.icv.shacl.ValidationResult;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.vocabs.RDF;

public class ValidationResultReader
extends CloseableIterator.AbstractCloseableIterator<ValidationResult> {
    private final CloseableIterator<Statement> statements;
    private final ValidationResult.Builder builder = ValidationResult.builder();

    public ValidationResultReader(CloseableIterator<Statement> theStatements) {
        this.statements = theStatements;
        try {
            Statement stmt = (Statement)Iterators.getNext(this.statements, null);
            if (stmt == null || !stmt.predicate().equals((Object)RDF.TYPE) || !stmt.object().equals((Object)SHACL.ValidationReport)) {
                throw new StardogException("Validation report is missing rdf:type sh:ValidationReport triple");
            }
            stmt = (Statement)Iterators.getNext(this.statements, null);
            if (stmt == null || !stmt.predicate().equals((Object)SHACL.conforms)) {
                throw new StardogException("Validation report is missing sh:conforms triple: " + String.valueOf(stmt));
            }
        }
        catch (Throwable t) {
            AutoCloser.close(t::addSuppressed, (AutoCloseable[])new AutoCloseable[]{this.statements});
            throw t;
        }
    }

    public void close() throws RuntimeException {
        this.statements.close();
    }

    protected ValidationResult computeNext() {
        if (!this.statements.hasNext()) {
            return (ValidationResult)this.endOfData();
        }
        Statement stmt = (Statement)this.statements.next();
        if (stmt.predicate().equals((Object)SHACL.result)) {
            if (!this.statements.hasNext()) {
                return (ValidationResult)this.endOfData();
            }
            stmt = (Statement)this.statements.next();
        }
        if (!stmt.predicate().equals((Object)RDF.TYPE) || !stmt.object().equals((Object)SHACL.ValidationResult)) {
            throw new StardogException("Validation result is missing rdf:type sh:ValidationResult triple");
        }
        this.builder.reset();
        Resource result = stmt.subject();
        while (this.statements.hasNext()) {
            stmt = (Statement)this.statements.next();
            Resource subj = stmt.subject();
            IRI pred = stmt.predicate();
            Value obj = stmt.object();
            if (pred.equals((Object)SHACL.result)) {
                return this.builder.build();
            }
            Preconditions.checkState((boolean)subj.equals((Object)result), (String)"Expecting subject %s but got: %s", (Object)result, (Object)stmt);
            if (pred.equals((Object)SHACL.focusNode)) {
                this.builder.focusNode(obj);
                continue;
            }
            if (pred.equals((Object)SHACL.value)) {
                this.builder.valueNode(obj);
                continue;
            }
            if (pred.equals((Object)SHACL.resultPath)) {
                this.builder.path(PropertyPaths.readPath(this.statements, obj));
                continue;
            }
            if (pred.equals((Object)SHACL.sourceShape)) {
                this.builder.shape((Resource)obj);
                continue;
            }
            if (pred.equals((Object)SHACL.sourceConstraint)) {
                this.builder.constraint((Resource)obj);
                continue;
            }
            if (pred.equals((Object)SHACL.sourceConstraintComponent)) {
                this.builder.component((IRI)obj);
                continue;
            }
            if (pred.equals((Object)SHACL.resultMessage)) {
                this.builder.message((Literal)obj);
                continue;
            }
            if (pred.equals((Object)SHACL.resultSeverity)) {
                this.builder.severity((IRI)obj);
                continue;
            }
            throw new IllegalStateException("Unexpected triple: " + String.valueOf(stmt));
        }
        return this.builder.build();
    }
}

