/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv.shacl;

import com.complexible.stardog.icv.shacl.ConstraintComponents;
import com.complexible.stardog.icv.shacl.PropertyShape;
import com.complexible.stardog.icv.shacl.Targets;
import com.google.common.collect.Lists;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class Shape {
    private final Resource resource;
    private final List<ConstraintComponents.ConstraintComponent> constraints = Lists.newArrayList();
    private final List<PropertyShape> properties = Lists.newArrayList();
    private final List<Targets.Target> targets = Lists.newArrayList();
    private IRI severity;
    private boolean isDeactivated = false;
    private Literal message;

    protected Shape(Resource theResource) {
        this.resource = theResource;
    }

    public abstract IRI getType();

    public Resource getResource() {
        return this.resource;
    }

    public List<ConstraintComponents.ConstraintComponent> getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    public void addConstraint(ConstraintComponents.ConstraintComponent theConstraintComponent) {
        this.constraints.add(theConstraintComponent);
    }

    public List<PropertyShape> getPropertyShapes() {
        return Collections.unmodifiableList(this.properties);
    }

    public void addPropertyShape(PropertyShape thePropertyShape) {
        this.properties.add(thePropertyShape);
    }

    public List<Targets.Target> getTargets() {
        return Collections.unmodifiableList(this.targets);
    }

    public void addTarget(Targets.Target theTarget) {
        this.targets.add(theTarget);
    }

    public IRI getSeverity() {
        return this.severity;
    }

    public void setSeverity(IRI theSeverity) {
        this.severity = theSeverity;
    }

    public boolean isDeactivated() {
        return this.isDeactivated;
    }

    public void setDeactivated(boolean theDeactivated) {
        this.isDeactivated = theDeactivated;
    }

    public Literal getMessage() {
        return this.message;
    }

    public void setMessage(Literal theMessage) {
        this.message = theMessage;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Shape)) {
            return false;
        }
        Shape that = (Shape)obj;
        return Objects.equals(this.resource, that.resource);
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public String toString() {
        return this.getResource().toString();
    }
}

