/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv.shacl;

import com.complexible.stardog.icv.shacl.ConstraintComponents;
import com.complexible.stardog.icv.shacl.NodeShape;
import com.complexible.stardog.icv.shacl.PropertyPaths;
import com.complexible.stardog.icv.shacl.PropertyShape;
import com.complexible.stardog.icv.shacl.SHACL;
import com.complexible.stardog.icv.shacl.Shape;
import com.complexible.stardog.icv.shacl.Targets;
import com.stardog.stark.IRI;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.impl.BooleanLiteral;
import com.stardog.stark.util.GraphBuilder;
import com.stardog.stark.util.ResourceBuilder;
import com.stardog.stark.vocabs.RDF;
import com.stardog.stark.vocabs.RDFS;

public class ShaclWriter {
    private final GraphBuilder graph;

    public ShaclWriter() {
        this(new GraphBuilder());
    }

    public ShaclWriter(GraphBuilder theGraph) {
        this.graph = theGraph;
    }

    public void writeShape(Shape shape) {
        ResourceBuilder shapeRes = this.graph.resource(shape.getResource());
        if (shape instanceof NodeShape) {
            shapeRes.addProperty(RDF.TYPE, (Value)shape.getType());
        }
        for (Targets.Target target : shape.getTargets()) {
            if (target instanceof Targets.ClassTarget && ((Targets.ClassTarget)target).getTargetClass().equals((Object)shape.getResource())) {
                shapeRes.addProperty(RDF.TYPE, (Value)RDFS.CLASS);
                continue;
            }
            target.toRDF(shapeRes);
        }
        if (shape.isDeactivated()) {
            shapeRes.addProperty(SHACL.deactivated, (Value)BooleanLiteral.TRUE);
        }
        if (shape instanceof PropertyShape) {
            PropertyShape propertyShape = (PropertyShape)shape;
            PropertyPaths.writePath(arg_0 -> ((GraphBuilder)this.graph).add(arg_0), shapeRes.subject(), SHACL.path, propertyShape.getPath());
            this.addProperty(shapeRes, SHACL.name, propertyShape.getName());
            this.addProperty(shapeRes, SHACL.description, propertyShape.getDescription());
        }
        this.addProperty(shapeRes, SHACL.severity, (Value)shape.getSeverity());
        this.addProperty(shapeRes, SHACL.message, (Value)shape.getMessage());
        for (ConstraintComponents.ConstraintComponent component : shape.getConstraints()) {
            component.toRDF(shapeRes, this);
        }
        for (PropertyShape propertyShape : shape.getPropertyShapes()) {
            shapeRes.addProperty(SHACL.property, (Value)propertyShape.getResource());
            this.writeShape(propertyShape);
        }
    }

    private void addProperty(ResourceBuilder resource, IRI property, String value) {
        if (value != null) {
            resource.addProperty(property, (Value)Values.literal((String)value));
        }
    }

    private void addProperty(ResourceBuilder resource, IRI property, Value value) {
        if (value != null) {
            resource.addProperty(property, value);
        }
    }

    public GraphBuilder getGraph() {
        return this.graph;
    }
}

