/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv.shacl;

import com.complexible.stardog.icv.AbstractConstraint;
import com.complexible.stardog.icv.Constraint;
import com.complexible.stardog.icv.shacl.ShaclWriter;
import com.complexible.stardog.icv.shacl.Shape;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Statement;
import java.util.Set;

public final class ShaclConstraint
extends AbstractConstraint
implements Constraint {
    private final Shape shape;
    private Set<Statement> mStatements = null;

    public ShaclConstraint(Shape theShape) {
        Preconditions.checkNotNull((Object)theShape, (Object)"Cannot create a constraint from a null Axiom");
        this.shape = theShape;
        Preconditions.checkNotNull((Object)this.shape, (Object)"Cannot create a constraint from this axiom");
    }

    private ShaclConstraint(ShaclConstraint theConstraint) {
        this.shape = theConstraint.shape;
        this.mStatements = theConstraint.mStatements;
    }

    @Override
    public String toString(Namespaces theNamespaces) {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.shape.toString()).toString();
    }

    public Shape getShape() {
        return this.shape;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShaclConstraint that = (ShaclConstraint)o;
        return !(this.shape == null ? that.shape != null : !this.shape.equals(that.shape));
    }

    public int hashCode() {
        return this.shape.hashCode();
    }

    public ShaclConstraint copy() {
        return new ShaclConstraint(this);
    }

    @Override
    public Set<Statement> toStatements() {
        if (this.mStatements == null) {
            ShaclWriter writer = new ShaclWriter();
            writer.writeShape(this.shape);
            this.mStatements = writer.getGraph().graph();
        }
        return this.mStatements;
    }
}

