/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv.shacl;

import com.complexible.common.base.CloseableIterator;
import com.complexible.stardog.icv.shacl.PropertyPath;
import com.complexible.stardog.icv.shacl.PropertyPathVisitor;
import com.complexible.stardog.icv.shacl.SHACL;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Queues;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.vocabs.RDF;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class PropertyPaths {
    public static PredicatePath predicate(IRI pred) {
        return new PredicatePath(pred);
    }

    public static InversePath inverse(PropertyPath path) {
        return new InversePath(path);
    }

    public static ZeroOrMorePath zeroOrMore(PropertyPath path) {
        return new ZeroOrMorePath(path);
    }

    public static ZeroOrOnePath zeroOrOne(PropertyPath path) {
        return new ZeroOrOnePath(path);
    }

    public static OneOrMorePath oneOrMore(PropertyPath path) {
        return new OneOrMorePath(path);
    }

    public static SequencePath sequence(PropertyPath ... paths) {
        return new SequencePath((List<PropertyPath>)ImmutableList.copyOf((Object[])paths));
    }

    public static SequencePath sequence(Iterable<PropertyPath> paths) {
        return new SequencePath((List<PropertyPath>)ImmutableList.copyOf(paths));
    }

    public static AlternativePath alternative(PropertyPath ... paths) {
        return new AlternativePath((List<PropertyPath>)ImmutableList.copyOf((Object[])paths));
    }

    public static AlternativePath alternative(Iterable<PropertyPath> paths) {
        return new AlternativePath((List<PropertyPath>)ImmutableList.copyOf(paths));
    }

    public static void writePath(Consumer<Statement> graph, Resource subj, IRI pred, PropertyPath path) {
        if (path instanceof PredicatePath) {
            graph.accept(Values.statement((Resource)subj, (IRI)pred, (Value)((PredicatePath)path).getPredicate()));
        } else if (path instanceof SequencePath) {
            PropertyPaths.writePaths(graph, subj, pred, ((SequencePath)path).getPaths().iterator());
        } else {
            BNode pathRes = Values.bnode();
            graph.accept(Values.statement((Resource)subj, (IRI)pred, (Value)pathRes));
            if (path instanceof InversePath) {
                PropertyPaths.writePath(graph, (Resource)pathRes, SHACL.inversePath, ((InversePath)path).getPath());
            } else if (path instanceof ZeroOrMorePath) {
                PropertyPaths.writePath(graph, (Resource)pathRes, SHACL.zeroOrMorePath, ((ZeroOrMorePath)path).getPath());
            } else if (path instanceof ZeroOrOnePath) {
                PropertyPaths.writePath(graph, (Resource)pathRes, SHACL.zeroOrOnePath, ((ZeroOrOnePath)path).getPath());
            } else if (path instanceof OneOrMorePath) {
                PropertyPaths.writePath(graph, (Resource)pathRes, SHACL.oneOrMorePath, ((OneOrMorePath)path).getPath());
            } else if (path instanceof AlternativePath) {
                PropertyPaths.writePaths(graph, (Resource)pathRes, SHACL.alternativePath, ((AlternativePath)path).getPaths().iterator());
            }
        }
    }

    private static void writePaths(Consumer<Statement> graph, Resource subj, IRI pred, Iterator<PropertyPath> paths) {
        if (paths.hasNext()) {
            BNode listRes = Values.bnode();
            graph.accept(Values.statement((Resource)subj, (IRI)pred, (Value)listRes));
            PropertyPaths.writePath(graph, (Resource)listRes, RDF.FIRST, paths.next());
            PropertyPaths.writePaths(graph, (Resource)listRes, RDF.REST, paths);
        } else {
            graph.accept(Values.statement((Resource)subj, (IRI)pred, (Value)RDF.NIL));
        }
    }

    public static PropertyPath readPath(CloseableIterator<Statement> statements, Value path) {
        if (path instanceof IRI) {
            return PropertyPaths.predicate((IRI)path);
        }
        Preconditions.checkState((boolean)statements.hasNext(), (Object)"Expecting a SHACL path but no triples left");
        Statement stmt = (Statement)statements.next();
        Resource subj = stmt.subject();
        Preconditions.checkState((boolean)path.equals((Object)subj), (String)"Expecting subject %s but got: %s", (Object)path, (Object)subj);
        IRI pred = stmt.predicate();
        Value obj = stmt.object();
        if (pred.equals((Object)SHACL.inversePath)) {
            return PropertyPaths.inverse(PropertyPaths.readPath(statements, obj));
        }
        if (pred.equals((Object)SHACL.zeroOrMorePath)) {
            return PropertyPaths.zeroOrMore(PropertyPaths.readPath(statements, obj));
        }
        if (pred.equals((Object)SHACL.zeroOrOnePath)) {
            return PropertyPaths.zeroOrOne(PropertyPaths.readPath(statements, obj));
        }
        if (pred.equals((Object)SHACL.oneOrMorePath)) {
            return PropertyPaths.oneOrMore(PropertyPaths.readPath(statements, obj));
        }
        if (pred.equals((Object)SHACL.alternativePath)) {
            return PropertyPaths.alternative(PropertyPaths.readPathList(statements, obj));
        }
        if (pred.equals((Object)RDF.FIRST)) {
            PropertyPath first = PropertyPaths.readPath(statements, obj);
            return PropertyPaths.sequence(PropertyPaths.readPathRest(statements, (Value)subj, first));
        }
        throw new IllegalStateException("Expecting a SHACL path but got: " + String.valueOf(stmt));
    }

    private static Deque<PropertyPath> readPathList(CloseableIterator<Statement> statements, Value path) {
        if (path.equals((Object)RDF.NIL)) {
            return Queues.newArrayDeque();
        }
        Preconditions.checkState((boolean)statements.hasNext(), (Object)"Expecting rdf:first but no triples left");
        Statement stmt = (Statement)statements.next();
        Preconditions.checkState((boolean)stmt.subject().equals((Object)path), (String)"Malformed rdf:List: %s != %s", (Object)stmt.subject(), (Object)path);
        Value value = stmt.object();
        Preconditions.checkState((boolean)stmt.predicate().equals((Object)RDF.FIRST), (String)"Expecting rdf:first but got: %s", (Object)stmt);
        PropertyPath first = PropertyPaths.readPath(statements, value);
        return PropertyPaths.readPathRest(statements, path, first);
    }

    private static Deque<PropertyPath> readPathRest(CloseableIterator<Statement> statements, Value listRes, PropertyPath first) {
        Preconditions.checkState((boolean)statements.hasNext(), (Object)"Expecting rdf:rest but no triples left");
        Statement stmt = (Statement)statements.next();
        Value value = stmt.object();
        Preconditions.checkState((boolean)stmt.predicate().equals((Object)RDF.REST), (String)"Expecting rdf:rest but got: %s", (Object)stmt);
        Preconditions.checkState((boolean)stmt.subject().equals((Object)listRes), (String)"Malformed rdf:List: %s != %s", (Object)stmt.subject(), (Object)listRes);
        Deque<PropertyPath> list = PropertyPaths.readPathList(statements, value);
        list.addFirst(first);
        return list;
    }

    public static class PredicatePath
    implements PropertyPath {
        private final IRI mPredicate;

        private PredicatePath(IRI mPredicate) {
            this.mPredicate = mPredicate;
        }

        public IRI getPredicate() {
            return this.mPredicate;
        }

        @Override
        public Set<IRI> getAllowedProperties() {
            return ImmutableSet.of((Object)this.mPredicate);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PredicatePath that = (PredicatePath)obj;
            return Objects.equals(this.mPredicate, that.mPredicate);
        }

        public int hashCode() {
            return Objects.hash(this.mPredicate);
        }

        public String toString() {
            return "<" + String.valueOf(this.mPredicate) + ">";
        }

        @Override
        public void accept(PropertyPathVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class InversePath
    extends UnaryPath {
        private InversePath(PropertyPath thePath) {
            super(thePath);
        }

        @Override
        public Set<IRI> getAllowedProperties() {
            return ImmutableSet.of();
        }

        @Override
        public String toString() {
            return "^" + super.toString();
        }

        @Override
        public void accept(PropertyPathVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class ZeroOrMorePath
    extends RecursivePath {
        private ZeroOrMorePath(PropertyPath thePath) {
            super(thePath, 0);
        }

        @Override
        public String toString() {
            return super.toString() + "*";
        }

        @Override
        public void accept(PropertyPathVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class ZeroOrOnePath
    extends UnaryPath {
        private ZeroOrOnePath(PropertyPath thePath) {
            super(thePath);
        }

        @Override
        public String toString() {
            return super.toString() + "?";
        }

        @Override
        public void accept(PropertyPathVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class OneOrMorePath
    extends RecursivePath {
        private OneOrMorePath(PropertyPath thePath) {
            super(thePath, 1);
        }

        @Override
        public String toString() {
            return super.toString() + "+";
        }

        @Override
        public void accept(PropertyPathVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class SequencePath
    extends NaryPath {
        public SequencePath(List<PropertyPath> thePaths) {
            super(thePaths);
        }

        @Override
        protected PropertyPath create(List<PropertyPath> thePaths) {
            return new SequencePath(thePaths);
        }

        @Override
        public Set<IRI> getAllowedProperties() {
            return this.getPaths().get(0).getAllowedProperties();
        }

        public String toString() {
            return this.toString('/');
        }

        @Override
        public void accept(PropertyPathVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class AlternativePath
    extends NaryPath {
        public AlternativePath(List<PropertyPath> thePaths) {
            super(thePaths);
        }

        @Override
        protected PropertyPath create(List<PropertyPath> thePaths) {
            return new AlternativePath(thePaths);
        }

        @Override
        public Set<IRI> getAllowedProperties() {
            return this.getPaths().stream().flatMap(p -> p.getAllowedProperties().stream()).collect(Collectors.toSet());
        }

        public String toString() {
            return this.toString('|');
        }

        @Override
        public void accept(PropertyPathVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static abstract class NaryPath
    implements PropertyPath {
        private final List<PropertyPath> mPaths;

        private NaryPath(List<PropertyPath> thePaths) {
            Preconditions.checkArgument((!thePaths.isEmpty() ? 1 : 0) != 0);
            this.mPaths = thePaths;
        }

        public List<PropertyPath> getPaths() {
            return this.mPaths;
        }

        protected abstract PropertyPath create(List<PropertyPath> var1);

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NaryPath that = (NaryPath)obj;
            return Objects.equals(this.getPaths(), that.getPaths());
        }

        public int hashCode() {
            return Objects.hash(this.mPaths);
        }

        public String toString(char theSeparator) {
            return Joiner.on((char)theSeparator).join(this.mPaths);
        }
    }

    static abstract class RecursivePath
    extends UnaryPath {
        protected final int mMinRecursion;

        private RecursivePath(PropertyPath thePath, int theMinRecursion) {
            super(thePath);
            this.mMinRecursion = theMinRecursion;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RecursivePath that = (RecursivePath)obj;
            return Objects.equals(this.getPath(), that.getPath()) && this.mMinRecursion == that.mMinRecursion;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getPath()) * this.mMinRecursion;
        }
    }

    public static abstract class UnaryPath
    implements PropertyPath {
        private final PropertyPath mPath;

        private UnaryPath(PropertyPath thePath) {
            this.mPath = thePath;
        }

        public PropertyPath getPath() {
            return this.mPath;
        }

        @Override
        public Set<IRI> getAllowedProperties() {
            return this.getPath().getAllowedProperties();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            UnaryPath that = (UnaryPath)obj;
            return Objects.equals(this.mPath, that.mPath);
        }

        public int hashCode() {
            return Objects.hash(this.mPath);
        }

        public String toString() {
            return this.mPath instanceof PredicatePath ? this.mPath.toString() : "(" + String.valueOf(this.mPath) + ")";
        }
    }
}

