/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv.shacl;

import com.complexible.common.base.ImmutableCollectors;
import com.complexible.stardog.icv.shacl.SHACL;
import com.complexible.stardog.icv.shacl.ShaclWriter;
import com.complexible.stardog.icv.shacl.Shape;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Namespace;
import com.stardog.stark.Resource;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.util.GraphBuilder;
import com.stardog.stark.util.ResourceBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class ConstraintComponents {
    public static final Map<IRI, NodeKind> VALUE_KINDS = (Map)Stream.of(NodeKind.values()).collect(ImmutableCollectors.toMap(NodeKind::iri, nk -> nk));

    private static ResourceBuilder addProperty(GraphBuilder graph, ResourceBuilder subject, IRI property) {
        ResourceBuilder object = graph.bnode();
        subject.addProperty(property, (Value)object.subject());
        return object;
    }

    public static enum NodeKind {
        BLANK_NODE(SHACL.BlankNode, false, true, false),
        IRI(SHACL.IRI, true, false, false),
        LITERAL(SHACL.Literal, false, false, true),
        BLANK_NODE_OR_IRI(SHACL.BlankNodeOrIRI, true, true, false),
        BLANK_NODE_OR_LITERAL(SHACL.BlankNodeOrLiteral, false, true, true),
        IRI_OR_LITERAL(SHACL.IRIOrLiteral, true, false, true);

        private final IRI iri;
        private final boolean isIRI;
        private final boolean isBlankNode;
        private final boolean isLiteral;
        private final String str;

        private NodeKind(IRI theIRI, boolean theIsIRI, boolean theIsBlankNode, boolean theIsLiteral) {
            this.iri = theIRI;
            this.isIRI = theIsIRI;
            this.isBlankNode = theIsBlankNode;
            this.isLiteral = theIsLiteral;
            this.str = Joiner.on((String)" or ").skipNulls().join((Object)(this.isBlankNode ? "Blank Node" : null), (Object)(this.isIRI ? "IRI" : null), new Object[]{this.isLiteral ? "Literal" : null});
        }

        public boolean isIRI() {
            return this.isIRI;
        }

        public boolean isBlankNode() {
            return this.isBlankNode;
        }

        public boolean isLiteral() {
            return this.isLiteral;
        }

        public IRI iri() {
            return this.iri;
        }

        public String toString() {
            return this.str;
        }
    }

    public static class SparqlConstraintComponent
    implements ConstraintComponent {
        private final Resource resource;
        private final String query;
        private final List<Namespace> namespaces;
        private final Literal message;
        private final Set<IRI> namedGraphs;

        public SparqlConstraintComponent(Resource theResource, String theQuery, List<Namespace> theNamespaces, Literal theMessage, Set<IRI> theNamedGraphs) {
            this.resource = theResource;
            this.query = theQuery;
            this.namespaces = theNamespaces;
            this.message = theMessage;
            this.namedGraphs = theNamedGraphs;
        }

        @Override
        public IRI getIRI() {
            return SHACL.SPARQLConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.sparql;
        }

        public Resource getResource() {
            return this.resource;
        }

        public String getQuery() {
            return this.query;
        }

        public List<Namespace> getNamespaces() {
            return this.namespaces;
        }

        public Literal getMessage() {
            return this.message;
        }

        public Set<IRI> getNamedGraphs() {
            return this.namedGraphs;
        }

        @Override
        public ConstraintComponentType getType() {
            return ConstraintComponentType.QUERY;
        }

        @Override
        public void toRDF(ResourceBuilder shape, ShaclWriter writer) {
            GraphBuilder graph = writer.getGraph();
            ResourceBuilder sparqlRes = graph.resource(this.resource);
            sparqlRes.addProperty(SHACL.select, (Value)Values.literal((String)this.query));
            if (this.message != null) {
                sparqlRes.addProperty(SHACL.message, (Value)this.message);
            }
            if (!this.namespaces.isEmpty()) {
                ResourceBuilder prefixesRes = ConstraintComponents.addProperty(graph, sparqlRes, SHACL.prefixes);
                for (Namespace namespace : this.namespaces) {
                    ConstraintComponents.addProperty(graph, prefixesRes, SHACL.declare).addProperty(SHACL.prefix, (Value)Values.literal((String)namespace.prefix())).addProperty(SHACL.namespace, (Value)Values.literal((String)namespace.iri(), (Datatype)Datatype.ANYURI));
                }
            }
            if (!this.namedGraphs.isEmpty()) {
                sparqlRes.addProperty(SHACL.customNamedGraphs, this.namedGraphs);
            }
            shape.addProperty(SHACL.sparql, sparqlRes);
        }
    }

    public static class XoneConstraintComponent
    extends NaryBooleanConstraintComponent {
        public XoneConstraintComponent(List<Shape> theArgs) {
            super(theArgs);
        }

        @Override
        public IRI getIRI() {
            return SHACL.XoneConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.xone;
        }
    }

    public static class OrConstraintComponent
    extends NaryBooleanConstraintComponent {
        public OrConstraintComponent(List<Shape> theArgs) {
            super(theArgs);
        }

        @Override
        public IRI getIRI() {
            return SHACL.OrConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.or;
        }
    }

    public static class AndConstraintComponent
    extends NaryBooleanConstraintComponent {
        public AndConstraintComponent(List<Shape> theArgs) {
            super(theArgs);
        }

        @Override
        public IRI getIRI() {
            return SHACL.AndConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.and;
        }
    }

    public static abstract class NaryBooleanConstraintComponent
    extends BooleanConstraintComponent {
        private final List<Shape> args;

        public NaryBooleanConstraintComponent(List<Shape> theArgs) {
            this.args = theArgs;
        }

        public List<Shape> getArgs() {
            return this.args;
        }

        @Override
        public void toRDF(ResourceBuilder shape, ShaclWriter writer) {
            ArrayList resources = Lists.newArrayList();
            for (Shape arg : this.args) {
                writer.writeShape(arg);
                resources.add(arg.getResource());
            }
            shape.addProperty(this.getInputProperty(), (List)resources);
        }
    }

    public static class NotConstraintComponent
    extends NaryBooleanConstraintComponent {
        public NotConstraintComponent(Shape theArg) {
            super((List<Shape>)ImmutableList.of((Object)theArg));
        }

        @Override
        public IRI getIRI() {
            return SHACL.NotConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.not;
        }

        @Override
        public void toRDF(ResourceBuilder shape, ShaclWriter writer) {
            Shape arg = this.getArgs().get(0);
            writer.writeShape(arg);
            shape.addProperty(this.getInputProperty(), (Value)arg.getResource());
        }
    }

    public static class NodeConstraintComponent
    extends BooleanConstraintComponent {
        private final Shape arg;

        public NodeConstraintComponent(Shape theArg) {
            this.arg = theArg;
        }

        @Override
        public IRI getIRI() {
            return SHACL.NodeConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.node;
        }

        public Shape getArg() {
            return this.arg;
        }

        @Override
        public void toRDF(ResourceBuilder shape, ShaclWriter writer) {
            writer.writeShape(this.arg);
            shape.addProperty(this.getInputProperty(), (Value)this.arg.getResource());
        }
    }

    public static abstract class BooleanConstraintComponent
    extends AbstractConstraintComponent {
        @Override
        public ConstraintComponentType getType() {
            return ConstraintComponentType.QUERY;
        }
    }

    public static class LessThanOrEqualsConstraintComponent
    extends PropertyComparisonConstraintComponent {
        public LessThanOrEqualsConstraintComponent(IRI theProp) {
            super(theProp, Comparison.LE);
        }

        @Override
        public IRI getIRI() {
            return SHACL.LessThanOrEqualsConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.lessThanOrEquals;
        }
    }

    public static class LessThanConstraintComponent
    extends PropertyComparisonConstraintComponent {
        public LessThanConstraintComponent(IRI theProp) {
            super(theProp, Comparison.LT);
        }

        @Override
        public IRI getIRI() {
            return SHACL.LessThanConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.lessThan;
        }
    }

    public static class DisjointConstraintComponent
    extends PropertyComparisonConstraintComponent {
        public DisjointConstraintComponent(IRI theProp) {
            super(theProp, Comparison.NE);
        }

        @Override
        public IRI getIRI() {
            return SHACL.DisjointConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.disjoint;
        }
    }

    public static class EqualsConstraintComponent
    extends PropertyComparisonConstraintComponent {
        public EqualsConstraintComponent(IRI theProp) {
            super(theProp, Comparison.EQ);
        }

        @Override
        public IRI getIRI() {
            return SHACL.EqualsConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.equals;
        }

        @Override
        public ConstraintComponentType getType() {
            return ConstraintComponentType.QUERY;
        }
    }

    public static abstract class PropertyComparisonConstraintComponent
    extends AbstractConstraintComponent {
        protected final IRI prop;
        protected final Comparison comparison;

        public PropertyComparisonConstraintComponent(IRI theProp, Comparison theComparison) {
            this.prop = theProp;
            this.comparison = theComparison;
        }

        public IRI getProperty() {
            return this.prop;
        }

        public Comparison getComparison() {
            return this.comparison;
        }

        @Override
        public ConstraintComponentType getType() {
            return ConstraintComponentType.QUERY;
        }

        @Override
        public void toRDF(ResourceBuilder shape, ShaclWriter writer) {
            shape.addProperty(this.getInputProperty(), (Value)this.getProperty());
        }
    }

    public static class UniqueLangConstraintComponent
    extends AbstractConstraintComponent {
        private final boolean isUnique;

        public UniqueLangConstraintComponent(boolean isUnique) {
            this.isUnique = isUnique;
        }

        public boolean isUnique() {
            return this.isUnique;
        }

        @Override
        public ConstraintComponentType getType() {
            return ConstraintComponentType.QUERY;
        }

        @Override
        public IRI getIRI() {
            return SHACL.UniqueLangConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.uniqueLang;
        }

        @Override
        public void toRDF(ResourceBuilder shape, ShaclWriter writer) {
            shape.addProperty(this.getInputProperty(), Boolean.valueOf(this.isUnique));
        }
    }

    public static class ClosedConstraintComponent
    extends AbstractConstraintComponent {
        private final boolean isClosed;
        private final List<IRI> ignoredProps;

        public ClosedConstraintComponent(boolean isClosed, List<IRI> ignoredProps) {
            this.isClosed = isClosed;
            this.ignoredProps = ignoredProps;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public Collection<IRI> getIgnoredProperties() {
            return this.ignoredProps;
        }

        @Override
        public ConstraintComponentType getType() {
            return ConstraintComponentType.QUERY;
        }

        @Override
        public IRI getIRI() {
            return SHACL.ClosedConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.closed;
        }

        @Override
        public void toRDF(ResourceBuilder shape, ShaclWriter writer) {
            shape.addProperty(this.getInputProperty(), Boolean.valueOf(this.isClosed));
            if (!this.ignoredProps.isEmpty()) {
                shape.addProperty(SHACL.ignoredProperties, this.ignoredProps);
            }
        }
    }

    public static class PatternConstraintComponent
    extends AbstractConstraintComponent {
        public static final Literal NO_FLAGS = Values.literal((String)"");
        private final Literal pattern;
        private final Literal flags;

        public PatternConstraintComponent(Literal thePattern) {
            this(thePattern, NO_FLAGS);
        }

        public PatternConstraintComponent(Literal thePattern, Literal theFlags) {
            this.pattern = thePattern;
            this.flags = theFlags;
        }

        @Override
        public IRI getIRI() {
            return SHACL.PatternConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.pattern;
        }

        public Literal getPattern() {
            return this.pattern;
        }

        public Literal getFlags() {
            return this.flags;
        }

        @Override
        public void toRDF(ResourceBuilder shape, ShaclWriter writer) {
            shape.addProperty(this.getInputProperty(), (Value)this.pattern);
            if (!this.flags.label().isEmpty()) {
                shape.addProperty(SHACL.flags, (Value)this.flags);
            }
        }
    }

    public static class MaxLengthComparisonConstraintComponent
    extends LengthComparisonConstraintComponent {
        public MaxLengthComparisonConstraintComponent(Literal theValue) {
            super(theValue, Comparison.LE, SHACL.MaxLengthConstraintComponent);
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.maxLength;
        }
    }

    public static class MinLengthComparisonConstraintComponent
    extends LengthComparisonConstraintComponent {
        public MinLengthComparisonConstraintComponent(Literal theValue) {
            super(theValue, Comparison.GE, SHACL.MinLengthConstraintComponent);
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.minLength;
        }
    }

    public static abstract class LengthComparisonConstraintComponent
    extends AbstractConstraintComponent {
        private final Literal length;
        private final Comparison comparison;
        private final IRI iri;

        public LengthComparisonConstraintComponent(Literal theValue, Comparison theComparison, IRI theIRI) {
            this.length = theValue;
            this.comparison = theComparison;
            this.iri = theIRI;
        }

        @Override
        public IRI getIRI() {
            return this.iri;
        }

        public Literal getLength() {
            return this.length;
        }

        public Comparison getComparison() {
            return this.comparison;
        }

        @Override
        public void toRDF(ResourceBuilder shape, ShaclWriter writer) {
            shape.addProperty(this.getInputProperty(), (Value)this.getLength());
        }
    }

    public static enum Comparison {
        LT("<"),
        LE("<="),
        GT(">"),
        GE(">="),
        EQ("="),
        NE("!=");

        private final String op;

        private Comparison(String theOp) {
            this.op = theOp;
        }

        public String op() {
            return this.op;
        }

        public boolean satisfied(int cmp) {
            switch (this.ordinal()) {
                case 0: {
                    return cmp < 0;
                }
                case 1: {
                    return cmp <= 0;
                }
                case 2: {
                    return cmp > 0;
                }
                case 3: {
                    return cmp >= 0;
                }
                case 4: {
                    return cmp == 0;
                }
                case 5: {
                    return cmp != 0;
                }
            }
            throw new AssertionError();
        }
    }

    public static class MaxExclusiveConstraintComponent
    extends ComparisonConstraintComponent {
        public MaxExclusiveConstraintComponent(Literal theValue) {
            super(theValue, Comparison.LT, SHACL.MaxExclusiveConstraintComponent);
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.maxExclusive;
        }
    }

    public static class MaxInclusiveConstraintComponent
    extends ComparisonConstraintComponent {
        public MaxInclusiveConstraintComponent(Literal theValue) {
            super(theValue, Comparison.LE, SHACL.MaxInclusiveConstraintComponent);
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.maxInclusive;
        }
    }

    public static class MinExclusiveConstraintComponent
    extends ComparisonConstraintComponent {
        public MinExclusiveConstraintComponent(Literal theValue) {
            super(theValue, Comparison.GT, SHACL.MinExclusiveConstraintComponent);
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.minExclusive;
        }
    }

    public static class MinInclusiveConstraintComponent
    extends ComparisonConstraintComponent {
        public MinInclusiveConstraintComponent(Literal theValue) {
            super(theValue, Comparison.GE, SHACL.MinInclusiveConstraintComponent);
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.minInclusive;
        }
    }

    public static abstract class ComparisonConstraintComponent
    extends AbstractConstraintComponent {
        private final Literal literal;
        private final Comparison comparison;
        private final IRI iri;

        public ComparisonConstraintComponent(Literal theValue, Comparison theComparison, IRI theIRI) {
            this.literal = theValue;
            this.comparison = theComparison;
            this.iri = theIRI;
        }

        @Override
        public IRI getIRI() {
            return this.iri;
        }

        public Comparison getComparison() {
            return this.comparison;
        }

        public Literal getCompareValue() {
            return this.literal;
        }

        @Override
        public void toRDF(ResourceBuilder shape, ShaclWriter writer) {
            shape.addProperty(this.getInputProperty(), (Value)this.getCompareValue());
        }
    }

    public static class NodeKindConstraintComponent
    extends AbstractConstraintComponent {
        private final NodeKind mNodeKind;

        public NodeKindConstraintComponent(IRI theIRI) {
            this.mNodeKind = (NodeKind)((Object)Preconditions.checkNotNull((Object)((Object)VALUE_KINDS.get(theIRI)), (String)"Unrecognized value kind: %s", (Object)theIRI));
        }

        public NodeKindConstraintComponent(NodeKind theNodeKind) {
            this.mNodeKind = (NodeKind)((Object)Preconditions.checkNotNull((Object)((Object)theNodeKind)));
        }

        public NodeKind getNodeKind() {
            return this.mNodeKind;
        }

        @Override
        public IRI getIRI() {
            return SHACL.NodeKindConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.nodeKind;
        }

        @Override
        public void toRDF(ResourceBuilder shape, ShaclWriter writer) {
            shape.addProperty(this.getInputProperty(), (Value)this.mNodeKind.iri());
        }
    }

    public static class LanguageInConstraintComponent
    extends AbstractConstraintComponent {
        private final List<Value> languages;

        public LanguageInConstraintComponent(List<Value> theLanguages) {
            this.languages = theLanguages;
        }

        public List<Value> getLanguages() {
            return this.languages;
        }

        @Override
        public IRI getIRI() {
            return SHACL.LanguageInConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.languageIn;
        }

        @Override
        public void toRDF(ResourceBuilder shape, ShaclWriter writer) {
            shape.addProperty(this.getInputProperty(), this.getLanguages());
        }
    }

    public static class InConstraintComponent
    extends AbstractConstraintComponent {
        private final List<Value> values;

        public InConstraintComponent(List<Value> theValues) {
            this.values = theValues;
        }

        @Override
        public IRI getIRI() {
            return SHACL.InConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.in;
        }

        public List<Value> getValues() {
            return this.values;
        }

        @Override
        public void toRDF(ResourceBuilder shape, ShaclWriter writer) {
            shape.addProperty(this.getInputProperty(), this.getValues());
        }
    }

    public static class HasValueConstraintComponent
    extends AbstractConstraintComponent {
        private final Value value;

        public HasValueConstraintComponent(Value theValue) {
            this.value = theValue;
        }

        @Override
        public ConstraintComponentType getType() {
            return ConstraintComponentType.QUERY;
        }

        @Override
        public IRI getIRI() {
            return SHACL.HasValueConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.hasValue;
        }

        public Value getValue() {
            return this.value;
        }

        @Override
        public void toRDF(ResourceBuilder shape, ShaclWriter writer) {
            shape.addProperty(this.getInputProperty(), this.getValue());
        }
    }

    public static class DatatypeConstraintComponent
    extends AbstractConstraintComponent {
        private final IRI datatype;

        public DatatypeConstraintComponent(IRI theDatatype) {
            this.datatype = theDatatype;
        }

        public IRI getDatatypeIRI() {
            return this.datatype;
        }

        @Override
        public IRI getIRI() {
            return SHACL.DatatypeConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.datatype;
        }

        @Override
        public void toRDF(ResourceBuilder shape, ShaclWriter writer) {
            shape.addProperty(this.getInputProperty(), (Value)this.getDatatypeIRI());
        }
    }

    public static class ClassConstraintComponent
    implements ConstraintComponent {
        private final IRI cls;

        public ClassConstraintComponent(IRI theCls) {
            this.cls = theCls;
        }

        public IRI getClassIRI() {
            return this.cls;
        }

        @Override
        public IRI getIRI() {
            return SHACL.ClassConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL._class;
        }

        @Override
        public void toRDF(ResourceBuilder shape, ShaclWriter writer) {
            shape.addProperty(this.getInputProperty(), (Value)this.getClassIRI());
        }
    }

    public static class QualifiedMaxCountConstraintComponent
    extends QualifiedCountConstraintComponent {
        public QualifiedMaxCountConstraintComponent(Literal theMaxCount, Shape theShape) {
            super(theMaxCount, Comparison.LE, theShape, false);
        }

        public QualifiedMaxCountConstraintComponent(Literal theMaxCount, Shape theShape, boolean theDisjoint) {
            super(theMaxCount, Comparison.LE, theShape, theDisjoint);
        }

        @Override
        public IRI getIRI() {
            return SHACL.QualifiedMaxCountConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.qualifiedMaxCount;
        }
    }

    public static class QualifiedMinCountConstraintComponent
    extends QualifiedCountConstraintComponent {
        public QualifiedMinCountConstraintComponent(Literal theMinCount, Shape theShape) {
            super(theMinCount, Comparison.GE, theShape, false);
        }

        public QualifiedMinCountConstraintComponent(Literal theMinCount, Shape theShape, boolean theDisjoint) {
            super(theMinCount, Comparison.GE, theShape, theDisjoint);
        }

        @Override
        public IRI getIRI() {
            return SHACL.QualifiedMinCountConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.qualifiedMinCount;
        }
    }

    public static abstract class QualifiedCountConstraintComponent
    extends CountConstraintComponent {
        private final Shape shape;
        private final boolean isDisjoint;

        public QualifiedCountConstraintComponent(Literal theValue, Comparison theComparison, Shape theShape, boolean theDisjoint) {
            super(theValue, theComparison);
            this.shape = theShape;
            this.isDisjoint = theDisjoint;
        }

        @Override
        public ConstraintComponentType getType() {
            return ConstraintComponentType.QUERY;
        }

        @Override
        public boolean isUnsupported() {
            return true;
        }

        public boolean isDisjoint() {
            return this.isDisjoint;
        }

        public Shape getShape() {
            return this.shape;
        }

        @Override
        public void toRDF(ResourceBuilder shape, ShaclWriter writer) {
            shape.addProperty(this.getInputProperty(), (Value)this.getCount()).addProperty(SHACL.qualifiedValueShape, (Value)this.getShape().getResource());
            if (this.isDisjoint) {
                shape.addProperty(SHACL.qualifiedValueShapesDisjoint, Boolean.valueOf(true));
            }
            writer.writeShape(this.getShape());
        }
    }

    public static class MaxCountConstraintComponent
    extends UnqualifiedCountConstraintComponent {
        public MaxCountConstraintComponent(int theInt) {
            this(Values.literal((int)theInt, (Datatype)Datatype.INTEGER));
        }

        public MaxCountConstraintComponent(Literal theMaxCount) {
            super(theMaxCount, Comparison.LE);
        }

        @Override
        public IRI getIRI() {
            return SHACL.MaxCountConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.maxCount;
        }
    }

    public static class MinCountConstraintComponent
    extends UnqualifiedCountConstraintComponent {
        public MinCountConstraintComponent(int theInt) {
            this(Values.literal((int)theInt, (Datatype)Datatype.INTEGER));
        }

        public MinCountConstraintComponent(Literal theMinCount) {
            super(theMinCount, Comparison.GE);
        }

        @Override
        public IRI getIRI() {
            return SHACL.MinCountConstraintComponent;
        }

        @Override
        public IRI getInputProperty() {
            return SHACL.minCount;
        }
    }

    public static abstract class UnqualifiedCountConstraintComponent
    extends CountConstraintComponent {
        public UnqualifiedCountConstraintComponent(Literal theMinCount, Comparison theComparison) {
            super(theMinCount, theComparison);
        }
    }

    public static abstract class CountConstraintComponent
    extends AbstractConstraintComponent {
        private final Literal count;
        private final Comparison comparison;

        public CountConstraintComponent(Literal theValue, Comparison theComparison) {
            this.count = theValue;
            this.comparison = theComparison;
        }

        @Override
        public ConstraintComponentType getType() {
            return ConstraintComponentType.COUNT;
        }

        public Literal getCount() {
            return this.count;
        }

        public Comparison getComparison() {
            return this.comparison;
        }

        @Override
        public void toRDF(ResourceBuilder shape, ShaclWriter writer) {
            shape.addProperty(this.getInputProperty(), (Value)this.getCount());
        }
    }

    private static abstract class AbstractConstraintComponent
    implements ConstraintComponent {
        private AbstractConstraintComponent() {
        }
    }

    public static interface ConstraintComponent {
        public void toRDF(ResourceBuilder var1, ShaclWriter var2);

        public IRI getIRI();

        public IRI getInputProperty();

        default public boolean isUnsupported() {
            return false;
        }

        default public ConstraintComponentType getType() {
            return ConstraintComponentType.FILTER;
        }
    }

    public static enum ConstraintComponentType {
        FILTER,
        COUNT,
        QUERY;

    }
}

