/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.db.tx;

import com.complexible.common.base.Change;
import com.complexible.common.base.Options;
import com.complexible.common.base.ProgressMonitor;
import com.complexible.common.base.ProgressReporter;
import com.complexible.common.io.ByteSourceOutputStream;
import com.complexible.common.io.ByteStreams2;
import com.complexible.common.io.DataInputToInputStreamAdapter;
import com.complexible.common.io.OutputStreamDataOutput;
import com.complexible.common.rdf.StatementSource;
import com.complexible.common.rdf.StatementSources;
import com.complexible.common.rdf.impl.MemoryStatementSource;
import com.complexible.common.rdf.impl.StreamStatementSources;
import com.complexible.common.rdf.rio.ParserConfigs;
import com.complexible.common.rdf.rio.RDFStreams;
import com.complexible.stardog.db.tx.IndexChange;
import com.complexible.tx.api.TransactionData;
import com.complexible.tx.api.TransactionDataFormat;
import com.complexible.tx.api.logging.impl.DefaultLogFormat;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Values;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;

public final class TxFormats {
    private static final int LIMIT = 0xA00000;
    private static final byte CONTEXT_NONE = 1;
    private static final byte CONTEXT_URI = 2;
    private static final byte CONTEXT_BNODE = 4;
    public static final RDFFormat RDF_FORMAT = RDFFormats.compressedFormat((RDFFormat)RDFFormats.BINARY, (FileFormat.Compression)FileFormat.Compression.GZIP);

    private TxFormats() {
        throw new AssertionError((Object)"No instances");
    }

    public static enum RDF implements TransactionDataFormat<Change<IndexChange, StatementSource>, RDF>
    {
        Format;


        @Override
        public byte getFormatId() {
            return 114;
        }

        public String toString() {
            return "RDF";
        }

        @Override
        public TransactionData<Change<IndexChange, StatementSource>, RDF> readFrom(DataInput theInput, int version) throws IOException {
            MemoryStatementSource aSource;
            IRI aContext;
            IndexChange aIndexChange;
            if (version <= DefaultLogFormat.V3.version()) {
                byte[] aBytes = new byte[theInput.readInt()];
                theInput.readFully(aBytes);
                aIndexChange = (IndexChange)((Object)ByteStreams2.fromByteArray((byte[])aBytes, IndexChange.class));
            } else {
                byte aChangeType = theInput.readByte();
                if (aChangeType < 0 || aChangeType >= IndexChange.values().length) {
                    throw new IOException("Invalid IndexChange value found in log: " + aChangeType);
                }
                aIndexChange = IndexChange.values()[aChangeType];
            }
            byte aHasContext = theInput.readByte();
            if (aHasContext != 1) {
                byte[] aStrBytes = new byte[theInput.readInt()];
                theInput.readFully(aStrBytes);
                String aStr = new String(aStrBytes, StandardCharsets.UTF_8);
                aContext = aHasContext == 2 ? Values.iri((String)aStr) : Values.bnode((String)aStr);
            } else {
                aContext = null;
            }
            long aLength = theInput.readLong();
            Options aParserConfig = ParserConfigs.lax();
            if (aLength < 0xA00000L) {
                ArrayList aStatements = Lists.newArrayList();
                if (aLength > 0L) {
                    byte[] aInputBytes = new byte[(int)aLength];
                    theInput.readFully(aInputBytes);
                    RDFStreams.forStream((InputStream)new ByteArrayInputStream(aInputBytes)).format(RDF_FORMAT).config(aParserConfig).parseInto((Collection)aStatements);
                }
                aSource = MemoryStatementSource.of((Iterable)aStatements, (Resource)aContext);
            } else {
                Path aFile = Files.createTempFile("rdf-tx-log", ".tmp", new FileAttribute[0]);
                InputStream in = ByteStreams.limit((InputStream)DataInputToInputStreamAdapter.create((DataInput)theInput), (long)aLength);
                Files.copy(in, aFile, StandardCopyOption.REPLACE_EXISTING);
                StreamStatementSources.ReusableStreamSourceCreator aSourceCreator = StreamStatementSources.reusable((RDFFormat)RDF_FORMAT, (Options)aParserConfig);
                aSource = aSourceCreator.create(RDF_FORMAT, aFile.toFile(), (Resource)aContext, true);
            }
            return TransactionData.create(Format, Change.of((Enum)aIndexChange, (Object)aSource));
        }

        @Override
        public void writeTo(TransactionData<Change<IndexChange, StatementSource>, RDF> theData, DataOutput theOutput, int version) throws IOException {
            Change<IndexChange, StatementSource> aData = theData.getData();
            if (version <= DefaultLogFormat.V3.version()) {
                byte[] aBytes = ByteStreams2.toByteArray((Object)aData.getChangeType());
                theOutput.writeInt(aBytes.length);
                theOutput.write(aBytes);
            } else {
                theOutput.writeByte(((IndexChange)aData.getChangeType()).ordinal());
            }
            if (((StatementSource)aData.getChange()).getContext() != null) {
                theOutput.write(((StatementSource)aData.getChange()).getContext() instanceof BNode ? 4 : 2);
                byte[] aStrBytes = ((StatementSource)aData.getChange()).getContext().toString().getBytes(Charsets.UTF_8);
                theOutput.writeInt(aStrBytes.length);
                theOutput.write(aStrBytes);
            } else {
                theOutput.write(1);
            }
            OutputStream aOutputStream = theOutput instanceof OutputStream ? (OutputStream)((Object)theOutput) : new OutputStreamDataOutput(theOutput);
            boolean aSizeWritten = false;
            try (ByteSourceOutputStream aOut = ByteSourceOutputStream.deleteOnClose((long)0xA00000L);){
                StatementSources.write((StatementSource)((StatementSource)aData.getChange()), (RDFFormat)RDF_FORMAT, (OutputStream)aOut, (ProgressReporter)ProgressMonitor.silent());
                ByteSource aByteSource = aOut.asByteSource();
                theOutput.writeLong(aByteSource.size());
                aSizeWritten = true;
                aByteSource.copyTo(aOutputStream);
            }
            catch (Exception e) {
                if (!aSizeWritten) {
                    try {
                        theOutput.writeLong(0L);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new IOException("There was an error recording the data in the log", e);
            }
        }
    }
}

