/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.db.index.literals;

import com.complexible.stardog.metadata.ConfigProperty;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.MetaPropertyProvider;
import com.complexible.stardog.metadata.OptionsCategory;
import com.google.common.collect.ImmutableList;
import com.google.inject.Singleton;
import java.util.Collection;

@Singleton
public class LiteralIndexOptions
implements MetaPropertyProvider {
    private static final String OPTION_INDEXED_DATA_PROPERTIES = "index.literals.properties";
    private static final String OPTION_LITERAL_INDEX_MAX_SIZE = "index.literals.limit";
    public static final String INDEX_ALL_LITERALS = "tag:stardog:api:property:all";
    public static final String INDEX_NO_LITERALS = "tag:stardog:api:property:none";
    public static final ConfigProperty<Collection<String>> INDEXED_DATA_PROPERTIES = MetaProperty.config("index.literals.properties", String.class, ImmutableList.of((Object)"tag:stardog:api:property:none")).database().readable().creatable().writable().category(OptionsCategory.INDEX).label("Properties included in the literal index").description("Values of these properties will be put in a special literal index to support faster range queries. Provide a comma-separated property IRIs or the special IRI 'tag:stardog:api:property:all' to indicate all properties with supported value types should be indexed. The default value is 'tag:stardog:api:property:none' indicating literal index is disabled and no literal will be indexed.").build();
    public static final ConfigProperty<Long> LITERAL_INDEX_MAX_SIZE = MetaProperty.config("index.literals.limit", 10000000L).database().readable().creatable().writable().category(OptionsCategory.INDEX).label("The max number of indexed literals").description("Prevents the literal index from growing above this size. When indexed properties store more literals, the system stops indexing them and the literal index is no longer used for query answering.").build();
    public static final ConfigProperty<Integer> DIFFERENTIAL_INDEX_MAX_SIZE = MetaProperty.config("index.literals.merge.limit", 100000).database().readable().creatable().writable().category(OptionsCategory.INDEX).label("Size limit for the differential literal index").description("When the number of indexed literals added in transactions become greater than this, they will be added to the main index.").build();
}

