/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.db;

import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.common.io.Files2;
import com.complexible.common.rdf.rio.RDFStream;
import com.complexible.common.rdf.rio.RDFStreams;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.db.DatabaseArchetype;
import com.complexible.stardog.db.DatabaseArchetypeBase;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Statement;
import com.stardog.stark.Values;
import com.stardog.stark.io.ParserOptions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseArchetypes {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseArchetypes.class);
    public static final String FILE_PROPERTIES = "archetype.properties";
    public static final String FILE_NAMESPACES = "namespaces.ttl";
    public static final String DIR_SCHEMA = "schema";
    public static final String DIR_CONSTRAINT = "constraints";
    public static final Option<IRI> OPTION_IRI = Option.create((String)"iri");
    public static final Option<Boolean> OPTION_CONSTRAINTS_INLINE = Option.create((String)"constraints.inline", (Object)true);
    public static final Option<IRI> OPTION_CONSTRAINTS_GRAPH = Option.create((String)"constraints.graph");
    public static final Option<Boolean> OPTION_SCHEMA_INLINE = Option.create((String)"schema.inline", (Object)true);
    public static final Option<IRI> OPTION_SCHEMA_GRAPH = Option.create((String)"schema.graph");
    private static Path DIR = null;

    private DatabaseArchetypes() {
    }

    public static synchronized void setDirectory(Path dir) {
        DIR = dir;
    }

    public static synchronized DatabaseArchetype get(String name) {
        Path dir;
        DatabaseArchetype archetype = null;
        if (DIR != null && Files.exists(dir = DIR.resolve(name), new LinkOption[0])) {
            try {
                archetype = DatabaseArchetypes.read(dir);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return archetype;
    }

    private static DatabaseArchetype read(Path dir) throws IOException {
        IRI iri2;
        String name = dir.getFileName().toString();
        Options options = DatabaseArchetypes.readOptions(dir);
        List<Namespace> namespaces = DatabaseArchetypes.parseNamespaces(dir.resolve(FILE_NAMESPACES));
        Set<Statement> schema = DatabaseArchetypes.parseStreams(dir.resolve(DIR_SCHEMA), namespaces);
        Set<Statement> constraints = DatabaseArchetypes.parseStreams(dir.resolve(DIR_CONSTRAINT), namespaces);
        if (options.is(OPTION_CONSTRAINTS_INLINE) && !constraints.isEmpty()) {
            boolean noSHACL = FluentIterable.from(constraints).transform(Statement::object).filter(IRI.class::isInstance).filter(iri -> iri.toString().equals("http://www.w3.org/ns/shacl#Shape") || iri.toString().equals("http://www.w3.org/ns/shacl#NodeShape")).isEmpty();
            if (noSHACL) {
                LOGGER.warn("The option 'constraints.inline' is true but no SHACL constraints defined for the archetype " + name + ". Note that OWL constraints cannot be loaded inline.");
            }
        }
        if ((iri2 = (IRI)options.get(OPTION_IRI)) == null) {
            iri2 = namespaces.stream().filter(ns -> ns.prefix().equals(name)).map(Namespace::iri).map(Values::iri).findFirst().orElseThrow(() -> new RuntimeException("No IRI defined for the archetype " + name));
        } else {
            namespaces.add(Values.namespace((String)name, (String)iri2.toString()));
        }
        return new DatabaseArchetypeBase(name, iri2, schema, constraints, namespaces, options);
    }

    private static List<Namespace> parseNamespaces(Path file) {
        try {
            return RDFStreams.parseNamespaces(DatabaseArchetypes.getStreams(file, (List<Namespace>)ImmutableList.of()));
        }
        catch (Exception e) {
            throw new StardogException("Cannot parse namespaces file " + String.valueOf(file) + " for archetype " + String.valueOf(file.getParent().getFileName()) + ": " + e.getMessage(), e);
        }
    }

    private static Set<Statement> parseStreams(Path file, List<Namespace> namespaces) {
        try {
            return RDFStreams.parse(DatabaseArchetypes.getStreams(file, namespaces));
        }
        catch (Exception e) {
            throw new StardogException("Cannot parse " + String.valueOf(file) + " for archetype " + String.valueOf(file.getParent().getFileName()) + ": " + e.getMessage(), e);
        }
    }

    private static List<RDFStream> getStreams(Path file, List<Namespace> namespaces) {
        return Files.notExists(file, new LinkOption[0]) ? Collections.emptyList() : RDFStreams.forFile((Path)file).config(ParserOptions.namespaces((Iterable)Iterables.concat(namespaces, (Iterable)Namespaces.DEFAULT))).build();
    }

    private static Options readOptions(Path dir) throws IOException {
        Properties properties = DatabaseArchetypes.readProperties(dir);
        Options options = Options.create();
        DatabaseArchetypes.setOption(options, OPTION_IRI, properties, Values::iri);
        DatabaseArchetypes.setOption(options, OPTION_CONSTRAINTS_INLINE, properties, Boolean::valueOf);
        DatabaseArchetypes.setOption(options, OPTION_CONSTRAINTS_GRAPH, properties, Values::iri);
        DatabaseArchetypes.setOption(options, OPTION_SCHEMA_INLINE, properties, Boolean::valueOf);
        DatabaseArchetypes.setOption(options, OPTION_SCHEMA_GRAPH, properties, Values::iri);
        return options;
    }

    private static Properties readProperties(Path dir) throws IOException {
        Path file = dir.resolve(FILE_PROPERTIES);
        return Files.exists(file, new LinkOption[0]) ? Files2.loadProperties((Path)file) : new Properties();
    }

    private static <T> void setOption(Options options, Option<T> option, Properties properties, Function<String, T> parser) {
        String name = option.getName();
        if (properties.containsKey(name)) {
            String value = properties.getProperty(name);
            T parsed = parser.apply(value);
            options.set(option, parsed);
        }
    }
}

