/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.db;

import com.complexible.common.base.Options;
import com.complexible.common.rdf.rio.RDFStreams;
import com.complexible.stardog.db.DatabaseArchetype;
import com.complexible.stardog.db.DatabaseArchetypes;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.Statement;
import com.stardog.stark.Values;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class DatabaseArchetypeBase
implements DatabaseArchetype {
    private final String mName;
    private final IRI mURI;
    private final Iterable<Statement> mSchema;
    private final Iterable<Statement> mConstraints;
    private final Set<Namespace> mNamespaces;
    private final Options mOptions;

    public DatabaseArchetypeBase(String theName, IRI theURI, Iterable<Statement> theSchema) {
        this(theName, theURI, theSchema, true);
    }

    public DatabaseArchetypeBase(String theName, IRI theURI, Iterable<Statement> theSchema, boolean theNameAsPrefix) {
        this(theName, theURI, theSchema, (Iterable<Namespace>)(theNameAsPrefix ? ImmutableSet.of((Object)Values.namespace((String)theName, (String)theURI.toString())) : ImmutableSet.of()));
    }

    public DatabaseArchetypeBase(String theName, IRI theURI, Iterable<Statement> theSchema, Iterable<Namespace> theNamespaces) {
        this(theName, theURI, theSchema, Collections.emptyList(), theNamespaces, Options.of(DatabaseArchetypes.OPTION_SCHEMA_INLINE, (Object)false, DatabaseArchetypes.OPTION_CONSTRAINTS_INLINE, (Object)false));
    }

    public DatabaseArchetypeBase(String theName, IRI theURI, Iterable<Statement> theSchema, Iterable<Statement> theConstraints, Iterable<Namespace> theNamespaces, Options theOptions) {
        this.mName = (String)Preconditions.checkNotNull((Object)theName, (Object)"Archetype name cannot be null");
        this.mURI = (IRI)Preconditions.checkNotNull((Object)theURI, (Object)"Archetype IRI cannot be null");
        this.mSchema = (Iterable)Preconditions.checkNotNull(theSchema, (Object)"Archetype schema cannot be null");
        this.mConstraints = (Iterable)Preconditions.checkNotNull(theConstraints, (Object)"Archetype constraints cannot be null");
        this.mNamespaces = ImmutableSet.copyOf(theNamespaces);
        this.mOptions = (Options)Preconditions.checkNotNull((Object)theOptions, (Object)"Archetype options cannot be null");
    }

    @Override
    public IRI getURI() {
        return this.mURI;
    }

    @Override
    public String getShortName() {
        return this.mName;
    }

    @Override
    public Iterable<Statement> getSchema() {
        return this.mSchema;
    }

    @Override
    public Iterable<Namespace> getNamespaces() {
        return this.mNamespaces;
    }

    @Override
    public Iterable<Statement> getConstraintStatements() {
        return this.mConstraints;
    }

    @Override
    public Options getOptions() {
        return this.mOptions;
    }

    protected static Iterable<Statement> readStatements(Class<?> theContextClass, String ... theResources) {
        ArrayList aList = Lists.newArrayList();
        for (String aResource : theResources) {
            InputStream aStream = theContextClass.getResourceAsStream(aResource);
            RDFFormat aFormat = RDFFormats.forFile((Path)Paths.get(aResource, new String[0])).orElse(null);
            try {
                RDFStreams.forStream((InputStream)aStream).format(aFormat).parseInto((Collection)aList);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        return aList;
    }
}

