/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.common.rdf.rio.TurtleValueWriter;
import com.complexible.stardog.ImmutableStoredQuery;
import com.complexible.stardog.Schemas;
import com.complexible.stardog.StoredQuery;
import com.google.common.collect.ImmutableSet;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Namespace;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.StatementPattern;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.vocabs.RDF;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class StoredQueryIO {
    private static final Set<IRI> RESERVED_TYPES = ImmutableSet.of((Object)Vocabulary.StoredQuery, (Object)Vocabulary.SharedQuery, (Object)Vocabulary.ReasoningQuery);
    private static final Set<IRI> RESERVED_PROPS = ImmutableSet.of((Object)Vocabulary.queryName, (Object)Vocabulary.queryPath, (Object)Vocabulary.queryId, (Object)Vocabulary.queryDescription, (Object)Vocabulary.queryString, (Object)Vocabulary.queryDatabase, (Object[])new IRI[]{Vocabulary.queryCreator});

    public static List<StoredQuery> fromRDF(Iterable<Statement> statements) {
        return StreamSupport.stream(statements.spliterator(), false).filter((Predicate<Statement>)StatementPattern.po((IRI)RDF.TYPE, (Value)Vocabulary.StoredQuery)).map(stmt -> StoredQueryIO.fromRDF(stmt.subject(), statements)).collect(Collectors.toList());
    }

    public static ImmutableStoredQuery fromRDF(Resource subj, Iterable<Statement> statements) {
        ImmutableStoredQuery.Builder builder = ImmutableStoredQuery.builder().shared(false);
        StreamSupport.stream(statements.spliterator(), false).filter((Predicate<Statement>)StatementPattern.s((Resource)subj)).forEach(aStatement -> {
            IRI pred = aStatement.predicate();
            Value obj = aStatement.object();
            if (pred.equals((Object)RDF.TYPE)) {
                if (!obj.equals((Object)Vocabulary.StoredQuery)) {
                    if (obj.equals((Object)Vocabulary.SharedQuery)) {
                        builder.shared(true);
                    } else if (obj.equals((Object)Vocabulary.ReasoningQuery)) {
                        builder.reasoning(true);
                    } else {
                        builder.annotation(pred, obj);
                    }
                }
            } else if (pred.equals((Object)Vocabulary.queryName)) {
                builder.name(((Literal)obj).label());
            } else if (pred.equals((Object)Vocabulary.queryPath)) {
                builder.path((List)List.of(((Literal)obj).label().split("/")));
            } else if (pred.equals((Object)Vocabulary.queryId)) {
                builder.id(((Literal)obj).label());
            } else if (pred.equals((Object)Vocabulary.queryDescription)) {
                builder.description(((Literal)obj).label());
            } else if (pred.equals((Object)Vocabulary.queryString)) {
                builder.query(((Literal)obj).label());
            } else if (pred.equals((Object)Vocabulary.queryCreator)) {
                builder.creator(((Literal)obj).label());
            } else if (pred.equals((Object)Vocabulary.queryDatabase)) {
                builder.database(((Literal)obj).label());
            } else if (pred.equals((Object)Vocabulary.querySchema)) {
                builder.schema(((Literal)obj).label());
            } else if (pred.equals((Object)Vocabulary.triggerLimit)) {
                builder.triggerLimit(Literal.intValue((Literal)((Literal)obj)));
            } else if (pred.equals((Object)Vocabulary.triggerSchedule)) {
                builder.triggerSchedule(Literal.intValue((Literal)((Literal)obj)));
            } else if (pred.equals((Object)Vocabulary.triggerTimeout)) {
                builder.triggerTimeout(Literal.intValue((Literal)((Literal)obj)));
            } else if (pred.equals((Object)Vocabulary.triggerStatusLastRun)) {
                builder.triggerLastRun(Literal.longValue((Literal)((Literal)obj)));
            } else if (pred.equals((Object)Vocabulary.triggerStatusNextRun)) {
                builder.triggerNextRun(Literal.longValue((Literal)((Literal)obj)));
            } else if (pred.equals((Object)Vocabulary.triggerStatusLastChange)) {
                builder.triggerLastChange(Literal.longValue((Literal)((Literal)obj)));
            } else if (pred.equals((Object)Vocabulary.triggerError)) {
                builder.triggerErrorMessage(((Literal)obj).label());
            } else if (pred.equals((Object)Vocabulary.triggerPayloadType)) {
                builder.triggerPayloadType(StoredQuery.TriggerPayloadType.valueOf(((Literal)obj).label()));
            } else {
                builder.annotation(pred, obj);
            }
        });
        return builder.build();
    }

    static IRI storedQueryIri(StoredQuery query) {
        return Values.iri((String)("http://system.stardog.com/Query-" + StoredQuery.getFullPath(query).replaceAll("/", "-")));
    }

    public static Set<Statement> toRDF(StoredQuery query) {
        return StoredQueryIO.toRDF(query, false);
    }

    public static Set<Statement> toRDF(StoredQuery query, boolean includeTriggerStatus) {
        HashSet<Statement> graph = new HashSet<Statement>(7 + query.getAnnotations().size());
        StoredQueryIO.toRDF(query, includeTriggerStatus, graph::add);
        return graph;
    }

    public static void toRDF(StoredQuery query, boolean includeTriggerStatus, Consumer<Statement> consumer) {
        IRI result = StoredQueryIO.storedQueryIri(query);
        consumer.accept(Values.statement((Resource)result, (IRI)RDF.TYPE, (Value)Vocabulary.StoredQuery));
        if (query.isShared()) {
            consumer.accept(Values.statement((Resource)result, (IRI)RDF.TYPE, (Value)Vocabulary.SharedQuery));
        }
        if (query.isReasoning()) {
            consumer.accept(Values.statement((Resource)result, (IRI)RDF.TYPE, (Value)Vocabulary.ReasoningQuery));
        }
        consumer.accept(Values.statement((Resource)result, (IRI)Vocabulary.queryName, (Value)Values.literal((String)query.getName())));
        if (!query.getPath().isEmpty()) {
            consumer.accept(Values.statement((Resource)result, (IRI)Vocabulary.queryPath, (Value)Values.literal((String)String.join((CharSequence)"/", query.getPath()))));
        }
        if (query.getDescription() != null) {
            consumer.accept(Values.statement((Resource)result, (IRI)Vocabulary.queryDescription, (Value)Values.literal((String)query.getDescription())));
        }
        consumer.accept(Values.statement((Resource)result, (IRI)Vocabulary.queryId, (Value)Values.literal((String)((ImmutableStoredQuery)query).getId())));
        consumer.accept(Values.statement((Resource)result, (IRI)Vocabulary.queryString, (Value)Values.literal((String)query.getQuery())));
        consumer.accept(Values.statement((Resource)result, (IRI)Vocabulary.queryCreator, (Value)Values.literal((String)query.getCreator())));
        consumer.accept(Values.statement((Resource)result, (IRI)Vocabulary.queryDatabase, (Value)Values.literal((String)query.getDatabase())));
        if (query.getSchema() != null && !Schemas.isDefault(query.getSchema())) {
            consumer.accept(Values.statement((Resource)result, (IRI)Vocabulary.querySchema, (Value)Values.literal((String)query.getSchema())));
        }
        for (Map.Entry aAnnotation : query.getAnnotations().entries()) {
            IRI property = (IRI)aAnnotation.getKey();
            Value value = (Value)aAnnotation.getValue();
            if (RESERVED_PROPS.contains(property)) {
                throw new IllegalArgumentException("Reserved property used in annotations: " + String.valueOf(aAnnotation));
            }
            if (property.equals((Object)RDF.TYPE) && value instanceof IRI && RESERVED_TYPES.contains((IRI)value)) {
                throw new IllegalArgumentException("Reserved type used in annotations: " + String.valueOf(aAnnotation));
            }
            consumer.accept(Values.statement((Resource)result, (IRI)property, (Value)value));
        }
        if (query.isTrigger()) {
            if (query.getTriggerLimit() > 0) {
                consumer.accept(Values.statement((Resource)result, (IRI)Vocabulary.triggerLimit, (Value)Values.literal((int)query.getTriggerLimit())));
            }
            consumer.accept(Values.statement((Resource)result, (IRI)Vocabulary.triggerSchedule, (Value)Values.literal((int)query.getTriggerSchedule())));
            if (query.getTriggerTimeout() > 0) {
                consumer.accept(Values.statement((Resource)result, (IRI)Vocabulary.triggerTimeout, (Value)Values.literal((int)query.getTriggerTimeout())));
            }
            consumer.accept(Values.statement((Resource)result, (IRI)Vocabulary.triggerTimeout, (Value)Values.literal((int)query.getTriggerTimeout())));
            consumer.accept(Values.statement((Resource)result, (IRI)Vocabulary.triggerPayloadType, (Value)Values.literal((String)query.getTriggerPayloadType().name())));
            StoredQuery.TriggerStatus status = query.getTriggerStatus();
            if (includeTriggerStatus && status != null) {
                consumer.accept(Values.statement((Resource)result, (IRI)Vocabulary.triggerStatusLastRun, (Value)Values.literal((long)status.lastRunTime)));
                consumer.accept(Values.statement((Resource)result, (IRI)Vocabulary.triggerStatusNextRun, (Value)Values.literal((long)status.nextRunTime)));
                consumer.accept(Values.statement((Resource)result, (IRI)Vocabulary.triggerStatusLastChange, (Value)Values.literal((long)status.lastChangeTime)));
                if (status.errorMessage != null) {
                    consumer.accept(Values.statement((Resource)result, (IRI)Vocabulary.triggerError, (Value)Values.literal((String)status.errorMessage)));
                }
            }
        }
    }

    public static void toRDF(Iterable<StoredQuery> queries, boolean includeTriggerStatus, RDFHandler handler) {
        handler.start();
        handler.namespace("system", "http://system.stardog.com/");
        queries.forEach(q -> StoredQueryIO.toRDF(q, includeTriggerStatus, arg_0 -> ((RDFHandler)handler).handle(arg_0)));
        handler.end();
    }

    public static void writeTable(Map<String, String> storedQueryOptionPairMap, Collection<Map.Entry<IRI, Value>> annotationsEntries, Iterable<Namespace> theNamespaces, OutputStream theStream) {
        TurtleValueWriter mWriter = new TurtleValueWriter(theNamespaces);
        String[] aCols = new String[]{"Stored Query Attribute", "Value"};
        TextTabularOutput aOutput = new TextTabularOutput(theStream, aCols);
        storedQueryOptionPairMap.forEach((xva$0, xva$1) -> aOutput.addRow(new Object[]{xva$0, xva$1}));
        Comparator<Map.Entry> byValue = Comparator.comparing(theEntry -> ((Value)theEntry.getValue()).toString());
        Comparator<Map.Entry> byValueAndKey = byValue.thenComparing(theEntry -> ((IRI)theEntry.getKey()).toString());
        annotationsEntries.stream().sorted(byValueAndKey).collect(Collectors.toList()).forEach(entry -> aOutput.addRow(new Object[]{"Annotation", mWriter.write((Value)entry.getKey()) + "=" + mWriter.write((Value)entry.getValue())}));
        aOutput.output();
    }

    public static class Vocabulary {
        public static final String NS = "http://system.stardog.com/";
        public static final String SQ = "http://system.stardog.com/sq/";
        public static final IRI StoredQuery = Values.iri((String)"http://system.stardog.com/StoredQuery");
        public static final IRI SharedQuery = Values.iri((String)"http://system.stardog.com/SharedQuery");
        public static final IRI ReasoningQuery = Values.iri((String)"http://system.stardog.com/ReasoningQuery");
        public static final IRI queryName = Values.iri((String)"http://system.stardog.com/queryName");
        public static final IRI queryPath = Values.iri((String)"http://system.stardog.com/queryPath");
        public static final IRI queryId = Values.iri((String)"http://system.stardog.com/queryId");
        public static final IRI queryDescription = Values.iri((String)"http://system.stardog.com/queryDescription");
        public static final IRI queryString = Values.iri((String)"http://system.stardog.com/queryString");
        public static final IRI queryDatabase = Values.iri((String)"http://system.stardog.com/queryDatabase");
        public static final IRI queryCreator = Values.iri((String)"http://system.stardog.com/queryCreator");
        public static final IRI querySchema = Values.iri((String)"http://system.stardog.com/querySchema");
        public static final IRI queryLanguage = Values.iri((String)"http://system.stardog.com/queryLanguage");
        public static final IRI group = Values.iri((String)"http://system.stardog.com/sq/group");
        public static final IRI SPARQL = Values.iri((String)"http://system.stardog.com/SPARQL");
        public static final IRI GRAPHQL = Values.iri((String)"http://system.stardog.com/GraphQL");
        public static final IRI VOICEBOX_QUESTIONS = Values.iri((String)"http://system.stardog.com/VoiceboxQuestions");
        public static final IRI voiceboxQuestion = Values.iri((String)"http://system.stardog.com/voiceboxQuestion");
        public static final IRI triggerLimit = Values.iri((String)"http://system.stardog.com/triggerLimit");
        public static final IRI triggerSchedule = Values.iri((String)"http://system.stardog.com/triggerSchedule");
        public static final IRI triggerTimeout = Values.iri((String)"http://system.stardog.com/triggerTimeout");
        public static final IRI triggerError = Values.iri((String)"http://system.stardog.com/triggerError");
        public static final IRI triggerStatusLastRun = Values.iri((String)"http://system.stardog.com/triggerLastRun");
        public static final IRI triggerStatusNextRun = Values.iri((String)"http://system.stardog.com/triggerNextRun");
        public static final IRI triggerStatusLastChange = Values.iri((String)"http://system.stardog.com/triggerLastChange");
        public static final IRI triggerPayloadType = Values.iri((String)"http://system.stardog.com/triggerPayloadType");
    }
}

