/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import com.google.common.collect.Multimap;
import com.stardog.stark.IRI;
import com.stardog.stark.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public interface StoredQuery {
    public static final String PATH_SEPARATOR = "/";
    public static final int DEFAULT_TRIGGER_LIMIT = 1000;
    public static final String ALL_DATABASES = "*";
    public static final Pattern VALID_NAME_PATTERN = Pattern.compile("[A-Za-z]{1}[A-Za-z0-9_/-]*");

    public String getName();

    default public List<String> getPath() {
        return List.of();
    }

    public String getDescription();

    public String getQuery();

    public String getCreator();

    public String getDatabase();

    public boolean isShared();

    public boolean isReasoning();

    public boolean isTrigger();

    public int getTriggerLimit();

    public int getTriggerSchedule();

    public int getTriggerTimeout();

    public String getSchema();

    public Multimap<IRI, Value> getAnnotations();

    public void close();

    public boolean isAvailable();

    @Nullable
    public TriggerStatus getTriggerStatus();

    public void setTriggerStatus(TriggerStatus var1);

    default public StoredQuery withName(String theNewName) {
        return this.toBuilder().name(theNewName).build();
    }

    default public StoredQuery withPath(List<String> thewNewPath) {
        return this.toBuilder().path(thewNewPath).build();
    }

    default public StoredQuery withFullPath(String theFullPath) {
        List<String> components = List.of(theFullPath.split(PATH_SEPARATOR));
        if (components.isEmpty()) {
            return this.toBuilder().name(theFullPath).build();
        }
        return this.toBuilder().name(components.getLast()).path(components.subList(0, components.size() - 1)).build();
    }

    public static boolean isValidName(String name) {
        return VALID_NAME_PATTERN.matcher(name).matches();
    }

    public static String getFullPath(StoredQuery theQuery) {
        List<String> path = theQuery.getPath();
        return path.isEmpty() ? theQuery.getName() : String.join((CharSequence)PATH_SEPARATOR, path) + PATH_SEPARATOR + theQuery.getName();
    }

    public static List<String> subPaths(List<String> path) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (String s : path) {
            if (builder.length() > 0) {
                builder.append(PATH_SEPARATOR);
            }
            builder.append(s);
            list.add(builder.toString());
        }
        return list;
    }

    public Builder toBuilder();

    public TriggerPayloadType getTriggerPayloadType();

    public static interface Builder {
        public Builder name(String var1);

        public Builder path(List<String> var1);

        public Builder description(String var1);

        public Builder query(String var1);

        public Builder creator(String var1);

        public Builder database(String var1);

        public Builder shared(boolean var1);

        public Builder reasoning(boolean var1);

        public Builder schema(String var1);

        public Builder annotations(Multimap<IRI, Value> var1);

        public Builder trigger(boolean var1);

        public Builder triggerLimit(int var1);

        public Builder triggerSchedule(int var1);

        public Builder triggerTimeout(int var1);

        public Builder triggerLastRun(long var1);

        public Builder triggerLastChange(long var1);

        public Builder triggerErrorMessage(String var1);

        public Builder triggerPayloadType(TriggerPayloadType var1);

        public StoredQuery build();
    }

    public static class TriggerStatus {
        public final long lastRunTime;
        public final long nextRunTime;
        public final long lastChangeTime;
        public final String errorMessage;

        public TriggerStatus(long lastRunTime, long nextRunTime, long lastChangeTime, String errorMessage) {
            this.lastRunTime = lastRunTime;
            this.nextRunTime = nextRunTime;
            this.lastChangeTime = lastChangeTime;
            this.errorMessage = errorMessage;
        }

        public TriggerStatus(long lastRunTime, long theNextRunTime, TriggerStatus old) {
            this.lastRunTime = lastRunTime;
            this.nextRunTime = theNextRunTime;
            this.lastChangeTime = old != null ? old.lastChangeTime : 0L;
            this.errorMessage = old != null ? old.errorMessage : null;
        }
    }

    public static enum TriggerPayloadType {
        None,
        Full,
        Delta;

    }
}

