/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import com.google.common.base.CharMatcher;
import com.stardog.stark.IRI;
import com.stardog.stark.Values;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PercentEncoding {
    private static final Logger log = LoggerFactory.getLogger(PercentEncoding.class);
    private static final CharMatcher URI_RESERVED_CHARACTER_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"-._~")).negate().precomputed();
    private static final CharMatcher IRI_RESERVED_CHARACTER_MATCHER = CharMatcher.javaLetterOrDigit().or(CharMatcher.anyOf((CharSequence)"-._~")).or(CharMatcher.inRange((char)'\u00a0', (char)'\uffff')).negate().precomputed();
    private static final int PERCENT_CODEPOINT = "%".codePointAt(0);

    public static String decodeIri(String encodedIri) {
        int i = encodedIri.indexOf(37);
        if (i == -1) {
            return encodedIri;
        }
        int length = encodedIri.length();
        StringBuilder strBuilder = new StringBuilder(encodedIri.substring(0, i));
        byte[] bytes = encodedIri.substring(i).getBytes(StandardCharsets.UTF_8);
        int bytesPos = 0;
        int j = i;
        while (j < length) {
            int cp = encodedIri.codePointAt(j);
            if (cp == PERCENT_CODEPOINT && j <= length - 3 && PercentEncoding.isHexDigit(encodedIri.charAt(j + 1)) && PercentEncoding.isHexDigit(encodedIri.charAt(j + 2))) {
                bytes[bytesPos++] = (byte)Integer.parseInt(encodedIri.substring(j + 1, j + 3), 16);
                j += 3;
                continue;
            }
            if (cp == PERCENT_CODEPOINT) {
                log.warn("Error decoding an encoded IRI ({}). Expected two hex digits following % character. Found: {}", (Object)encodedIri, (Object)encodedIri.substring(j, j + 3 <= length ? j + 3 : length));
            }
            int cpCharCount = Character.charCount(cp);
            byte[] cpBytes = encodedIri.substring(j, j + cpCharCount).getBytes(StandardCharsets.UTF_8);
            System.arraycopy(cpBytes, 0, bytes, bytesPos, cpBytes.length);
            bytesPos += cpBytes.length;
            j += cpCharCount;
        }
        String decodedSegment = new String(bytes, 0, bytesPos, StandardCharsets.UTF_8);
        return strBuilder.append(decodedSegment).toString();
    }

    private static boolean isHexDigit(char theCh) {
        return Character.isDigit(theCh) || theCh >= 'A' && theCh <= 'F' || theCh >= 'a' && theCh <= 'f';
    }

    private static String encode(String s, CharMatcher matcher) {
        int numChars;
        int i = matcher.indexIn((CharSequence)s);
        if (i == -1) {
            return s;
        }
        int length = s.length();
        StringBuilder strBuilder = new StringBuilder(s.substring(0, i));
        for (int j = i; j < length; j += numChars) {
            int cp = s.codePointAt(j);
            char c = s.charAt(j);
            numChars = Character.charCount(cp);
            if (numChars > 1 || matcher.matches(c)) {
                byte[] byteSequence;
                for (byte b : byteSequence = new String(new int[]{cp}, 0, 1).getBytes(StandardCharsets.UTF_8)) {
                    strBuilder.append(String.format("%%%02X", b));
                }
                continue;
            }
            strBuilder.append(c);
        }
        return strBuilder.toString();
    }

    public static String encodeIri(String iri) {
        return PercentEncoding.encode(iri, IRI_RESERVED_CHARACTER_MATCHER);
    }

    public static String encodeUri(String uri) {
        return PercentEncoding.encode(uri, URI_RESERVED_CHARACTER_MATCHER);
    }

    public static String encodeNullableIri(String iri) {
        return iri == null ? "" : PercentEncoding.encodeIri(iri);
    }

    public static boolean isAcceptableIri(String iri) {
        return Values.isValid((IRI)Values.iri((String)iri)) && !iri.contains(" ");
    }
}

