/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import java.util.EnumSet;

public enum KernelEventType {
    CreateDatabase(0),
    DropDatabase(1),
    Online(2),
    Offline(3),
    Shutdown(4),
    Copy(5),
    Migrate(6),
    Optimize(7),
    GetOption(8),
    SetOption(9),
    ConnectionOpen(10),
    ConnectionClose(11),
    Authentication(12),
    TxBegin(13),
    TxCommit(14),
    TxRollback(15),
    DataAdd(16),
    DataRemove(17),
    DataRemoveContext(18),
    DataRemoveAll(19),
    Query(20),
    AddUser(21),
    DeleteUser(22),
    AddGenericSecurityResource(23),
    DeleteGenericSecurityResource(24),
    ChangePassword(25),
    ChangeUserEnabled(26),
    ListUsers(27),
    GetSuperStatus(28),
    GetEnabledStatus(29),
    SetEnabledStatus(30),
    SetSuperStatus(31),
    GetUserRoles(32),
    SetUserRoles(33),
    AddUserRole(34),
    DeleteUserRole(35),
    AddRole(36),
    DeleteRole(37),
    ListRoles(38),
    GetUsersWithRole(39),
    UserPermissionGrant(40),
    UserPermissionRevoke(41),
    RolePermissionGrant(42),
    RolePermissionRevoke(43),
    GetUserPermissions(44),
    GetRolePermissions(45),
    GetEffectiveUserPermissions(46),
    QueryEnd(47),
    Startup(48),
    Backup(49),
    Restore(50),
    Repair(51),
    WildcardPermissionRevoke(52),
    StoredQueryAdded(53),
    StoredQueryUpdated(54),
    StoredQueryRemoved(55),
    ServerPropertyUpdated(56),
    Verify(57),
    GetAutoCreatedStatus(58),
    AddCacheTarget(59),
    RemoveCacheTarget(60),
    GetCacheTargets(61),
    AddCachedGraph(62),
    RemoveCachedGraph(63),
    RefreshCachedGraph(64),
    GetCachedGraphs(65),
    AddDataSource(66),
    UpdateDataSource(67),
    RemoveDataSource(68),
    GetDataSources(69),
    ShareDataSource(70),
    OnlineDataSource(71),
    RefreshDataSource(72),
    ReplaceDataSourceMetadata(73),
    SyncVirtualGraphRegistryCache(74),
    InitializeVirtualGraphRegistry(75),
    AddVirtualGraph(76),
    RemoveVirtualGraph(77),
    GetVirtualGraphs(78),
    GetVirtualGraphMappings(79),
    OnlineVirtualGraph(80),
    GetDataSourceMetadata(81),
    GetDataSourceTables(82),
    GetTableMetadata(83),
    MaterializationCompleted(84),
    ClusterJoin(85),
    ClusterLeaving(86),
    RenameDatabase(87),
    DataExport(88),
    GetLogs(89);

    public static final EnumSet<KernelEventType> CONNECTION_EVENTS;
    private final int mValue;

    public static boolean isConnectionEvent(KernelEventType theType) {
        return CONNECTION_EVENTS.contains((Object)theType);
    }

    private KernelEventType(int theValue) {
        this.mValue = theValue;
    }

    public int value() {
        return this.mValue;
    }

    public static KernelEventType valueOf(int theValue) {
        for (KernelEventType aType : KernelEventType.values()) {
            if (aType.value() != theValue) continue;
            return aType;
        }
        throw new IllegalArgumentException("Unknown kernel event type");
    }

    static {
        CONNECTION_EVENTS = EnumSet.of(ConnectionOpen, new KernelEventType[]{ConnectionClose, TxBegin, TxCommit, TxRollback, DataAdd, DataRemove, DataRemoveAll, DataRemoveContext, Query, DataExport});
    }
}

