/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import com.complexible.common.base.DateTime;
import com.complexible.stardog.KernelEvent;
import com.complexible.stardog.KernelEventType;
import com.complexible.stardog.QueryInfo;
import com.google.common.base.Joiner;
import jakarta.xml.bind.DatatypeConverter;
import java.util.Calendar;
import java.util.Collections;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.Set;

public class KernelEventLogging {
    public static final Set<Field> DEFAULT_FIELDS = Collections.unmodifiableSet(EnumSet.complementOf(EnumSet.of(Field.FILE, Field.QUERY)));

    public static Field getField(String fieldName) {
        return KernelEventLogging.enumOf(Field.class, fieldName);
    }

    public static String getFormattedFieldValue(KernelEvent theEvent, Field theField) {
        Object aValue = KernelEventLogging.getFieldValue(theEvent, theField);
        if (aValue == null) {
            return null;
        }
        switch (theField.ordinal()) {
            case 1: {
                return DatatypeConverter.printDateTime((Calendar)((Calendar)aValue));
            }
            case 8: {
                return Joiner.on((String)", ").join((Iterable)aValue) + " ";
            }
        }
        return aValue.toString();
    }

    public static Object getFieldValue(KernelEvent theEvent, Field theField) {
        switch (theField.ordinal()) {
            case 1: {
                return new DateTime(theEvent.getTimestamp()).toCalendar();
            }
            case 2: {
                return theEvent.getType();
            }
            case 3: {
                return theEvent.getDB();
            }
            case 4: {
                return theEvent.getUser();
            }
            case 5: {
                return theEvent.getIP();
            }
            case 6: {
                return theEvent.getValue();
            }
            case 7: {
                return KernelEventLogging.extractQuery(theEvent.getValue());
            }
            case 8: {
                return theEvent.getFlags();
            }
        }
        throw new AssertionError((Object)("Invalid field " + String.valueOf((Object)theField)));
    }

    private static String extractQuery(Object theValue) {
        String valueStr;
        int queryStart;
        if (theValue instanceof QueryInfo) {
            return ((QueryInfo)theValue).getQuery();
        }
        if (theValue instanceof String && (queryStart = (valueStr = (String)theValue).indexOf("):\n")) >= 0) {
            return valueStr.substring(queryStart + 3);
        }
        return null;
    }

    public static Object parseFieldValue(Field theField, String theValue) {
        switch (theField.ordinal()) {
            case 1: {
                return KernelEventLogging.parseDate(theValue);
            }
            case 2: {
                return KernelEventLogging.enumOf(KernelEventType.class, theValue);
            }
            case 6: {
                throw new UnsupportedOperationException("Filters cannot be defined on the 'value' field");
            }
            case 8: {
                return KernelEventLogging.enumOf(KernelEvent.Flags.class, theValue);
            }
        }
        return theValue;
    }

    private static GregorianCalendar parseDate(String theStr) {
        try {
            return (GregorianCalendar)DatatypeConverter.parseDateTime((String)theStr);
        }
        catch (Exception exception) {
            try {
                return (GregorianCalendar)DatatypeConverter.parseDate((String)theStr);
            }
            catch (Exception exception2) {
                throw new IllegalArgumentException("Invalid date/time value: " + theStr);
            }
        }
    }

    private static <T extends Enum<T>, E extends Enum<E>> T enumOf(Class<T> theClass, String theName) {
        try {
            return Enum.valueOf(theClass, theName);
        }
        catch (Exception e) {
            for (Enum aEnum : (Enum[])theClass.getEnumConstants()) {
                if (!aEnum.name().equalsIgnoreCase(theName)) continue;
                return (T)aEnum;
            }
            throw new IllegalArgumentException("Not a valid " + theClass.getSimpleName() + ": " + theName);
        }
    }

    public static enum Field {
        FILE,
        TIME,
        EVENT,
        DATABASE,
        USER,
        IP,
        VALUE,
        QUERY,
        FLAGS;

    }
}

