/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import com.complexible.common.base.Copyable;
import com.complexible.common.base.Copyables;
import com.complexible.stardog.KernelEventType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.EnumSet;

public final class KernelEvent<T>
implements Serializable,
Copyable<KernelEvent<T>> {
    private static final long serialVersionUID = -393305977833382281L;
    private final KernelEventType mType;
    private final String mDb;
    private final T mValue;
    private final String mUser;
    private final String mIP;
    private final long mTimestamp;
    private final long mNanoTime = System.nanoTime();
    private final EnumSet<Flags> mFlags;
    private final transient boolean mEndOfBatch;

    private KernelEvent(KernelEventBuilder<T> theBuilder) {
        this.mDb = theBuilder.mDb;
        this.mType = theBuilder.mType;
        this.mValue = theBuilder.mValue;
        this.mIP = theBuilder.mIP;
        this.mUser = theBuilder.mUser;
        this.mTimestamp = theBuilder.mTimestamp;
        this.mFlags = theBuilder.mFlags;
        this.mEndOfBatch = theBuilder.mEndOfBatch;
    }

    private KernelEvent(KernelEvent<T> theEvent) {
        this.mDb = theEvent.mDb;
        this.mType = theEvent.mType;
        this.mTimestamp = theEvent.mTimestamp;
        this.mUser = theEvent.mUser;
        this.mIP = theEvent.mIP;
        this.mValue = Copyables.copy(theEvent.getValue());
        this.mFlags = EnumSet.copyOf(theEvent.mFlags);
        this.mEndOfBatch = theEvent.mEndOfBatch;
    }

    public String getUser() {
        return this.mUser;
    }

    public String getDB() {
        return this.mDb;
    }

    public String getIP() {
        return this.mIP;
    }

    public KernelEventType getType() {
        return this.mType;
    }

    public T getValue() {
        return this.mValue;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    @VisibleForTesting
    public long getNanoTime() {
        return this.mNanoTime;
    }

    public EnumSet<Flags> getFlags() {
        return EnumSet.copyOf(this.mFlags);
    }

    public boolean isEndOfBatch() {
        return this.mEndOfBatch;
    }

    public boolean is(Flags theFlag) {
        return this.mFlags.contains((Object)theFlag);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mType, this.mUser, this.mIP, this.mFlags, this.mDb, this.mValue});
    }

    public String toString() {
        return String.format("KernelEvent[type=%s, user=%s, ip=%s, db=%s, value=%s, flags=%s]", new Object[]{this.getType(), this.getUser(), this.getIP(), this.getDB(), this.getValue(), this.getFlags()});
    }

    public KernelEvent<T> copy() {
        return new KernelEvent<T>(this);
    }

    public boolean equals(Object theObject) {
        if (theObject == this) {
            return true;
        }
        if (theObject == null) {
            return false;
        }
        if (theObject.getClass().equals(this.getClass())) {
            KernelEvent aEvent = (KernelEvent)theObject;
            return this.mType == aEvent.getType() && Objects.equal((Object)this.mUser, (Object)aEvent.mUser) && Objects.equal((Object)this.mIP, (Object)aEvent.mIP) && Objects.equal(this.mFlags, aEvent.mFlags) && Objects.equal((Object)this.mDb, (Object)aEvent.mDb) && Objects.equal(this.mValue, aEvent.mValue);
        }
        return false;
    }

    public KernelEventBuilder<T> toBuilder() {
        return KernelEvent.builder(this.mType, Copyables.copy(this.mValue)).user(this.mUser).ip(this.mIP).flags(this.mFlags).db(this.mDb).timestamp(this.mTimestamp).endOfBatch(this.mEndOfBatch);
    }

    public static KernelEvent<?> of(KernelEventType theType) {
        return KernelEvent.builder(theType).create();
    }

    public static <T> KernelEventBuilder<T> builder(KernelEventType theType, T theValue) {
        return new KernelEventBuilder<T>(theType).value(theValue);
    }

    public static <T> KernelEventBuilder<T> builder(KernelEventType theType) {
        return new KernelEventBuilder(theType);
    }

    public static class KernelEventBuilder<T> {
        private String mUser = null;
        private String mIP = null;
        private KernelEventType mType;
        private T mValue;
        private String mDb = null;
        private long mTimestamp = System.currentTimeMillis();
        private EnumSet<Flags> mFlags = EnumSet.noneOf(Flags.class);
        private boolean mEndOfBatch = false;

        KernelEventBuilder(KernelEventType theType) {
            this.mType = theType;
        }

        public KernelEventBuilder<T> db(String theDb) {
            this.mDb = theDb;
            return this;
        }

        public KernelEventBuilder<T> user(String theUser) {
            this.mUser = theUser;
            return this;
        }

        public KernelEventBuilder<T> timestamp(long theDate) {
            this.mTimestamp = theDate;
            return this;
        }

        public KernelEventBuilder<T> ip(String theIP) {
            this.mIP = theIP;
            return this;
        }

        public KernelEventBuilder<T> type(KernelEventType theType) {
            this.mType = theType;
            return this;
        }

        public KernelEventBuilder<T> value(T theValue) {
            this.mValue = theValue;
            return this;
        }

        public KernelEventBuilder<T> flag(Flags theFlag) {
            this.mFlags.add(theFlag);
            return this;
        }

        public KernelEventBuilder<T> flags(EnumSet<Flags> theFlags) {
            this.mFlags = theFlags;
            return this;
        }

        public KernelEventBuilder<T> failure() {
            return this.flags(EnumSet.of(Flags.Failure));
        }

        public KernelEventBuilder<T> endOfBatch(boolean eob) {
            this.mEndOfBatch = eob;
            return this;
        }

        public KernelEventBuilder<T> endOfBatch() {
            return this.endOfBatch(true);
        }

        public KernelEvent<T> create() {
            Preconditions.checkState((this.mType != null ? 1 : 0) != 0, (Object)"Must specify a type for the kernel event");
            return new KernelEvent(this);
        }
    }

    public static enum Flags {
        Failure,
        Timeout,
        Killed;

    }
}

