/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import com.complexible.common.base.Numbers;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JsonQueryPlan {
    private static final Pattern NEXT_NUMBER = Pattern.compile("^(\\d(\\d|\\.)*[A-Z]?)(\\s|,|;).*$");
    private static final Pattern QUERY_TIME = Pattern.compile(".*Query executed in\\s(?<time>\\S+)\\sms.+$");
    private static final Pattern QUERY_RESULTS = Pattern.compile(".*returned\\s(?<results>\\S+)\\sresult.+$");
    private static final Pattern QUERY_MEMORY = Pattern.compile("^Total used memory:\\s(?<mem>\\S+)(,.+$|$)");
    private static final Pattern PRE_EXECUTION = Pattern.compile(".*Pre-execution.+:\\s(?<time>\\S+)\\sms.+$");

    private static JSONObject jsonifyPlanNode(List<String> thePlanNode) throws JSONException {
        Pattern aMagicRegex = Pattern.compile("^([\\s\u2502+\u2500`]*)(.*)$");
        ArrayList aJustNodes = Lists.newArrayList();
        ArrayList aWhitespaceLength = Lists.newArrayList();
        thePlanNode.forEach(theNode -> {
            Matcher m = aMagicRegex.matcher((CharSequence)theNode);
            if (m.find()) {
                aWhitespaceLength.add(m.group(1).length());
                aJustNodes.add(m.group(2));
            }
        });
        return JsonQueryPlan.jsonifyPlanNode(aJustNodes, aWhitespaceLength);
    }

    private static JSONObject jsonifyPlanNode(List<String> thePlanNode, List<Integer> theWhitespaces) throws JSONException {
        String aLine;
        JSONObject aObj = new JSONObject();
        StringBuilder aAllLines = new StringBuilder(thePlanNode.get(0));
        int offset = 0;
        while (thePlanNode.get(offset).endsWith(";")) {
            aAllLines.append("\n").append(thePlanNode.get(++offset));
        }
        String aLabel = aLine = aAllLines.toString().trim();
        Pattern aNodeWithCardinalityRegex = Pattern.compile("^(.*)\\s\\[#(.*)\\].*$");
        Matcher aMatcher = aNodeWithCardinalityRegex.matcher(aLine);
        if (aMatcher.find()) {
            aLabel = aMatcher.group(1).trim();
            aObj.put("cardinality", (Object)Numbers.fromReadable((String)aMatcher.group(2).replace("#", "")));
        }
        JsonQueryPlan.jsonifyProfilerData(aLine, aObj);
        if (aLabel.equals("{")) {
            aObj.put("label", (Object)"GroupGraphPattern");
        } else if (aLabel.endsWith("{")) {
            aObj.put("label", (Object)aLabel.substring(0, aLabel.length() - 1).trim());
        } else {
            aObj.put("label", (Object)aLabel);
        }
        JSONArray aChildren = new JSONArray();
        if (!JsonQueryPlan.isTerminalNode(aLabel) && theWhitespaces.size() > offset + 1) {
            int aChildIndent = theWhitespaces.get(offset + 1);
            List aIndexesOfChildren = IntStream.range(offset, theWhitespaces.size()).boxed().filter(idx -> ((Integer)theWhitespaces.get((int)idx)).equals(aChildIndent)).collect(Collectors.toList());
            if (aIndexesOfChildren.size() == 1) {
                aChildren.put((Object)JsonQueryPlan.jsonifyPlanNode(thePlanNode.subList(offset + 1, thePlanNode.size()), theWhitespaces.subList(offset + 1, theWhitespaces.size())));
            } else {
                for (int j = 0; j < aIndexesOfChildren.size(); ++j) {
                    if (thePlanNode.get((Integer)aIndexesOfChildren.get(j)).equals("}")) continue;
                    Integer aStart = (Integer)aIndexesOfChildren.get(j);
                    Integer aEnd = j < aIndexesOfChildren.size() - 1 ? ((Integer)aIndexesOfChildren.get(j + 1)).intValue() : theWhitespaces.size();
                    aChildren.put((Object)JsonQueryPlan.jsonifyPlanNode(thePlanNode.subList(aStart, aEnd), theWhitespaces.subList(aStart, aEnd)));
                }
            }
        }
        aObj.put("children", (Object)aChildren);
        return aObj;
    }

    private static boolean isTerminalNode(String planNodeLine) {
        return planNodeLine.startsWith("VirtualGraph");
    }

    private static void jsonifyProfilerData(String theLine, JSONObject theObj) throws JSONException {
        String results = " results: ";
        String wt = " wall time: ";
        String mem = " memory: ";
        String spilled = " spilled to disk: ";
        JsonQueryPlan.parseNumber(theLine, wt, "time", theObj);
        JsonQueryPlan.parseNumber(theLine, mem, "memory", theObj);
        JsonQueryPlan.parseNumber(theLine, spilled, "spilled", theObj);
        JsonQueryPlan.parseNumber(theLine, results, "results", theObj);
        if (theLine.contains("with gaps")) {
            theObj.put("gaps", (Object)"true");
        }
    }

    private static void parseNumber(String theLine, String thePattern, String theKey, JSONObject theObj) throws JSONException {
        String total = "{total=";
        int idx = theLine.indexOf(thePattern);
        if (idx >= 0) {
            Matcher matcher;
            String line = theLine.substring(idx + thePattern.length());
            if (line.startsWith(total)) {
                line = line.substring(total.length());
            }
            if ((matcher = NEXT_NUMBER.matcher(line)).matches()) {
                theObj.put(theKey, (Object)matcher.group(1).trim());
            }
        }
    }

    private static String stripTrailingComment(String s) {
        if (s.startsWith("#")) {
            return "";
        }
        int idx = s.lastIndexOf(" # ");
        return idx < 0 ? s : s.substring(0, idx);
    }

    public static JSONObject renderAsJson(String theExplain) throws JSONException {
        JSONObject aRoot = new JSONObject();
        List<String> aList = Arrays.asList(theExplain.split("\\n"));
        aList = aList.stream().map(JsonQueryPlan::stripTrailingComment).collect(Collectors.toList());
        aList = aList.subList(aList.indexOf("The Query Plan:") + 1, aList.size());
        int aProfileHeaderIndex = aList.indexOf("Profiling results:");
        int aStart = 0;
        if (aProfileHeaderIndex >= 0) {
            JSONObject aProfilerHeader = new JSONObject();
            aStart = JsonQueryPlan.jsonifyProfilerHeader(aList, aProfilerHeader, aProfileHeaderIndex);
            aRoot.put("profiler", (Object)aProfilerHeader);
        }
        JSONObject aPrefixes = new JSONObject();
        Pattern aPrefixPattern = Pattern.compile("prefix(\\s*\\S*):\\s*<(\\S+)>");
        for (int i = aStart; i < aList.size(); ++i) {
            if (aList.get(i).trim().equals("")) continue;
            Matcher aMatcher = aPrefixPattern.matcher(aList.get(i).trim());
            if (aMatcher.find()) {
                aPrefixes.put(aMatcher.group(1).trim(), (Object)aMatcher.group(2).trim());
                continue;
            }
            aList = aList.subList(i, aList.size());
            break;
        }
        JSONObject aDataset = new JSONObject();
        while (true) {
            String aDatasetStr = aList.get(0).toLowerCase();
            Optional<String> aPossibleMatch = Lists.newArrayList((Object[])new String[]{"from named", "from", "insert into", "delete from"}).stream().filter(aDatasetStr::startsWith).findFirst();
            if (!aPossibleMatch.isPresent()) break;
            String scopeStr = aPossibleMatch.get();
            String aGraph = aDatasetStr.substring(scopeStr.length()).trim();
            String scopeKey = scopeStr.toLowerCase().replace(" ", "_");
            if (aGraph.startsWith("<")) {
                aGraph = aGraph.substring(1, aGraph.length() - 1);
            }
            if (!aDataset.has(scopeKey)) {
                aDataset.put(scopeKey, (Object)new JSONArray());
            }
            aDataset.getJSONArray(scopeKey).put((Object)aGraph);
            aList = aList.subList(1, aList.size());
        }
        JSONObject aPlan = JsonQueryPlan.jsonifyPlanNode(aList);
        return aRoot.put("prefixes", (Object)aPrefixes).put("dataset", (Object)aDataset).put("plan", (Object)aPlan);
    }

    private static int jsonifyProfilerHeader(List<String> theLines, JSONObject theProfilerHeader, int theProfileHeaderIndex) throws JSONException {
        for (int i = theProfileHeaderIndex; i <= theLines.size(); ++i) {
            Matcher matcher;
            String line = theLines.get(i).trim();
            if (line.startsWith("Query executed in")) {
                int errIndex;
                int resIndex;
                String time;
                matcher = QUERY_TIME.matcher(line);
                if (matcher.matches() && !Strings.isNullOrEmpty((String)(time = matcher.group("time")))) {
                    theProfilerHeader.put("time", (Object)time);
                    theProfilerHeader.put("time unit", (Object)"ms");
                }
                if ((resIndex = line.lastIndexOf(" and returned ")) >= 0 && (matcher = QUERY_RESULTS.matcher(line.substring(resIndex))).matches()) {
                    theProfilerHeader.put("results", (Object)matcher.group("results"));
                }
                if ((errIndex = line.lastIndexOf("hit an error:")) < 0) continue;
                theProfilerHeader.put("error", (Object)line.substring(errIndex + "hit an error:".length() + 1));
                continue;
            }
            if (line.startsWith("Total used memory: ")) {
                String mem;
                matcher = QUERY_MEMORY.matcher(line);
                if (!matcher.matches() || Strings.isNullOrEmpty((String)(mem = matcher.group("mem")))) continue;
                theProfilerHeader.put("memory", (Object)mem);
                continue;
            }
            if (line.startsWith("Pre-execution: ")) {
                String time;
                matcher = PRE_EXECUTION.matcher(line);
                if (!matcher.matches() || Strings.isNullOrEmpty((String)(time = matcher.group("time")))) continue;
                theProfilerHeader.put("pre-execution", (Object)time);
                continue;
            }
            if (!line.isEmpty() && !line.startsWith("prefix") && !line.startsWith("From")) continue;
            return i;
        }
        return theLines.size();
    }
}

