/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import com.complexible.common.io.Files2;
import com.complexible.stardog.StardogException;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Environment {
    private static final Logger LOGGER = LoggerFactory.getLogger(Environment.class);
    public static final String STARDOG_HOME_PROP = "stardog.home";
    private static final String STARDOG_HOME_ENV = "STARDOG_HOME";
    private static final String STARDOG_INSTALL_PROP = "stardog.install.location";
    private static final String STARDOG_INSTALL_ENV = "STARDOG_HOME";

    private Environment() {
        throw new AssertionError();
    }

    public static void assertHome() {
        String aHome = System.getProperty(STARDOG_HOME_PROP);
        if (Strings.isNullOrEmpty((String)aHome)) {
            System.setProperty(STARDOG_HOME_PROP, Environment.getHome());
        }
    }

    public static void checkHome(File theHome) {
        if (!theHome.exists()) {
            System.out.println(String.format("STARDOG_HOME directory '%s' does not exist", theHome.getAbsolutePath()));
            System.exit(1);
        }
        if (!theHome.isDirectory()) {
            System.out.println(String.format("STARDOG_HOME directory '%s' is not a directory", theHome.getAbsolutePath()));
            System.exit(1);
        }
        if (!theHome.canRead()) {
            System.out.println(String.format("STARDOG_HOME directory '%s' is not readable by the current user", theHome.getAbsolutePath()));
            System.exit(1);
        }
        if (!theHome.canWrite()) {
            System.out.println(String.format("STARDOG_HOME directory '%s' is not writeable by the current user", theHome.getAbsolutePath()));
            System.exit(1);
        }
        try {
            Path tempFile = Files.createTempFile(theHome.toPath(), "stardog", ".tmp", new FileAttribute[0]);
            Files.delete(tempFile);
        }
        catch (IOException e) {
            System.out.println(String.format("STARDOG_HOME directory '%s' is not writeable by the current user", theHome.getAbsolutePath()));
            System.exit(1);
        }
    }

    public static String getHome() {
        String aHome = System.getProperty(STARDOG_HOME_PROP);
        if (!Strings.isNullOrEmpty((String)aHome)) {
            return aHome;
        }
        return !Strings.isNullOrEmpty((String)System.getenv("STARDOG_HOME")) ? System.getenv("STARDOG_HOME") : (!Strings.isNullOrEmpty((String)System.getProperty(STARDOG_INSTALL_PROP)) ? System.getProperty(STARDOG_INSTALL_PROP) : (!Strings.isNullOrEmpty((String)System.getProperty("STARDOG_HOME")) ? System.getProperty("STARDOG_HOME") : System.getProperty("user.dir")));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Path createSpillingDir(String theSpillingDirName, Path theBaseDir) {
        Path aSpillingDir = Paths.get(theSpillingDirName, new String[0]);
        if (!aSpillingDir.isAbsolute()) {
            aSpillingDir = theBaseDir.resolve(theSpillingDirName);
        }
        if (Files.exists(aSpillingDir, new LinkOption[0])) {
            try {
                if (Files.isDirectory(aSpillingDir, new LinkOption[0])) {
                    Files2.deleteDirectoryContents((Path)aSpillingDir);
                    return aSpillingDir;
                }
                if (Files.isDirectory(aSpillingDir, new LinkOption[0])) return aSpillingDir;
                Path aOldSpillingDir = aSpillingDir;
                aSpillingDir = Files2.createTempDir();
                LOGGER.warn("Spilling directory " + String.valueOf(aOldSpillingDir) + " is not a valid directory. Using temporary directory " + String.valueOf(aSpillingDir));
                return aSpillingDir;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Files.createDirectories(aSpillingDir, new FileAttribute[0]);
            return aSpillingDir;
        }
        catch (IOException theE) {
            String message = "Unable to create the spilling directory: " + String.valueOf(aSpillingDir);
            LOGGER.error(message);
            throw new StardogException(message, theE);
        }
    }

    public static void deleteSpillingDir(Path theSpillingDir) {
        try {
            if (theSpillingDir != null) {
                Files2.deleteRecursively((Path)theSpillingDir);
            }
        }
        catch (IOException theE) {
            String message = "Unable to clean up the spilling directory: " + String.valueOf(theSpillingDir);
            LOGGER.error(message, (Throwable)theE);
        }
    }
}

