/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;

public final class Contexts {
    public static final IRI DEFAULT = Values.DEFAULT_GRAPH;
    public static final IRI LOCAL = Values.LOCAL_GRAPHS;
    public static final IRI NAMED = Values.NAMED_GRAPHS;
    public static final IRI VIRTUAL = Values.VIRTUAL_GRAPHS;
    public static final IRI ALL = Values.ALL_GRAPHS;

    private Contexts() {
        throw new AssertionError();
    }

    public static boolean isAllOrLocal(Resource theContext) {
        return Contexts.isAll(theContext) || Contexts.isLocal(theContext);
    }

    public static boolean isAllOrLocal(Collection<? extends Resource> theContexts) {
        return theContexts.contains(ALL) || theContexts.contains(LOCAL);
    }

    public static boolean isAll(Resource theContext) {
        return theContext == ALL || ALL.equals((Object)theContext);
    }

    public static boolean isLocal(Resource theContext) {
        return theContext == LOCAL || LOCAL.equals((Object)theContext);
    }

    public static boolean isNamed(Resource theContext) {
        return theContext == NAMED || NAMED.equals((Object)theContext);
    }

    public static boolean isVirtualWildcard(Resource theContext) {
        return theContext == VIRTUAL || VIRTUAL.equals((Object)theContext);
    }

    public static Resource nullToDefault(Resource theResource) {
        return theResource == null ? DEFAULT : theResource;
    }

    public static Resource defaultToNull(Resource theResource) {
        return DEFAULT.equals((Object)theResource) ? null : theResource;
    }

    public static <T extends Value> Predicate<T> isDefaultGraph() {
        return theValue -> theValue instanceof Resource && Values.isDefaultGraph((Resource)((Resource)theValue));
    }

    public static boolean isWildcard(Resource theContext) {
        return Contexts.isAllOrLocal(theContext) || Contexts.isNamed(theContext) || Contexts.isVirtualWildcard(theContext);
    }

    public static boolean isDefaultGraphOrWildcard(Resource theContext) {
        return Values.isDefaultGraph((Resource)theContext) || Contexts.isWildcard(theContext);
    }

    public static boolean isSingleton(Set<Resource> theContexts) {
        return theContexts.size() == 1 && !Contexts.isWildcard(theContexts.iterator().next());
    }

    public static boolean isVirtualOrVirtualWildcard(Resource g) {
        return Contexts.isVirtualWildcard(g) || Values.isVirtual((Resource)g);
    }
}

